/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import common.blocks.Block_ItemServerDrive;
import common.blocks.Block_ItemServerIOPort;
import common.blocks.Block_ItemServerRackCasing;
import common.tileentities.TE_ItemServerIOPort;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.ArrayList;
import java.util.HashSet;
import kekztech.MultiItemHandler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import util.MultiBlockTooltipBuilder;
import util.Vector3i;
import util.Vector3ic;

public class GTMTE_ItemServer
extends GT_MetaTileEntity_MultiBlockBase {
    private static final int BASE_SEGMENT_ENERGY_COST = 1;
    private static final int BASE_PER_ITEM_CAPACITY = 1024;
    private static final int BASE_ITEM_TYPES_PER_SEGMENT = 4;
    private final Block_ItemServerDrive DRIVE = (Block_ItemServerDrive)Blocks.itemServerDrive;
    private final Block_ItemServerRackCasing CASING = (Block_ItemServerRackCasing)Blocks.itemServerRackCasing;
    private final Block_ItemServerIOPort IO_PORT = (Block_ItemServerIOPort)Blocks.itemServerIOPort;
    private final String ALU_FRAME_BOX_NAME = "gt.blockmachines";
    private final int ALU_FRAME_BOX_META = 6;
    private final int CASING_TEXTURE_ID = 176;
    private MultiItemHandler mih;
    private HashSet<TE_ItemServerIOPort> ioPorts = new HashSet();
    private int sliceCount = 0;

    public GTMTE_ItemServer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_ItemServer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_ItemServer(this.mName);
    }

    public String[] getDescription() {
        MultiBlockTooltipBuilder b = new MultiBlockTooltipBuilder();
        b.addInfo("[W.I.P - Probably doesn't work]").addInfo("High-Tech item storage!").addInfo("Variable length: Slices 2-4 can be repeated as long as the total length does not exceed 16 blocks.").addInfo("Each segment offers storage for 128 item types").addInfo("Storage capacity per item depends on the controller configuration.").addInfo("Insert an Integrated Circuit into the controller with your desired configuration.").addInfo("The base configuration (0) is 1024 items per type. For each higher level, the capacity quadruples.").addInfo("Each slice also adds 1EU/t of power consumption and doubles with rising configuration values.").addInfo("Valid config values are from zero to eight.").addSeparator().beginStructureBlock(3, 5, 4).addController("Front Bottom Center").addEnergyHatch("Any casing").addOtherStructurePart("Front slice", "3x5x1 Item Server Rack Casing").addOtherStructurePart("2nd and 3rd slice, center", "1x4x1 Aluminium Frame Box").addOtherStructurePart("2nd and 3rd slice, top", "3x1x1 Item Server Rack Casing").addOtherStructurePart("2nd and 3rd slice, sides", "2x 1x4x1 Item Server Drive").addOtherStructurePart("Back slice", "3x5x1 Item Server Rack Casing").signAndFinalize("Kekzdealer");
        if (!Keyboard.isKeyDown((int)42)) {
            return b.getInformation();
        }
        return b.getStructureInformation();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[1][48];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.casingTexturePages[1][48];
        }
        return iTextureArray;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack var1) {
        return true;
    }

    public boolean checkRecipe(ItemStack guiSlotItem) {
        int config = guiSlotItem != null && guiSlotItem.func_77977_a().equals("gt.integrated_circuit") ? Math.min(8, guiSlotItem.func_77960_j()) : 0;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mEUt = (int)(-((double)(1 * this.sliceCount) * Math.pow(2.0, config)));
        this.mMaxProgresstime = 20;
        this.mih.setPerTypeCapacity((int)(1024.0 * Math.pow(4.0, config)));
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mih != null) {
            this.mih.setLock(!super.getBaseMetaTileEntity().isActive());
        }
    }

    public Vector3ic rotateOffsetVector(Vector3ic forgeDirection, int x, int y, int z) {
        Vector3i offset = new Vector3i();
        if (forgeDirection.x() == 0 && forgeDirection.z() == -1) {
            offset.x = x;
            offset.y = y;
            offset.z = z;
        }
        if (forgeDirection.x() == 0 && forgeDirection.z() == 1) {
            offset.x = -x;
            offset.y = y;
            offset.z = -z;
        }
        if (forgeDirection.x() == -1 && forgeDirection.z() == 0) {
            offset.x = z;
            offset.y = y;
            offset.z = -x;
        }
        if (forgeDirection.x() == 1 && forgeDirection.z() == 0) {
            offset.x = -z;
            offset.y = y;
            offset.z = x;
        }
        return offset;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        Vector3i forgeDirection = new Vector3i(ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetY, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ);
        boolean formationChecklist = true;
        for (int X = -1; X <= 1; ++X) {
            for (int Y = 0; Y <= 4; ++Y) {
                Vector3ic offset;
                IGregTechTileEntity currentTE;
                if (X == 0 && Y == 0 || super.addMaintenanceToMachineList(currentTE = thisController.getIGregTechTileEntityOffset((offset = this.rotateOffsetVector(forgeDirection, X, Y, 0)).x(), offset.y(), offset.z()), 176) || super.addEnergyInputToMachineList(currentTE, 176) || thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.IO_PORT) {
                    TE_ItemServerIOPort port = (TE_ItemServerIOPort)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                    this.ioPorts.add(port);
                    continue;
                }
                formationChecklist = false;
            }
        }
        int segmentsFound = 0;
        int zOffset = -1;
        while (segmentsFound < 5) {
            if (this.checkSegment(thisController, forgeDirection, zOffset)) {
                zOffset -= 3;
                System.out.println("Item Server segment approved: " + ++segmentsFound);
                continue;
            }
            System.out.println("Item Server segment rejected: " + (segmentsFound + 1));
            break;
        }
        if (segmentsFound < 1) {
            System.out.println("At least one slice required for storage");
            formationChecklist = false;
        }
        if (this.mEnergyHatches.size() < 1) {
            System.out.println("At least one energy hatch is required!");
            formationChecklist = false;
        }
        if (this.mMaintenanceHatches.size() < 1) {
            System.out.println("You need a maintenance hatch to do maintenance.");
            formationChecklist = false;
        }
        if (formationChecklist) {
            this.sliceCount = segmentsFound;
            if (this.mih == null) {
                this.mih = new MultiItemHandler();
                this.mih.setItemTypeCapacity(segmentsFound * 4);
            }
            System.out.println("Configuring " + this.ioPorts.size() + " ports");
            for (TE_ItemServerIOPort port : this.ioPorts) {
                port.setMultiItemHandler(this.mih);
            }
        }
        return formationChecklist;
    }

    public boolean checkSegment(IGregTechTileEntity thisController, Vector3ic forgeDirection, int zOffset) {
        boolean formationChecklist = true;
        for (int Z = 0; Z >= -2; --Z) {
            TE_ItemServerIOPort port;
            IGregTechTileEntity currentTE;
            Vector3ic offset;
            int Y;
            int X;
            if (Z != -2) {
                for (X = -1; X <= 1; ++X) {
                    for (Y = 0; Y <= 4; ++Y) {
                        offset = this.rotateOffsetVector(forgeDirection, X, Y, zOffset + Z);
                        if (Y == 4) {
                            currentTE = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                            if (super.addMaintenanceToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176) || thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING) continue;
                            if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.IO_PORT) {
                                port = (TE_ItemServerIOPort)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                                this.ioPorts.add(port);
                                continue;
                            }
                            formationChecklist = false;
                            continue;
                        }
                        if (Y <= 3 && X == 0) {
                            if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals("gt.blockmachines") && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 6) continue;
                            formationChecklist = false;
                            continue;
                        }
                        if (Y > 3 || X == 0 || thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.DRIVE) continue;
                        formationChecklist = false;
                    }
                }
                continue;
            }
            for (X = -1; X <= 1; ++X) {
                for (Y = 0; Y <= 4; ++Y) {
                    offset = this.rotateOffsetVector(forgeDirection, X, Y, zOffset + Z);
                    currentTE = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                    if (super.addMaintenanceToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176) || thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING) continue;
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.IO_PORT) {
                        port = (TE_ItemServerIOPort)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                        this.ioPorts.add(port);
                        continue;
                    }
                    formationChecklist = false;
                }
            }
        }
        return formationChecklist;
    }

    public String[] getInfoData() {
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("Per-Item Capacity: " + this.mih.getPerTypeCapacity());
        ll.add("Item-Type Capacity: " + 4 * this.sliceCount);
        ll.add("Running Cost: " + -this.mEUt * 10000 / Math.max(1000, this.mEfficiency) + "EU/t");
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        super.saveNBTData(nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        super.loadNBTData(nbt);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack var1) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack var1) {
        return 0;
    }

    public int getDamageToComponent(ItemStack var1) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack var1) {
        return false;
    }
}

