/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class CarpentersBlocks {

    public static class CommonHandler
    implements ModBlockDelegate.IModBlockHandler {
        private static final String MODID = "CarpentersBlocks";
        private static final String TAG_ATTR_LIST = "cbAttrList";
        private static final String TAG_ID = "id";
        private static final String TAG_DAMAGE = "Damage";

        @Override
        public boolean initialize(BlockMD blockMD) {
            GameRegistry.UniqueIdentifier uid = blockMD.getUid();
            if (uid.modId.equals(MODID)) {
                if (uid.name.equals("blockCarpentersTorch")) {
                    blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow);
                } else {
                    if (uid.name.equals("blockCarpentersLadder")) {
                        blockMD.addFlags(BlockMD.Flag.OpenToSky);
                        blockMD.setModBlockHandler(this);
                        return true;
                    }
                    blockMD.setModBlockHandler(this);
                    return true;
                }
            }
            return false;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
            int blockZ;
            int blockX = chunkMD.toWorldX(localX);
            TileEntity tileEntity = ForgeHelper.INSTANCE.getTileEntity(blockX, y, blockZ = chunkMD.toWorldZ(localZ));
            if (tileEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tileEntity.func_145841_b(tag);
                if (!tag.func_82582_d()) {
                    int meta = 0;
                    NBTTagList attrs = tag.func_150295_c(TAG_ATTR_LIST, 10);
                    String idString = attrs.func_150305_b(0).func_74779_i(TAG_ID);
                    if (idString.length() > 0) {
                        int id = Integer.parseInt(idString.substring(0, idString.length() - 1));
                        String idMeta = attrs.func_150305_b(0).func_74779_i(TAG_DAMAGE);
                        if (idMeta.length() > 0) {
                            meta = Integer.parseInt(idMeta.substring(0, idMeta.length() - 1));
                        }
                        Block block = (Block)GameData.getBlockRegistry().func_148754_a(id);
                        blockMD = BlockMD.get(block, meta);
                    }
                }
            }
            return blockMD;
        }
    }
}

