package mods.immibis.microblocks.coremod;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

import mods.immibis.core.api.APILocator;
import mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker;
import mods.immibis.microblocks.DoublePacket;
import mods.immibis.microblocks.PacketMicroblockContainerDescription;
import mods.immibis.microblocks.api.IMicroblockCoverSystem;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

import org.objectweb.asm.*;
import org.objectweb.asm.util.CheckClassAdapter;

import com.google.common.collect.ObjectArrays;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;

public class MicroblockSupporterTransformer implements net.minecraft.launchwrapper.IClassTransformer {
	/** Marker interface for transformed blocks that don't use tile entities by default */
	public static interface TilelessTransformedBlock {}
	
	public static Set<String> blockClasses = new HashSet<String>();
	public static Set<String> tileClasses = new HashSet<String>();
	public static Set<String> blockClassesUsingDummyTE = new HashSet<String>();
	
	private static final FMLDeobfuscatingRemapper R = FMLDeobfuscatingRemapper.INSTANCE;
	
	private static final String AXISALIGNEDBB = "net/minecraft/util/AxisAlignedBB";
	private static final String WORLD = "net/minecraft/world/World";
	private static final String IBLOCKACCESS = "net/minecraft/world/IBlockAccess";
	private static final String ENTITY = "net/minecraft/entity/Entity";
	private static final String TILEENTITY = "net/minecraft/tileentity/TileEntity";
	private static final String ENTITYPLAYER = "net/minecraft/entity/player/EntityPlayer";
	private static final String PACKET = "net/minecraft/network/Packet";
	private static final String NBTTAGCOMPOUND = "net/minecraft/nbt/NBTTagCompound";
	private static final String MOVINGOBJECTPOSITION = "net/minecraft/util/MovingObjectPosition";
	private static final String VEC3 = "net/minecraft/util/Vec3";
	private static final String ITEMSTACK = "net/minecraft/item/ItemStack";
	
	private static final MethodMatcher BLOCK_ADDCOLLISIONBOXESTOLIST =
		new MethodMatcher("net/minecraft/block/Block", "addCollisionBoxesToList", "func_149743_a", "a", "(L"+WORLD+";IIIL"+AXISALIGNEDBB+";Ljava/util/List;L"+ENTITY+";)V");
	private static final MethodMatcher BLOCK_GETRENDERTYPE =
		new MethodMatcher("net/minecraft/block/Block", "getRenderType", "func_149645_b", "b", "()I");
	private static final MethodMatcher TILEENTITY_GETDESCRIPTIONPACKET =
		new MethodMatcher("net/minecraft/tileentity/TileEntity", "getDescriptionPacket", "func_145844_m", "m", "()Lnet/minecraft/network/Packet;");
	private static final MethodMatcher TILEENTITY_WRITETONBT =
		new MethodMatcher("net/minecraft/tileentity/TileEntity", "writeToNBT", "func_145841_b", "b", "(Lnet/minecraft/nbt/NBTTagCompound;)V");
	private static final MethodMatcher TILEENTITY_READFROMNBT =
		new MethodMatcher("net/minecraft/tileentity/TileEntity", "readFromNBT", "func_145839_a", "a", "(Lnet/minecraft/nbt/NBTTagCompound;)V");
	private static final MethodMatcher BLOCK_COLLISIONRAYTRACE =
		new MethodMatcher("net/minecraft/block/Block", "collisionRayTrace", "func_149731_a", "a", "(L"+WORLD+";IIIL"+VEC3+";L"+VEC3+";)L"+MOVINGOBJECTPOSITION+";");
	private static final MethodMatcher BLOCK_GETPICKBLOCK =
		new MethodMatcher("net/minecraft/block/Block", "getPickBlock", "getPickBlock", "getPickBlock", "(L"+MOVINGOBJECTPOSITION+";L"+WORLD+";IIIL"+ENTITYPLAYER+";)Lnet/minecraft/item/ItemStack;");
	private static final MethodMatcher BLOCK_ISSIDESOLID = 
		new MethodMatcher("net/minecraft/block/Block", "isSideSolid", "isSideSolid", "isSideSolid", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z");
	private static final MethodMatcher BLOCK_DROPBLOCKASITEMWITHCHANCE =
		new MethodMatcher("net/minecraft/block/Block", "dropBlockAsItemWithChance", "func_149690_a", "a", "(L"+WORLD+";IIIIFI)V");
	private static final MethodMatcher BLOCK_ADDBLOCKHITEFFECTS =
		new MethodMatcher("net/minecraft/block/Block", "addHitEffects", "addHitEffects", "addHitEffects", "(L"+WORLD+";L"+MOVINGOBJECTPOSITION+";Lnet/minecraft/client/particle/EffectRenderer;)Z");
	private static final MethodMatcher BLOCK_HASTILEENTITY =
		new MethodMatcher("net/minecraft/block/Block", "hasTileEntity", "hasTileEntity", "hasTileEntity", "(I)Z");
	
	private static class ClassVisitorBase extends ClassVisitor {
		public ClassVisitorBase(int api, ClassVisitor parent) {
			super(api, parent);
		}
		
		public void generateAndTransformMethod(ClassVisitor unused, String superclass, int access, MethodMatcher m) {
			generateAndTransformMethod(unused, superclass, access, m.getName(), m.getDesc());
		}
		
		public void generateAndTransformMethod(ClassVisitor unused, String superclass, int access, String name, String desc) {
			Type methodType = Type.getMethodType(desc);
			
			MethodVisitor mv = visitMethod(access, name, desc, null, new String[0]);
			
			mv.visitCode();
			
			// push 'this'
			if((access & Opcodes.ACC_STATIC) == 0)
				mv.visitVarInsn(Opcodes.ALOAD, 0);
			
			// push arguments
			int stackPos = 1;
			for(Type pt : methodType.getArgumentTypes()) {
				switch(pt.getSort()) {
				case Type.ARRAY: case Type.OBJECT:
					mv.visitVarInsn(Opcodes.ALOAD, stackPos++);
					break;
				case Type.BOOLEAN: case Type.BYTE: case Type.CHAR: case Type.INT: case Type.SHORT:
					mv.visitVarInsn(Opcodes.ILOAD, stackPos++);
					break;
				case Type.DOUBLE:
					mv.visitVarInsn(Opcodes.DLOAD, stackPos);
					stackPos += 2;
					break;
				case Type.FLOAT:
					mv.visitVarInsn(Opcodes.FLOAD, stackPos++);
					break;
				case Type.LONG:
					mv.visitVarInsn(Opcodes.LLOAD, stackPos);
					stackPos += 2;
					break;
				}
			}
			
			// call superclass method
			mv.visitMethodInsn(Opcodes.INVOKESPECIAL, superclass, name, desc, false);
			
			// return result
			switch(methodType.getReturnType().getSort()) {
			case Type.ARRAY: case Type.OBJECT:
				mv.visitInsn(Opcodes.ARETURN);
				break;
			case Type.BOOLEAN: case Type.BYTE: case Type.CHAR: case Type.INT: case Type.SHORT:
				mv.visitInsn(Opcodes.IRETURN);
				break;
			case Type.DOUBLE:
				mv.visitInsn(Opcodes.DRETURN);
				break;
			case Type.FLOAT:
				mv.visitInsn(Opcodes.FRETURN);
				break;
			case Type.LONG:
				mv.visitInsn(Opcodes.LRETURN);
				break;
			case Type.VOID:
				mv.visitInsn(Opcodes.RETURN);
				break;
			}
			
			int nArgs = methodType.getArgumentsAndReturnSizes() >> 2;
			int nRets = methodType.getArgumentsAndReturnSizes() & 3;
			mv.visitMaxs(nArgs + 1, Math.max(nArgs + 1, nRets));
			mv.visitEnd();
		}
	}
	
	// This basically merges the code from BlockMultipartBase into any Block class, but with extra checks that the tile is actually an IMultipartTile.
	// See BlockMultipartBase to see what it needs to add to make blocks into multipart blocks.
	// If useDefaultTE is true, it also adds the interface TilelessTransformedBlock
	private static class BlockTransformerVisitor extends ClassVisitorBase {
		private boolean useDefaultTE;
		public BlockTransformerVisitor(ClassVisitor parent, boolean useDefaultTE) {
			super(Opcodes.ASM4, parent);
			this.useDefaultTE = useDefaultTE;
		}
		
		public static class TransformMethodVisitor_getPickBlock extends MethodVisitor {
			
			public TransformMethodVisitor_getPickBlock(MethodVisitor mv) {
				super(Opcodes.ASM5, mv);
			}
			
			/*
			 * Add at start:
			 * 
			 * ItemStack temp = MSTHooks.hook_getPickBlock(par1MovingObjectPosition, par2World, par3X, par4Y, par5Z, par6Player);
			 * if(temp != null)
			 * 	   return temp;
			 */
			
			@Override
			public void visitCode() {
				super.visitCode();
				
				Label ifNull = new Label();
				
				super.visitVarInsn(Opcodes.ALOAD, 1);
				super.visitVarInsn(Opcodes.ALOAD, 2);
				super.visitVarInsn(Opcodes.ILOAD, 3);
				super.visitVarInsn(Opcodes.ILOAD, 4);
				super.visitVarInsn(Opcodes.ILOAD, 5);
				super.visitVarInsn(Opcodes.ALOAD, 6);
				super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "hook_getPickBlock", "(L"+MOVINGOBJECTPOSITION+";L"+WORLD+";IIIL"+ENTITYPLAYER+";)L"+ITEMSTACK+";", false);
				super.visitInsn(Opcodes.DUP);
				super.visitJumpInsn(Opcodes.IFNULL, ifNull);
				super.visitInsn(Opcodes.ARETURN);
				
				super.visitLabel(ifNull);
				super.visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {ITEMSTACK});
				super.visitInsn(Opcodes.POP);
			}
			
			@Override
			public void visitMaxs(int maxStack, int maxLocals) {
				if(maxStack < 6)
					maxStack = 6;
				super.visitMaxs(maxStack, maxLocals);
			}
		}
		
		public static class TransformMethodVisitor_isSideSolid extends MethodVisitor {
			
			public TransformMethodVisitor_isSideSolid(MethodVisitor mv) {
				super(Opcodes.ASM4, mv);
			}
			
			/*
			 * Add at start:
			 * 
			 * if(MSTHooks.hook_isSideSolid(par1World, par2X, par3Y, par4Z, par5ForgeDirection))
			 *     return true;
			 */
			
			@Override
			public void visitCode() {
				super.visitCode();
				
				Label ifFalse = new Label();
				
				super.visitVarInsn(Opcodes.ALOAD, 1);
				super.visitVarInsn(Opcodes.ILOAD, 2);
				super.visitVarInsn(Opcodes.ILOAD, 3);
				super.visitVarInsn(Opcodes.ILOAD, 4);
				super.visitVarInsn(Opcodes.ALOAD, 5);
				super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "hook_isSideSolid", "(L"+IBLOCKACCESS+";IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false);
				super.visitJumpInsn(Opcodes.IFEQ, ifFalse);
				super.visitInsn(Opcodes.ICONST_1);
				super.visitInsn(Opcodes.IRETURN);
				
				super.visitLabel(ifFalse);
				super.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
			}
			
			@Override
			public void visitMaxs(int maxStack, int maxLocals) {
				if(maxStack < 5)
					maxStack = 5;
				super.visitMaxs(maxStack, maxLocals);
			}
		}
		
		public static class TransformMethodVisitor_collisionRayTrace extends MethodVisitor {
			public TransformMethodVisitor_collisionRayTrace(MethodVisitor mv) {
				super(Opcodes.ASM5, mv);
			}
			
			// Replace "return x" with "return MSTHooks.hook_collisionRayTrace(x, other args...)"
			
			@Override
			public void visitInsn(int opcode) {
				if(opcode == Opcodes.ARETURN)
				{
					super.visitVarInsn(Opcodes.ALOAD, 1);
					super.visitVarInsn(Opcodes.ILOAD, 2);
					super.visitVarInsn(Opcodes.ILOAD, 3);
					super.visitVarInsn(Opcodes.ILOAD, 4);
					super.visitVarInsn(Opcodes.ALOAD, 5);
					super.visitVarInsn(Opcodes.ALOAD, 6);
					super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "hook_collisionRayTrace", "(L"+MOVINGOBJECTPOSITION+";L"+WORLD+";IIIL"+VEC3+";L"+VEC3+";)L"+MOVINGOBJECTPOSITION+";", false);
				}
				super.visitInsn(opcode);
			}
		}

		public static class TransformMethodVisitor_addCollidingBlockToList extends MethodVisitor {
			
			public TransformMethodVisitor_addCollidingBlockToList(MethodVisitor mv) {
				super(Opcodes.ASM5, mv);
			}
			
			/*
			 * Add at start:
			 * MSTHooks.hook_addCollisionBoxesToList(world, x, y, z, mask, list, entity);
			 */

			@Override
			public void visitCode() {
				super.visitCode();
				
				super.visitVarInsn(Opcodes.ALOAD, 1); // par1World
				super.visitVarInsn(Opcodes.ILOAD, 2); // par2X
				super.visitVarInsn(Opcodes.ILOAD, 3); // par3Y
				super.visitVarInsn(Opcodes.ILOAD, 4); // par4Z
				super.visitVarInsn(Opcodes.ALOAD, 5); // par5Mask
				super.visitVarInsn(Opcodes.ALOAD, 6); // par6List
				super.visitVarInsn(Opcodes.ALOAD, 7); // par7Entity
				super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "hook_addCollisionBoxesToList", "(L"+WORLD+";IIIL"+AXISALIGNEDBB+";Ljava/util/List;Lnet/minecraft/entity/Entity;)V", false);
				
			}
			
			@Override
			public void visitMaxs(int maxStack, int maxLocals) {
				if(maxStack < 7)
					maxStack = 7;
				super.visitMaxs(maxStack, maxLocals);
			}
		}
		
		public static class TransformMethodVisitor_addBlockHitEffects extends MethodVisitor {
			public TransformMethodVisitor_addBlockHitEffects(MethodVisitor parent) {
				super(Opcodes.ASM4, parent);
			}
			
			@Override
			public void visitCode() {
				super.visitCode();
				
				Label ifFalse = new Label();
				
				visitVarInsn(Opcodes.ALOAD, 1);
				visitVarInsn(Opcodes.ALOAD, 2);
				visitVarInsn(Opcodes.ALOAD, 3);
				visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "hook_addHitEffects", BLOCK_ADDBLOCKHITEFFECTS.getDesc(), false);
				visitJumpInsn(Opcodes.IFEQ, ifFalse);
				visitInsn(Opcodes.ICONST_1);
				visitInsn(Opcodes.IRETURN);
				
				visitLabel(ifFalse);
				visitFrame(Opcodes.F_SAME, 0, null, 0, null);
			}
			
			@Override
			public void visitMaxs(int maxStack, int maxLocals) {
				if(maxStack < 3)
					maxStack = 3;
				super.visitMaxs(maxStack, maxLocals);
			}
		}
		
		@SuppressWarnings("unused")
		public String className, superclass;
		
		public boolean saw_addCollidingBlockToList;
		public boolean saw_collisionRayTrace;
		public boolean saw_getPickBlock;
		public boolean saw_isBlockSolidOnSide;
		public boolean saw_addBlockHitEffects;
		
		@Override
		public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
			className = name;
			superclass = superName;
			
			String newInterfaces[] = new String[(interfaces == null ? 0 : interfaces.length) + 1 + (useDefaultTE ? 1 : 0)];
			if(interfaces != null)
				System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
			newInterfaces[newInterfaces.length - 1] = IMultipartRenderingBlockMarker.class.getName().replace('.', '/');
			if(useDefaultTE)
				newInterfaces[newInterfaces.length - 2] = "mods/immibis/microblocks/coremod/MicroblockSupporterTransformer$TilelessTransformedBlock";
			
			super.visit(version, access, name, signature, superName, newInterfaces);
		}
		
		@Override
		public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
			
			MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
			
			if(BLOCK_COLLISIONRAYTRACE.matches(name, desc)) {
				saw_collisionRayTrace = true;
				mv = new TransformMethodVisitor_collisionRayTrace(mv);
			}
			
			if(BLOCK_ADDCOLLISIONBOXESTOLIST.matches(name, desc)) {
				saw_addCollidingBlockToList = true;
				mv = new TransformMethodVisitor_addCollidingBlockToList(mv);
			}
			
			if(BLOCK_GETPICKBLOCK.matches(name, desc)) {
				saw_getPickBlock = true;
				mv = new TransformMethodVisitor_getPickBlock(mv);
			}
			
			if(BLOCK_ISSIDESOLID.matches(name, desc)) {
				saw_isBlockSolidOnSide = true;
				mv = new TransformMethodVisitor_isSideSolid(mv);
			}
			
			if(BLOCK_ADDBLOCKHITEFFECTS.matches(name, desc)) {
				saw_addBlockHitEffects = true;
				mv = new TransformMethodVisitor_addBlockHitEffects(mv);
			}
			
			return mv;
		}
		
		@Override
		public void visitEnd() {
			
			if(!saw_addCollidingBlockToList)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, BLOCK_ADDCOLLISIONBOXESTOLIST);
			
			if(!saw_collisionRayTrace)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, BLOCK_COLLISIONRAYTRACE);
			
			if(!saw_getPickBlock)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, BLOCK_GETPICKBLOCK);
			
			if(!saw_isBlockSolidOnSide)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, BLOCK_ISSIDESOLID);
			
			if(!saw_addBlockHitEffects && FMLLaunchHandler.side() == Side.CLIENT)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, BLOCK_ADDBLOCKHITEFFECTS);
			
			if(useDefaultTE)
			{
				/* public boolean hasTileEntity(int meta) {
					return true;
				} */
				MethodVisitor mv = super.visitMethod(Opcodes.ACC_PUBLIC, BLOCK_HASTILEENTITY.getName(), BLOCK_HASTILEENTITY.getDesc(), null, new String[0]);
				mv.visitCode();
				mv.visitInsn(Opcodes.ICONST_1);
				mv.visitInsn(Opcodes.IRETURN);
				mv.visitMaxs(1, 2);
				mv.visitEnd();
			}
			
			super.visitEnd();
		}
	}
	
	public static final String IMCS_FIELD = "ImmibisCoreMicroblockCoverSystem";
	
	private static class TileTransformerVisitor extends ClassVisitorBase {
		public TileTransformerVisitor(ClassVisitor parent, boolean isCoverable) {
			super(Opcodes.ASM4, parent);
		}
		
		private String position = "Centre";
		
		public String className, superclass;
		
		@Override
		public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
			interfaces = ObjectArrays.concat(interfaces, "mods/immibis/microblocks/api/IMicroblockSupporterTile");
			super.visit(version, access, name, signature, superName, interfaces);
			
			className = name;
			superclass = superName;
			
			FieldVisitor fv = super.visitField(Opcodes.ACC_PUBLIC, IMCS_FIELD, "Lmods/immibis/microblocks/api/IMicroblockCoverSystem;", null, null);
			fv.visitEnd();
			
			MethodVisitor mv;
			
			{
				Label l = new Label();
				
				mv = super.visitMethod(Opcodes.ACC_PUBLIC, "isPlacementBlocked", "(Lmods/immibis/microblocks/api/PartType;Lmods/immibis/microblocks/api/EnumPosition;)Z", null, new String[0]);
				mv.visitCode();
				mv.visitFieldInsn(Opcodes.GETSTATIC, "mods/immibis/microblocks/api/EnumPosition", position, "Lmods/immibis/microblocks/api/EnumPosition;");
				mv.visitVarInsn(Opcodes.ALOAD, 2);
				
				// return true if position argument = position of part
				mv.visitJumpInsn(Opcodes.IF_ACMPEQ, l);
				mv.visitInsn(Opcodes.ICONST_0);
				mv.visitInsn(Opcodes.IRETURN);
				
				mv.visitLabel(l);
				mv.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
				mv.visitInsn(Opcodes.ICONST_1);
				mv.visitInsn(Opcodes.IRETURN);
				
				mv.visitMaxs(2, 3);
				mv.visitEnd();
			}
			
			mv = super.visitMethod(Opcodes.ACC_PUBLIC, "getCoverSystem", "()Lmods/immibis/microblocks/api/IMicroblockCoverSystem;", null, new String[0]);
			mv.visitCode();
			mv.visitVarInsn(Opcodes.ALOAD, 0); // 'this'
			mv.visitFieldInsn(Opcodes.GETFIELD, className, IMCS_FIELD, "Lmods/immibis/microblocks/api/IMicroblockCoverSystem;");
			mv.visitInsn(Opcodes.ARETURN);
			mv.visitMaxs(1, 1);
			mv.visitEnd();
			
			mv = super.visitMethod(Opcodes.ACC_PUBLIC, "getCoverSystem", "()Lmods/immibis/core/api/multipart/ICoverSystem;", null, new String[0]);
			mv.visitCode();
			mv.visitVarInsn(Opcodes.ALOAD, 0); // 'this'
			mv.visitFieldInsn(Opcodes.GETFIELD, className, IMCS_FIELD, "Lmods/immibis/microblocks/api/IMicroblockCoverSystem;");
			mv.visitInsn(Opcodes.ARETURN);
			mv.visitMaxs(1, 1);
			mv.visitEnd();
		}
		
		private static class TransformMethodVisitor_NBT extends MethodVisitor {
			public String name;
			
			public TransformMethodVisitor_NBT(MethodVisitor parent, String name) {
				super(Opcodes.ASM4, parent);
				this.name = name;
			}
			
			@Override
			public void visitCode() {
				super.visitCode();
				
				visitVarInsn(Opcodes.ALOAD, 0); // this
				visitVarInsn(Opcodes.ALOAD, 1); // tag
				visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MicroblockSupporterTransformer$Util", name, "(L"+TILEENTITY+";L"+NBTTAGCOMPOUND+";)V", false);
			}
			
			@Override
			public void visitMaxs(int maxStack, int maxLocals) {
				if(maxStack < 2)
					maxStack = 2;
				
				super.visitMaxs(maxStack, maxLocals);
			}
		}
		
		private boolean saw_constructor;
		private boolean saw_getDescriptionPacket;
		private boolean saw_readFromNBT;
		private boolean saw_writeToNBT;
		private boolean saw_onMicroblocksChanged_hook;
		
		@Override
		public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
			MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
			
			if(name.equals("<init>")) {
				// create IMicroblockCoverSystem in constructor
				mv = new MethodVisitor(Opcodes.ASM4, mv) {
					@Override
					public void visitInsn(int opcode) {
						if(opcode == Opcodes.RETURN) {
							super.visitVarInsn(Opcodes.ALOAD, 0);
							super.visitInsn(Opcodes.DUP);
							super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/api/MicroblockAPIUtils", "createMicroblockCoverSystem", "(Lmods/immibis/microblocks/api/IMicroblockSupporterTile;)Lmods/immibis/microblocks/api/IMicroblockCoverSystem;", false);
							super.visitFieldInsn(Opcodes.PUTFIELD, className, IMCS_FIELD, "Lmods/immibis/microblocks/api/IMicroblockCoverSystem;");
						}
						
						super.visitInsn(opcode);
					}
					
					@Override
					public void visitMaxs(int maxStack, int maxLocals) {
						if(maxStack < 2)
							maxStack = 2;
						
						super.visitMaxs(maxStack, maxLocals);
					}
				};
				saw_constructor = true;
			}
			
			if(TILEENTITY_GETDESCRIPTIONPACKET.matches(name, desc)) {
				saw_getDescriptionPacket = true;
				
				mv = new MethodVisitor(Opcodes.ASM4, mv) {
					@Override
					public void visitInsn(int opcode) {
						if(opcode == Opcodes.ARETURN) {
							super.visitVarInsn(Opcodes.ALOAD, 0);
							super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MicroblockSupporterTransformer$Util", "getDescriptionPacket", "(L"+PACKET+";L"+TILEENTITY+";)L"+PACKET+";", false);
						}
						
						super.visitInsn(opcode);
					}
					
					@Override
					public void visitMaxs(int maxStack, int maxLocals) {
						if(maxStack < 2)
							maxStack = 2;
						
						super.visitMaxs(maxStack, maxLocals);
					}
				};
			}
			
			if(TILEENTITY_READFROMNBT.matches(name, desc)) {
				saw_readFromNBT = true;
				mv = new TransformMethodVisitor_NBT(mv, "readFromNBT");
			}
			
			if(TILEENTITY_WRITETONBT.matches(name, desc)) {
				saw_writeToNBT = true;
				mv = new TransformMethodVisitor_NBT(mv, "writeToNBT");
			}
			
			if(name.equals("ImmibisMicroblocks_onMicroblocksChanged") && desc.equals("()V")) {
				saw_onMicroblocksChanged_hook = true;
			}
			
			if(name.equals("ImmibisMicroblocks_isSideOpen") && desc.equals("(I)Z")) {
				mv.visitCode();
				mv.visitVarInsn(Opcodes.ALOAD, 0); // this
				mv.visitFieldInsn(Opcodes.GETFIELD, className, IMCS_FIELD, "Lmods/immibis/microblocks/api/IMicroblockCoverSystem;");
				mv.visitVarInsn(Opcodes.ILOAD, 1); // side
				mv.visitMethodInsn(Opcodes.INVOKEINTERFACE, "mods/immibis/microblocks/api/IMicroblockCoverSystem", "isSideOpen", "(I)Z", true);
				mv.visitInsn(Opcodes.IRETURN);
				mv.visitMaxs(2, 2);
				mv.visitEnd();
				
				mv = new MethodVisitor(Opcodes.ASM4) {};
			}
			
			
			
			return mv;
		}
		
		@Override
		public void visitEnd() {
		
			if(!saw_constructor)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, "<init>", "()V");
			
			if(!saw_getDescriptionPacket)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, TILEENTITY_GETDESCRIPTIONPACKET);
			
			if(!saw_readFromNBT)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, TILEENTITY_READFROMNBT);
			
			if(!saw_writeToNBT)
				generateAndTransformMethod(this, superclass, Opcodes.ACC_PUBLIC, TILEENTITY_WRITETONBT);
			
			{
				MethodVisitor mv = super.visitMethod(Opcodes.ACC_PUBLIC, "onMicroblocksChanged", "()V", null, new String[0]);
				mv.visitCode();
				if(saw_onMicroblocksChanged_hook) {
					mv.visitVarInsn(Opcodes.ALOAD, 0);
					mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, className, "ImmibisMicroblocks_onMicroblocksChanged", "()V", false);
				}
				mv.visitVarInsn(Opcodes.ALOAD, 0);
				mv.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/microblocks/coremod/MSTHooks", "onMicroblocksChanged", "(Lnet/minecraft/tileentity/TileEntity;)V", false);
				mv.visitInsn(Opcodes.RETURN);
				mv.visitMaxs(1, 1);
				mv.visitEnd();
			}
			
			super.visitEnd();
		}
	}
	
	@Deprecated private static String blockMarkerString = "ImmibissMicroblocks_TransformableBlockMarker";
	@Deprecated private static String tileMarkerString = "ImmibissMicroblocks_TransformableTileEntityMarker";
	@Deprecated private static byte[] blockMarkerBytes = blockMarkerString.getBytes(Charset.forName("utf-8"));
	@Deprecated private static byte[] tileMarkerBytes = tileMarkerString.getBytes(Charset.forName("utf-8"));
	private static String blockMarkerString2 = "ImmibisMicroblocks_TransformableBlockMarker";
	private static String tileMarkerString2 = "ImmibisMicroblocks_TransformableTileEntityMarker";
	private static String dummyTEMarkerString = "ImmibisMicroblocks_UseDummyTileMarker";
	private static byte[] blockMarkerBytes2 = blockMarkerString2.getBytes(Charset.forName("utf-8"));
	private static byte[] tileMarkerBytes2 = tileMarkerString2.getBytes(Charset.forName("utf-8"));

	@Override
	public byte[] transform(String originalName, String name, byte[] bytes) {
		
		if(bytes == null)
			return null;
		
		
		
		boolean useDummyTE = blockClassesUsingDummyTE.contains(name);
		boolean isBlock = useDummyTE || blockClasses.contains(name);
		boolean isTile = tileClasses.contains(name);
		
		if(!isBlock && !isTile) {
			if(containsBytes(bytes, blockMarkerBytes) || containsBytes(bytes, tileMarkerBytes) || containsBytes(bytes, blockMarkerBytes2) || containsBytes(bytes, tileMarkerBytes2)) {
				
				class CV extends ClassVisitor {
					boolean isBlock, isTile, useDummyTE;
					
					CV() {super(Opcodes.ASM4);}
					
					@Override
					public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
						if(name.equals(blockMarkerString) || name.equals(blockMarkerString2))
							isBlock = true;
						if(name.equals(tileMarkerString) || name.equals(tileMarkerString2))
							isTile = true;
						if(name.equals(dummyTEMarkerString))
							useDummyTE = true;
						return null;
					}
				}
				
				CV cv = new CV();
				new ClassReader(bytes).accept(cv, ClassReader.SKIP_CODE);
				isBlock = cv.isBlock;
				isTile = cv.isTile;
				useDummyTE = cv.useDummyTE;
			}
		}
		
		if(isBlock && isTile)
			throw new AssertionError("Configuration error: "+name+" is recognized as both a block class and a tile entity class");
		
		if(isBlock) {
			ClassWriter cw = new ClassWriter(0);
			new ClassReader(bytes).accept(new BlockTransformerVisitor(new CheckClassAdapter(cw), useDummyTE), 0);
			return cw.toByteArray();
		}
		
		if(isTile) {
			ClassWriter cw = new ClassWriter(0);
			new ClassReader(bytes).accept(new TileTransformerVisitor(new CheckClassAdapter(cw), true), 0);
			return cw.toByteArray();
		}
		
		return bytes;
	}
	
	
	
	private boolean containsBytes(byte[] haystack, byte[] needle) {
		int max = haystack.length - needle.length + 1;
		int i;
		
		for(int k = 0; k < max; k++) {
			for(i = 0; i < needle.length; i++)
				if(haystack[k+i] != needle[i])
					break;
			
			if(i == needle.length)
				return true;
		}
		
		return false;
	}



	public static final String NBT_FIELD_NAME = "ImmibisCoreMicroblocks";
	
	
	// called by generated code
	public static class Util {
		
		public static Packet getDescriptionPacket(Packet originalPacket, TileEntity te) {
			if(!(te instanceof IMicroblockSupporterTile))
				return originalPacket;
			
			IMicroblockCoverSystem mcs = ((IMicroblockSupporterTile)te).getCoverSystem();
			
			PacketMicroblockContainerDescription pmcd = new PacketMicroblockContainerDescription();
			pmcd.x = te.xCoord;
			pmcd.y = te.yCoord;
			pmcd.z = te.zCoord;
			pmcd.data = mcs.writeDescriptionBytes();
			Packet mbPacket = APILocator.getNetManager().wrap(pmcd, true);
			
			if(originalPacket != null) {
				return new DoublePacket(mbPacket, originalPacket);
			} else {
				return mbPacket;
			}
		}
		
		public static void writeToNBT(TileEntity te, NBTTagCompound tag) {
			if(te instanceof IMicroblockSupporterTile) {
				IMicroblockCoverSystem imcs = ((IMicroblockSupporterTile)te).getCoverSystem();
				
				if(imcs != null) {
					NBTTagCompound csTag = new NBTTagCompound();
					imcs.writeToNBT(csTag);
					tag.setTag(NBT_FIELD_NAME, csTag);
				}
			}
		}
		
		public static void readFromNBT(TileEntity te, NBTTagCompound tag) {
			if(te instanceof IMicroblockSupporterTile) {
				IMicroblockCoverSystem imcs = ((IMicroblockSupporterTile)te).getCoverSystem();
			
				if(imcs != null && tag.hasKey(NBT_FIELD_NAME))
					imcs.readFromNBT(tag.getCompoundTag(NBT_FIELD_NAME));
			}
		}
	}
}
