/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.network.packet;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class HEPacketSynchronize
implements IMessage {
    public int[] blocksX = new int[HEConfig.maxDams];
    public int[] blocksY = new int[HEConfig.maxDams];
    public int[] blocksZ = new int[HEConfig.maxDams];
    public float[] waterLevels = new float[HEConfig.maxDams];
    public HE.DamMode[] modes = new HE.DamMode[HEConfig.maxDams];
    public int[] limitsWest = new int[HEConfig.maxDams];
    public int[] limitsDown = new int[HEConfig.maxDams];
    public int[] limitsNorth = new int[HEConfig.maxDams];
    public int[] limitsEast = new int[HEConfig.maxDams];
    public int[] limitsUp = new int[HEConfig.maxDams];
    public int[] limitsSouth = new int[HEConfig.maxDams];
    public boolean[] enabledTiers;

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.blocksX = new int[length];
        this.blocksY = new int[length];
        this.blocksZ = new int[length];
        this.waterLevels = new float[length];
        this.modes = new HE.DamMode[length];
        this.limitsWest = new int[length];
        this.limitsDown = new int[length];
        this.limitsNorth = new int[length];
        this.limitsEast = new int[length];
        this.limitsUp = new int[length];
        this.limitsSouth = new int[length];
        for (int waterId = 0; waterId < length; ++waterId) {
            this.blocksX[waterId] = buf.readInt();
            this.blocksY[waterId] = buf.readInt();
            this.blocksZ[waterId] = buf.readInt();
            this.waterLevels[waterId] = buf.readFloat();
            this.modes[waterId] = HE.DamMode.getMode(buf.readInt());
            this.limitsWest[waterId] = buf.readInt();
            this.limitsDown[waterId] = buf.readInt();
            this.limitsNorth[waterId] = buf.readInt();
            this.limitsEast[waterId] = buf.readInt();
            this.limitsUp[waterId] = buf.readInt();
            this.limitsSouth[waterId] = buf.readInt();
        }
        int enabledTiersLength = buf.readInt();
        this.enabledTiers = new boolean[enabledTiersLength];
        for (int tierId = 0; tierId < enabledTiersLength; ++tierId) {
            this.enabledTiers[tierId] = buf.readBoolean();
        }
        HEConfig.clippingOffset = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(HEConfig.maxDams);
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            buf.writeInt(this.blocksX[waterId]);
            buf.writeInt(this.blocksY[waterId]);
            buf.writeInt(this.blocksZ[waterId]);
            buf.writeFloat(this.waterLevels[waterId]);
            buf.writeInt(this.modes[waterId].getValue());
            buf.writeInt(this.limitsWest[waterId]);
            buf.writeInt(this.limitsDown[waterId]);
            buf.writeInt(this.limitsNorth[waterId]);
            buf.writeInt(this.limitsEast[waterId]);
            buf.writeInt(this.limitsUp[waterId]);
            buf.writeInt(this.limitsSouth[waterId]);
        }
        buf.writeInt(this.enabledTiers.length);
        for (int tierId = 0; tierId < this.enabledTiers.length; ++tierId) {
            buf.writeBoolean(this.enabledTiers[tierId]);
        }
        buf.writeFloat(HEConfig.clippingOffset);
    }

    public static class Handler
    implements IMessageHandler<HEPacketSynchronize, IMessage> {
        public IMessage onMessage(HEPacketSynchronize message, MessageContext ctx) {
            HEClient.onSynchronize(message.blocksX, message.blocksY, message.blocksZ, message.waterLevels, message.modes, message.limitsWest, message.limitsDown, message.limitsNorth, message.limitsEast, message.limitsUp, message.limitsSouth, message.enabledTiers);
            return null;
        }
    }
}

