/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy;

import com.sinthoras.hydroenergy.blocks.HEWaterStill;
import com.sinthoras.hydroenergy.client.gui.HEGuiHandler;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.fluids.HEPressurizedWater;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import gregtech.api.enums.GT_Values;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HE {
    public static SimpleNetworkWrapper network;
    private static Logger LOG;
    public static final int maxRenderDist = 16;
    public static final int numChunksY = 16;
    public static final int waterOpacity = 3;
    public static final int chunkWidth = 16;
    public static final int chunkHeight = 16;
    public static final int chunkDepth = 16;
    public static final int blockPerSubChunk = 4096;
    public static final int underWaterSkylightDepth;
    public static final int controllerGuiUpdateDelay = 200;
    public static final int bucketToMilliBucket = 1000;
    public static final int kiloBucketToMilliBucket = 1000000;
    public static boolean logicalClientLoaded;
    public static final String ERROR_serverIdsOutOfBounds = "Server uses invalid waterIds! Server message ignored. Please make sure your config \"maxControllers\" is at least as big as the server you are connecting to!";
    public static final String WARN_clientConfigMissmatchDetected = "HydroEnergy: Configuration missmatch to the server found! This might crash somewhat randomly. Please talk to your server admin!";
    public static final String blueprintHintTecTech;
    public static HEPressurizedWater pressurizedWater;
    public static final HEWaterStill[] waterBlocks;
    public static final int[] waterBlockIds;
    public static ItemStack hydroDamControllerBlock;
    public static ItemStack[] hydroPumpBlocks;
    public static ItemStack[] hydroTurbineBlocks;
    public static boolean DEBUGslowFill;
    public static final IGuiHandler guiHandler;
    public static String damBackgroundLocation;
    public static String damLimitBackgroundLocation;
    public static String dummyTexture;

    public static void debug(String message) {
        LOG.debug(HE.formatMessage(message));
    }

    public static void info(String message) {
        LOG.info(HE.formatMessage(message));
    }

    public static void warn(String message) {
        LOG.warn(HE.formatMessage(message));
    }

    public static void error(String message) {
        LOG.error(HE.formatMessage(message));
    }

    private static String formatMessage(String message) {
        return "[HydroEnergy] " + message;
    }

    static {
        LOG = LogManager.getLogger((String)"hydroenergy");
        underWaterSkylightDepth = (int)Math.ceil(5.333333492279053);
        logicalClientLoaded = false;
        blueprintHintTecTech = "To see the structure, use a " + EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Blueprint on the Controller!";
        pressurizedWater = new HEPressurizedWater();
        waterBlocks = new HEWaterStill[HEConfig.maxDams];
        waterBlockIds = new int[HEConfig.maxDams];
        hydroPumpBlocks = new ItemStack[GT_Values.VN.length];
        hydroTurbineBlocks = new ItemStack[GT_Values.VN.length];
        DEBUGslowFill = false;
        guiHandler = new HEGuiHandler();
        damBackgroundLocation = "textures/gui/he_water_config.png";
        damLimitBackgroundLocation = "textures/gui/he_water_config_limits_popup.png";
        dummyTexture = damBackgroundLocation;
    }

    public static enum DamMode {
        DRAIN,
        DEBUG,
        SPREAD;


        public int getValue() {
            switch (this) {
                default: {
                    return 1;
                }
                case DEBUG: {
                    return 2;
                }
                case SPREAD: 
            }
            return 3;
        }

        public static DamMode getMode(int mode) {
            switch (mode) {
                default: {
                    return DRAIN;
                }
                case 2: {
                    return DEBUG;
                }
                case 3: 
            }
            return SPREAD;
        }
    }
}

