/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.network.container;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_Container_MultiMachineEM;
import com.sinthoras.hydroenergy.blocks.HEHydroDamTileEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class HEHydroDamEuContainer
extends GT_Container_MultiMachineEM {
    private long euStored;
    private long euCapacity;
    private int euPerTickIn;
    private int euPerTickOut;
    private long timestamp = 0L;
    private ByteBuffer buffer;
    private static final int parameterIdOffset = 21;

    public HEHydroDamEuContainer(InventoryPlayer inventoryPlayer, IGregTechTileEntity hydroDamMetaTileEntity) {
        super(inventoryPlayer, hydroDamMetaTileEntity, false, false, false);
    }

    public void func_75132_a(ICrafting clientHandle) {
        this.buffer.putLong(0, this.euStored);
        this.sendStateUpdate(clientHandle, 0);
        this.buffer.putLong(8, this.euCapacity);
        this.sendStateUpdate(clientHandle, 8);
        this.buffer.putInt(16, this.euPerTickIn);
        this.sendStateUpdate(clientHandle, 16);
        this.buffer.putInt(20, this.euPerTickOut);
        this.sendStateUpdate(clientHandle, 20);
        super.func_75132_a(clientHandle);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(24);
        }
        if (this.mTileEntity.isServerSide()) {
            HEHydroDamTileEntity hydroDamTileEntity = (HEHydroDamTileEntity)this.mTileEntity.getMetaTileEntity();
            long currentTime = System.currentTimeMillis();
            if (!this.mTileEntity.getWorld().field_72995_K && currentTime > 200L + this.timestamp) {
                boolean updateEuCapacity = false;
                long currentEuCapacity = hydroDamTileEntity.getEuCapacity();
                if (this.euCapacity != currentEuCapacity) {
                    this.euCapacity = currentEuCapacity;
                    this.buffer.putLong(8, this.euCapacity);
                    updateEuCapacity = true;
                }
                boolean updateEuStored = false;
                long currentEuStored = hydroDamTileEntity.getEuStored();
                if (this.euStored != currentEuStored) {
                    this.euStored = currentEuStored;
                    this.buffer.putLong(0, this.euStored);
                    updateEuStored = true;
                }
                boolean updateEuPerTickIn = false;
                int currentEuPerTickIn = hydroDamTileEntity.getEuPerTickIn();
                if (this.euPerTickIn != currentEuPerTickIn) {
                    this.euPerTickIn = currentEuPerTickIn;
                    this.buffer.putInt(16, this.euPerTickIn);
                    updateEuPerTickIn = true;
                }
                boolean updateEuPerTickOut = false;
                int currentEuPerTickOut = hydroDamTileEntity.getEuPerTickOut();
                if (this.euPerTickOut != currentEuPerTickOut) {
                    this.euPerTickOut = currentEuPerTickOut;
                    this.buffer.putInt(20, this.euPerTickOut);
                    updateEuPerTickOut = true;
                }
                for (ICrafting clientHandle : this.field_75149_d) {
                    if (updateEuCapacity) {
                        this.sendStateUpdate(clientHandle, 8);
                    }
                    if (updateEuStored) {
                        this.sendStateUpdate(clientHandle, 0);
                    }
                    if (updateEuPerTickIn) {
                        this.sendStateUpdate(clientHandle, 16);
                    }
                    if (!updateEuPerTickOut) continue;
                    this.sendStateUpdate(clientHandle, 20);
                }
                if (updateEuCapacity || updateEuStored || updateEuPerTickIn || updateEuPerTickOut) {
                    this.timestamp = currentTime;
                }
            }
        }
    }

    private void sendStateUpdate(ICrafting clientHandle, int bufferOffset) {
        int bytes = bufferOffset >= 16 ? 4 : 8;
        for (int i = 0; i < bytes; ++i) {
            int index = bufferOffset + i;
            clientHandle.func_71112_a((Container)this, index + 21, (int)this.buffer.get(index));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int index, int value) {
        super.func_75137_b(index, value);
        if ((index -= 21) >= 0 && index < this.buffer.capacity()) {
            this.buffer.put(index, (byte)value);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public long getEuStored() {
        return this.buffer.getLong(0);
    }

    @SideOnly(value=Side.CLIENT)
    public long getEuCapacity() {
        return this.buffer.getLong(8);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEuPerTickIn() {
        return this.buffer.getInt(16);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEuPerTickOut() {
        return this.buffer.getInt(20);
    }

    private class Buffer {
        public static final int euStoredOffset = 0;
        public static final int euCapacityOffset = 8;
        public static final int euPerTickInOffset = 16;
        public static final int euPerTickOutOffset = 20;

        private Buffer() {
        }
    }
}

