/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.config;

import com.sinthoras.hydroenergy.HEUtil;
import gregtech.api.enums.GT_Values;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class HEConfig {
    public static int maxDams = 16;
    public static int minimalWaterUpdateInterval = 1000;
    public static int delayBetweenSpreadingChunks = 2000;
    public static int minLightUpdateTimePerSubChunk = 10;
    public static float clippingOffset = 0.05f;
    public static List<Integer> dimensionIdWhitelist = new ArrayList<Integer>();
    public static int maxWaterSpreadWest = 1000;
    public static int maxWaterSpreadDown = 1000;
    public static int maxWaterSpreadNorth = 1000;
    public static int maxWaterSpreadEast = 1000;
    public static int maxWaterSpreadUp = 24;
    public static int maxWaterSpreadSouth = 1000;
    public static int damDrainPerSecond = 2048;
    public static float waterBonusPerSurfaceBlockPerRainTick = 1.0f;
    public static int blockIdOffset = 17000;
    public static float efficiencyLossPerTier = 0.03f;
    public static float pressureIncreasePerTier = 2.0f;
    public static float milliBucketPerEU = 1.0f;
    public static float euPerMilliBucket = 1.0f;
    public static boolean[] enabledTiers = new boolean[GT_Values.VN.length];
    public static boolean useLimitedRendering = false;
    public static boolean forceOpenGL = false;

    public static void syncronizeConfiguration(File configurationFile) {
        Configuration configuration = new Configuration(configurationFile);
        configuration.load();
        Property maxDamsProperty = configuration.get("General", "maxDams", 16, "[SERVER] How many dams should the game support. At least as many as the server you want to connect to. Each dam will receive its own water block and it will also have a minuscule performance impact. Keep it only as long as you need. You can always just raise, but not shorten the value.");
        maxDams = maxDamsProperty.getInt();
        if (maxDams != Math.max(1, maxDams)) {
            maxDams = 1;
            maxDamsProperty.set(1);
        }
        Property minimalWaterUpdateIntervalProperty = configuration.get("General", "minimalWaterUpdateInterval", 1000, "[SERVER] Minimum delay in milliseconds between update packets from the server to ALL clients.");
        minimalWaterUpdateInterval = minimalWaterUpdateIntervalProperty.getInt();
        Property spreadingDelayBetweenPerChunksProperty = configuration.get("General", "delayBetweenSpreadingChunks", 2000, "[SERVER] Delay in milliseconds the game will wait between processing a chunk for water spreading. Keep in mind, that a single tick takes care of a whole chunk between y=0 and y=255 at once!");
        delayBetweenSpreadingChunks = spreadingDelayBetweenPerChunksProperty.getInt();
        Property minLightUpdateTimePerSubChunkProperty = configuration.get("General", "minLightUpdateTimePerSubChunk", 10, "[CLIENT] Light calculation required all affected chunks to be rerendered. When a change in waterLevel induces rerendering it will also calculate a minimum delay before it can happen again. Light updates will not be lost, just delayed. For every subChunk (16 blocks high) that was rerendered because of this update event, the game will add the specified delay (in milliseconds) up for the actual delay. You should expect the number of rerendered subChunks to be in the low hundreds");
        minLightUpdateTimePerSubChunk = minLightUpdateTimePerSubChunkProperty.getInt();
        Property useLimitedRenderingProperty = configuration.get("General", "useLimitedRendering", false, "[CLIENT] Activate this if you have performance issues with the mod. But be warned: you will have limited render capabilities!");
        useLimitedRendering = useLimitedRenderingProperty.getBoolean();
        Property forceOpenGLProperty = configuration.get("General", "forceOpenGL", false, "[CLIENT] Some Macs may always report OpenGL 2.1 - activate this to disable the OpenGL 3.2 check; it will assume you have OpenGL 3.2 or greater. But be warned: it may crash!");
        forceOpenGL = forceOpenGLProperty.getBoolean();
        Property clippingOffsetProperty = configuration.get("General", "clippingOffset", (double)0.05f, "[SERVER + CLIENT] If water is sitting too narrow over a block there are graphical issues (Depth buffer resolution). To fix this, the game will not render a waterLevel that sits lower then the specified value over a block. This value is also used for physics calculation and is synced from the server all clients.");
        clippingOffset = (float)clippingOffsetProperty.getDouble();
        Property dimensionIdWhitelistProperties = configuration.get("General", "dimensionIdWhitelist", new int[]{0}, "[SERVER] List of dimension a player is allowed to place a controller");
        dimensionIdWhitelist.clear();
        for (int id : dimensionIdWhitelistProperties.getIntList()) {
            dimensionIdWhitelist.add(id);
        }
        configuration.addCustomCategoryComment("Spreading", "Water spreading will quickly get out of control if somebody mis-clicks their limits on their controllers. Here are game-wide limits for spreading.");
        Property maxWaterSpreadWestProperty = configuration.get("Spreading", "maxWaterSpreadWest", 1000, "[SERVER]");
        maxWaterSpreadWest = maxWaterSpreadWestProperty.getInt();
        Property maxWaterSpreadDownProperty = configuration.get("Spreading", "maxWaterSpreadDown", 1000, "[SERVER]");
        maxWaterSpreadDown = maxWaterSpreadDownProperty.getInt();
        Property maxWaterSpreadNorthProperty = configuration.get("Spreading", "maxWaterSpreadNorth", 1000, "[SERVER]");
        maxWaterSpreadNorth = maxWaterSpreadNorthProperty.getInt();
        Property maxWaterSpreadEastProperty = configuration.get("Spreading", "maxWaterSpreadEast", 1000, "[SERVER]");
        maxWaterSpreadEast = maxWaterSpreadEastProperty.getInt();
        Property maxWaterSpreadUpProperty = configuration.get("Spreading", "maxWaterSpreadUp", 24, "[SERVER]");
        maxWaterSpreadUp = maxWaterSpreadUpProperty.getInt();
        Property maxWaterSpreadSouthProperty = configuration.get("Spreading", "maxWaterSpreadSouth", 1000, "[SERVER]");
        maxWaterSpreadSouth = maxWaterSpreadSouthProperty.getInt();
        Property damDrainPerSecondProperty = configuration.get("Energy Balance", "damDrainPerSecond", 2048, "[SERVER] How many EU a dam will provide as Pressurized Water for turbines per tick.");
        damDrainPerSecond = damDrainPerSecondProperty.getInt();
        Property waterBonusPerSurfaceBlockPerRainTickProperty = configuration.get("Energy Balance", "waterBonusPerSurfaceBlockPerRainTick", 1.0, "[SERVER] How many EU are added to a dam during rain for each water block on the highest Y coordinate aka water surface when full.");
        waterBonusPerSurfaceBlockPerRainTick = (float)waterBonusPerSurfaceBlockPerRainTickProperty.getDouble();
        Property blockIdOffsetProperty = configuration.get("General", "blockIdOffset", 17000, "[SERVER + CLIENT] Offset of blockIds for GregTech block registration");
        blockIdOffset = blockIdOffsetProperty.getInt();
        Property efficiencyLossPerTierProperty = configuration.get("Energy Balance", "efficiencyLossPerTier", (double)0.03f, "[SERVER] Efficiency for Hydro Pump and Hydro Turbine in voltage variants and beginning from LV with '(1.0 - efficiencyLossPerTier)'.");
        efficiencyLossPerTier = (float)efficiencyLossPerTierProperty.getDouble();
        Property pressureIncreasePerTierProperty = configuration.get("Energy Balance", "pressureIncreasePerTier", 2.0, "[SERVER] Hydro Pump height limit for voltage variants in blocks and beginning from LV with '1 * pressureIncreasePerTier'.");
        pressureIncreasePerTier = (float)pressureIncreasePerTierProperty.getDouble();
        Property milliBucketPerEUProperty = configuration.get("Energy Balance", "milliBucketPerEU", 1.0, "[SERVER] Conversion ratio between Pressurized Water and EU on pressure 1. Affects the throughput on pipes between multi blocks and how much energy is stored in each Hydro Dam.");
        milliBucketPerEU = (float)milliBucketPerEUProperty.getDouble();
        euPerMilliBucket = 1.0f / milliBucketPerEU;
        Property enabledTiersProperty = configuration.get("Energy Balance", "enabledTiers", Defaults.enabledTiers, "[SERVER] A list of all tiers that should have a Hydro Pump and Hydro Turbine generated. ULV is ignored since it is disabled.");
        String[] enableTierNames = enabledTiersProperty.getStringList();
        for (int i = 0; i < enableTierNames.length; ++i) {
            int tierId = HEUtil.voltageNameToTierId(enableTierNames[i]);
            if (tierId <= 0) continue;
            HEConfig.enabledTiers[tierId] = true;
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static class Categories {
        public static final String general = "General";
        public static final String spreading = "Spreading";
        public static final String energyBalance = "Energy Balance";

        private Categories() {
        }
    }

    private static class Defaults {
        public static final int maxDams = 16;
        public static final int minimalWaterUpdateInterval = 1000;
        public static final int delayBetweenSpreadingChunks = 2000;
        public static final int minLightUpdateTimePerSubChunk = 10;
        public static final float clippingOffset = 0.05f;
        public static final int maxWaterSpreadWest = 1000;
        public static final int maxWaterSpreadDown = 1000;
        public static final int maxWaterSpreadNorth = 1000;
        public static final int maxWaterSpreadEast = 1000;
        public static final int maxWaterSpreadUp = 24;
        public static final int maxWaterSpreadSouth = 1000;
        public static final int overworldId = 0;
        public static final int damDrainPerSecond = 2048;
        public static final float waterBonusPerSurfaceBlockPerRainTick = 1.0f;
        public static final int blockIdOffset = 17000;
        public static final float efficiencyLossPerTier = 0.03f;
        public static final float pressureIncreasePerTier = 2.0f;
        public static final float milliBucketPerEU = 1.0f;
        public static final String[] enabledTiers = new String[]{"lv", "mv", "hv", "ev", "iv"};
        public static final boolean useLimitedRendering = false;
        public static final boolean forceOpenGL = false;

        private Defaults() {
        }
    }
}

