/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.gui;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.gui.widgets.HENumberInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class HEPopupLimitGui
extends Gui {
    private static ResourceLocation limitBackgroundTextureLocation = new ResourceLocation("hydroenergy", HE.damLimitBackgroundLocation);
    private GuiButton minus1000;
    private GuiButton minus100;
    private GuiButton minus10;
    private GuiButton minus1;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton ok;
    private GuiButton cancel;
    private HENumberInput textField;
    public static final int xSize = 168;
    public static final int ySize = 140;
    public boolean visible;
    private int guiLeft;
    private int guiTop;
    private boolean valueChanged;
    private int originalValue;
    private int currentValue;
    private int lowerLimit = Integer.MIN_VALUE;
    private int upperLimit = Integer.MAX_VALUE;
    private String title = "";

    public HEPopupLimitGui(String title, int guiLeft, int guiTop, int originalValue) {
        this.title = title;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.originalValue = originalValue;
        this.currentValue = originalValue;
        this.visible = false;
        this.valueChanged = false;
    }

    public void init(int id, List buttonList) {
        int pixelX = this.guiLeft + 10;
        int height = 20;
        int pixelY = this.guiTop + 20 + 3 * height;
        int width = 39;
        this.minus1000 = new GuiButton(id, pixelX, pixelY, width, height, "-1000");
        buttonList.add(this.minus1000);
        pixelX += width + 10;
        width = 32;
        this.minus100 = new GuiButton(id, pixelX, pixelY, width, height, "-100");
        buttonList.add(this.minus100);
        pixelX += width + 10;
        width = 27;
        this.minus10 = new GuiButton(id, pixelX, pixelY, width, height, "-10");
        buttonList.add(this.minus10);
        pixelX += width + 10;
        width = 20;
        this.minus1 = new GuiButton(id, pixelX, pixelY, width, height, "-1");
        buttonList.add(this.minus1);
        pixelX = this.guiLeft + 10;
        pixelY = this.guiTop + 20;
        width = 39;
        this.plus1000 = new GuiButton(id, pixelX, pixelY, width, height, "+1000");
        buttonList.add(this.plus1000);
        pixelX += width + 10;
        width = 32;
        this.plus100 = new GuiButton(id, pixelX, pixelY, width, height, "+100");
        buttonList.add(this.plus100);
        pixelX += width + 10;
        width = 27;
        this.plus10 = new GuiButton(id, pixelX, pixelY, width, height, "+10");
        buttonList.add(this.plus10);
        pixelX += width + 10;
        width = 20;
        this.plus1 = new GuiButton(id, pixelX, pixelY, width, height, "+1");
        buttonList.add(this.plus1);
        pixelX = this.guiLeft + 10;
        pixelY = this.guiTop + 5 * height + 10;
        width = 42;
        this.ok = new GuiButton(id, pixelX, pixelY, width, height, "OK");
        buttonList.add(this.ok);
        width = 42;
        this.cancel = new GuiButton(id, pixelX += 106, pixelY, width, height, "Cancel");
        buttonList.add(this.cancel);
        pixelX = this.guiLeft + 10;
        pixelY = this.guiTop + 2 * height + 10;
        width = 148;
        this.textField = new HENumberInput(Minecraft.func_71410_x().field_71466_p, pixelX, pixelY, width, height);
        this.textField.func_146185_a(true);
        this.textField.func_146203_f(16);
        this.textField.func_146193_g(-1);
        this.textField.func_146180_a("" + this.originalValue);
        this.textField.minValue = this.lowerLimit;
        this.textField.maxValue = this.upperLimit;
        this.setVisibility(false);
    }

    public boolean getValueChangedAndReset() {
        boolean tmp = this.valueChanged;
        this.valueChanged = false;
        return tmp;
    }

    public void updateOriginalValue(int value) {
        this.originalValue = value;
    }

    public int getValue() {
        return this.currentValue;
    }

    public void show() {
        this.textField.func_146180_a("" + this.originalValue);
        this.setVisibility(true);
    }

    private void confirm() {
        this.valueChanged = this.originalValue != this.currentValue;
        this.originalValue = this.currentValue;
        this.setVisibility(false);
    }

    private void cancel() {
        this.currentValue = this.originalValue;
        this.setVisibility(false);
    }

    private void setVisibility(boolean value) {
        this.visible = value;
        this.textField.func_146189_e(value);
        this.textField.func_146195_b(value);
        this.ok.field_146125_m = value;
        this.cancel.field_146125_m = value;
        this.plus1.field_146125_m = value;
        this.plus10.field_146125_m = value;
        this.plus100.field_146125_m = value;
        this.plus1000.field_146125_m = value;
        this.minus1000.field_146125_m = value;
        this.minus100.field_146125_m = value;
        this.minus10.field_146125_m = value;
        this.minus1.field_146125_m = value;
    }

    private void add(int value) {
        this.textField.add(value);
    }

    public void mouseClicked(int pixelX, int pixelY, int mouseButtonId) {
        if (this.visible) {
            this.textField.func_146192_a(pixelX, pixelY, mouseButtonId);
        }
    }

    public boolean keyTyped(char c, int keyCode) {
        if (this.visible) {
            if (keyCode == 1 || keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i()) {
                this.cancel();
            } else {
                this.textField.func_146201_a(c, keyCode);
                this.currentValue = this.textField.getValue();
            }
            return true;
        }
        return false;
    }

    public void actionPerformed(GuiButton button) {
        if (this.visible) {
            if (button == this.ok) {
                this.confirm();
            } else if (button == this.cancel) {
                this.cancel();
            } else if (button == this.minus1000) {
                this.add(-1000);
            } else if (button == this.minus100) {
                this.add(-100);
            } else if (button == this.minus10) {
                this.add(-10);
            } else if (button == this.minus1) {
                this.add(-1);
            } else if (button == this.plus1) {
                this.add(1);
            } else if (button == this.plus10) {
                this.add(10);
            } else if (button == this.plus100) {
                this.add(100);
            } else if (button == this.plus1000) {
                this.add(1000);
            }
        }
        this.currentValue = this.textField.getValue();
    }

    public void draw(int mouseX, int mouseY) {
        if (this.visible) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(limitBackgroundTextureLocation);
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 168, 140);
            int width = minecraft.field_71466_p.func_78256_a(this.title);
            minecraft.field_71466_p.func_78276_b(this.title, this.guiLeft + 84 - width / 2, this.guiTop + 6, 0);
            this.textField.func_146194_f();
        }
    }
}

