/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.server;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.storage.data.IAEItemStack;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.network.RemoveInventoryMessage;
import net.dries007.holoInventory.network.RenameMessage;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.FakeInventory;
import net.dries007.holoInventory.util.FluidHandlerData;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.InventoryData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.IFluidHandler;

public class ServerEventHandler {
    public final List<String> banUsers = new ArrayList<String>();
    public final HashMap<String, String> overrideUsers = new HashMap();
    public final HashMap<Integer, InventoryData> mapBlockToInv = new HashMap();
    public final HashMap<Integer, FluidHandlerData> mapBlockToFluidHandler = new HashMap();
    final Map<IInventory, CachedPatternInventory> wrappedInventoryCache = new WeakHashMap<IInventory, CachedPatternInventory>();
    private static final String JUKEBOX_NAME = "Jukebox";

    @SubscribeEvent
    public void event(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            TileEntity te = event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z);
            if (Helper.weWant(te)) {
                Config.bannedTiles.add(te.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(te.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
        if (this.overrideUsers.containsKey(event.entityPlayer.getDisplayName())) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            String nameOverride = this.overrideUsers.get(event.entityPlayer.getDisplayName());
            this.overrideUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            TileEntity te = event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z);
            if (Helper.weWant(te)) {
                String name = null;
                if (te instanceof BlockJukebox.TileEntityJukebox) {
                    name = JUKEBOX_NAME;
                } else if (te instanceof IInventory) {
                    name = ((IInventory)te).func_145825_b();
                } else if (te instanceof TileEntityEnderChest) {
                    name = event.entityPlayer.func_71005_bN().func_145825_b();
                }
                HoloInventory.getSnw().sendTo((IMessage)new RenameMessage(name == null ? "" : name, nameOverride), (EntityPlayerMP)event.entityPlayer);
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(te.getClass().getCanonicalName() + " will now be named " + nameOverride));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
        }
    }

    @SubscribeEvent
    public void event(EntityInteractEvent event) {
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            if (Helper.weWant(event.target)) {
                Config.bannedEntities.add(event.target.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(event.target.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
    }

    @SubscribeEvent
    public void event(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            WorldServer world = player.func_71121_q();
            if (world == null) {
                return;
            }
            MovingObjectPosition mo = Helper.getPlayerLookingSpot((EntityPlayer)player);
            if (mo == null) {
                return;
            }
            switch (mo.field_72313_a) {
                case BLOCK: {
                    this.handleInventoryBlock(world, player, mo);
                    this.handleFluidHandlerBlock(world, player, mo);
                    break;
                }
                case ENTITY: {
                    if (!(mo.field_72308_g instanceof IInventory)) break;
                    this.processInventoryData(mo.field_72308_g.func_145782_y(), player, (IInventory)mo.field_72308_g);
                }
            }
        }
        catch (Exception e) {
            HoloInventory.getLogger().warn("Some error while sending over inventory, no hologram for you :(");
            HoloInventory.getLogger().warn("Please make an issue on github if this happens.");
            e.printStackTrace();
        }
    }

    private void handleInventoryBlock(WorldServer world, EntityPlayerMP player, MovingObjectPosition mo) {
        Coord coord = new Coord(world.field_73011_w.field_76574_g, mo);
        int x = (int)coord.x;
        int y = (int)coord.y;
        int z = (int)coord.z;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        this.checkForChangedType(coord, te, player);
        if (Config.bannedTiles.contains(te.getClass().getCanonicalName())) {
            this.removeInventoryData(coord, player);
        } else if (te instanceof TileEntityChest) {
            TileEntityChest teChest;
            Block block = world.func_147439_a(x, y, z);
            TileEntityChest inventory = teChest = (TileEntityChest)te;
            if (world.func_147439_a(x, y, z + 1) == block) {
                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)teChest, (IInventory)((TileEntityChest)world.func_147438_o(x, y, z + 1)));
            } else if (world.func_147439_a(x - 1, y, z) == block) {
                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)world.func_147438_o(x - 1, y, z)), (IInventory)teChest);
            } else if (world.func_147439_a(x, y, z - 1) == block) {
                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)world.func_147438_o(x, y, z - 1)), (IInventory)teChest);
            } else if (world.func_147439_a(x + 1, y, z) == block) {
                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)teChest, (IInventory)((TileEntityChest)world.func_147438_o(x + 1, y, z)));
            }
            this.processInventoryData(coord.hashCode(), player, (IInventory)inventory);
        } else if (HoloInventory.isAE2Loaded && te instanceof TileInterface) {
            IInventory patterns = ((TileInterface)te).getInventoryByName("patterns");
            IInventory wrapped = this.getCachedPatternsWrapper(world, ((TileInterface)te).getCustomName(), patterns);
            this.processInventoryData(coord.hashCode(), player, wrapped);
        } else if (HoloInventory.isAE2Loaded && te instanceof IPartHost) {
            IPartHost host = (IPartHost)te;
            Vec3 position = mo.field_72307_f.func_72441_c((double)(-mo.field_72311_b), (double)(-mo.field_72312_c), (double)(-mo.field_72309_d));
            SelectedPart sp = host.selectPart(position);
            if (sp != null && sp.part instanceof PartInterface) {
                IInventory patterns = ((PartInterface)sp.part).getInventoryByName("patterns");
                IInventory wrapped = this.getCachedPatternsWrapper(world, ((PartInterface)sp.part).getCustomName(), patterns);
                this.processInventoryData(coord.hashCode(), player, wrapped);
            } else {
                this.removeInventoryData(coord, player);
            }
        } else if (te instanceof IInventory) {
            this.processInventoryData(coord.hashCode(), player, (IInventory)te);
        } else if (te instanceof TileEntityEnderChest) {
            this.processInventoryData(coord.hashCode(), player, (IInventory)player.func_71005_bN());
        } else if (te instanceof BlockJukebox.TileEntityJukebox) {
            BlockJukebox.TileEntityJukebox realTe = (BlockJukebox.TileEntityJukebox)te;
            this.processInventoryData(coord.hashCode(), player, JUKEBOX_NAME, realTe.func_145856_a());
        }
    }

    private IInventory getCachedPatternsWrapper(WorldServer world, String name, IInventory patterns) {
        IInventory ret;
        CachedPatternInventory cache = this.wrappedInventoryCache.get(patterns);
        if (cache == null || (ret = (IInventory)cache.inventory.get()) == null || cache.hash != CachedPatternInventory.computeHash(patterns)) {
            ret = this.convertToOutputItems(name, patterns, (World)world);
            cache = new CachedPatternInventory(ret, patterns);
            this.wrappedInventoryCache.put(patterns, cache);
        }
        return ret;
    }

    private void checkForChangedType(Coord coord, TileEntity te, EntityPlayerMP player) {
        int id = coord.hashCode();
        if (this.mapBlockToInv.containsKey(id)) {
            InventoryData data = this.mapBlockToInv.get(id);
            if (!te.getClass().getCanonicalName().equals(data.getType())) {
                this.doRemoveInventoryData(id, player, data);
            }
        }
    }

    private void removeInventoryData(Coord coord, EntityPlayerMP player) {
        int id = coord.hashCode();
        if (this.mapBlockToInv.containsKey(id)) {
            InventoryData inventoryData = this.mapBlockToInv.get(id);
            this.doRemoveInventoryData(id, player, inventoryData);
        }
    }

    private void doRemoveInventoryData(int id, EntityPlayerMP player, InventoryData inventoryData) {
        inventoryData.playerSet.remove(player);
        if (inventoryData.playerSet.isEmpty()) {
            this.mapBlockToInv.remove(id);
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74774_a("type", (byte)0);
        root.func_74768_a("id", id);
        HoloInventory.getSnw().sendTo((IMessage)new RemoveInventoryMessage(root), player);
    }

    private IInventory convertToOutputItems(String name, IInventory patterns, World w) {
        int N = patterns.func_70302_i_();
        ItemStack[] outputs = new ItemStack[N];
        for (int i = 0; i < N; ++i) {
            IAEItemStack[] outs;
            ICraftingPatternDetails pd;
            ItemStack stack = patterns.func_70301_a(i);
            outputs[i] = null;
            if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (pd = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, w)) == null || (outs = pd.getCondensedOutputs()) == null || outs.length <= 0) continue;
            outputs[i] = outs[0].getItemStack();
        }
        return new FakeInventory(name, outputs);
    }

    private void processInventoryData(int id, EntityPlayerMP player, String name, ItemStack ... itemStacks) {
        this.processInventoryData(id, player, new FakeInventory(name, itemStacks));
    }

    private void processInventoryData(int id, EntityPlayerMP player, IInventory inventory) {
        InventoryData inventoryData = this.mapBlockToInv.get(id);
        if (inventoryData == null) {
            inventoryData = new InventoryData(inventory, id);
        } else {
            inventoryData.update(inventory);
        }
        inventoryData.sendIfOld(player);
        this.mapBlockToInv.put(id, inventoryData);
    }

    public void clearInventoryData() {
        this.mapBlockToInv.clear();
    }

    private void handleFluidHandlerBlock(WorldServer world, EntityPlayerMP player, MovingObjectPosition mo) {
        Coord coord = new Coord(world.field_73011_w.field_76574_g, mo);
        int x = (int)coord.x;
        int y = (int)coord.y;
        int z = (int)coord.z;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te instanceof IFluidHandler) {
            this.processFluidHandlerData(coord.hashCode(), player, (IFluidHandler)te);
        }
    }

    private void processFluidHandlerData(int id, EntityPlayerMP player, IFluidHandler fluidHandler) {
        FluidHandlerData fluidHandlerData = this.mapBlockToFluidHandler.get(id);
        if (fluidHandlerData == null) {
            fluidHandlerData = new FluidHandlerData(fluidHandler, id);
        } else {
            fluidHandlerData.update(fluidHandler);
        }
        fluidHandlerData.sendIfOld(player);
        this.mapBlockToFluidHandler.put(id, fluidHandlerData);
    }

    private static class CachedPatternInventory {
        public final WeakReference<IInventory> inventory;
        public final int hash;

        public static int computeHash(IInventory key) {
            int h = 0;
            for (int i = 0; i < key.func_70302_i_(); ++i) {
                ItemStack s = key.func_70301_a(i);
                if (s == null || s.func_77978_p() == null) continue;
                h ^= s.func_77978_p().hashCode();
            }
            return h;
        }

        public CachedPatternInventory(IInventory wrapper, IInventory key) {
            this.inventory = new WeakReference<IInventory>(wrapper);
            this.hash = CachedPatternInventory.computeHash(key);
        }
    }
}

