/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.server;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.storage.data.IAEItemStack;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.network.RemoveInventoryMessage;
import net.dries007.holoInventory.network.RenameMessage;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.FakeInventory;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.InventoryData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ServerEventHandler {
    public List<String> banUsers = new ArrayList<String>();
    public HashMap<String, String> overrideUsers = new HashMap();
    public HashMap<Integer, InventoryData> blockMap = new HashMap();
    Map<IInventory, CachedPatternInventory> wrappedInventoryCache = new WeakHashMap<IInventory, CachedPatternInventory>();
    private static final String JUKEBOX_NAME = "Jukebox";

    @SubscribeEvent
    public void event(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            TileEntity te = event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z);
            if (Helper.weWant(te)) {
                Config.bannedTiles.add(te.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(te.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
        if (this.overrideUsers.containsKey(event.entityPlayer.getDisplayName())) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            String nameOverride = this.overrideUsers.get(event.entityPlayer.getDisplayName());
            this.overrideUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            TileEntity te = event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z);
            if (Helper.weWant(te)) {
                String name = null;
                if (te instanceof BlockJukebox.TileEntityJukebox) {
                    name = JUKEBOX_NAME;
                } else if (te instanceof IInventory) {
                    name = ((IInventory)te).func_145825_b();
                } else if (te instanceof TileEntityEnderChest) {
                    name = event.entityPlayer.func_71005_bN().func_145825_b();
                }
                HoloInventory.getSnw().sendTo((IMessage)new RenameMessage(name == null ? "" : name, nameOverride), (EntityPlayerMP)event.entityPlayer);
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(te.getClass().getCanonicalName() + " will now be named " + nameOverride));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
        }
    }

    @SubscribeEvent
    public void event(EntityInteractEvent event) {
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            if (Helper.weWant(event.target)) {
                Config.bannedEntities.add(event.target.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(event.target.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
    }

    @SubscribeEvent
    public void event(TickEvent.PlayerTickEvent event) {
        block23: {
            try {
                if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
                    return;
                }
                EntityPlayerMP player = (EntityPlayerMP)event.player;
                WorldServer world = player.func_71121_q();
                if (world == null) {
                    return;
                }
                MovingObjectPosition mo = Helper.getPlayerLookingSpot((EntityPlayer)player);
                if (mo == null) break block23;
                switch (mo.field_72313_a) {
                    case BLOCK: {
                        Coord coord = new Coord(world.field_73011_w.field_76574_g, mo);
                        int x = (int)coord.x;
                        int y = (int)coord.y;
                        int z = (int)coord.z;
                        TileEntity te = world.func_147438_o(x, y, z);
                        if (!Helper.weWant(te)) break;
                        this.checkForChangedType(coord.hashCode(), te);
                        HoloInventory.getConfig();
                        if (Config.bannedTiles.contains(te.getClass().getCanonicalName())) {
                            this.cleanup(coord, player);
                            break;
                        }
                        if (te instanceof TileEntityChest) {
                            TileEntityChest teChest;
                            Block block = world.func_147439_a(x, y, z);
                            TileEntityChest inventory = teChest = (TileEntityChest)te;
                            if (world.func_147439_a(x, y, z + 1) == block) {
                                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)teChest, (IInventory)((TileEntityChest)world.func_147438_o(x, y, z + 1)));
                            } else if (world.func_147439_a(x - 1, y, z) == block) {
                                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)world.func_147438_o(x - 1, y, z)), (IInventory)teChest);
                            } else if (world.func_147439_a(x, y, z - 1) == block) {
                                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)world.func_147438_o(x, y, z - 1)), (IInventory)teChest);
                            } else if (world.func_147439_a(x + 1, y, z) == block) {
                                inventory = new InventoryLargeChest("container.chestDouble", (IInventory)teChest, (IInventory)((TileEntityChest)world.func_147438_o(x + 1, y, z)));
                            }
                            this.doStuff(coord.hashCode(), player, (IInventory)inventory);
                            break;
                        }
                        if (te instanceof TileInterface) {
                            IInventory patterns = ((TileInterface)te).getInventoryByName("patterns");
                            IInventory wrapped = this.getCachedPatternsWrapper(world, ((TileInterface)te).getCustomName(), patterns);
                            this.doStuff(coord.hashCode(), player, wrapped);
                            break;
                        }
                        if (te instanceof IPartHost) {
                            IPartHost host = (IPartHost)te;
                            Vec3 position = mo.field_72307_f.func_72441_c((double)(-mo.field_72311_b), (double)(-mo.field_72312_c), (double)(-mo.field_72309_d));
                            SelectedPart sp = host.selectPart(position);
                            if (sp != null && sp.part instanceof PartInterface) {
                                IInventory patterns = ((PartInterface)sp.part).getInventoryByName("patterns");
                                IInventory wrapped = this.getCachedPatternsWrapper(world, ((PartInterface)sp.part).getCustomName(), patterns);
                                this.doStuff(coord.hashCode(), player, wrapped);
                            }
                            break;
                        }
                        if (te instanceof IInventory) {
                            this.doStuff(coord.hashCode(), player, (IInventory)te);
                            break;
                        }
                        if (te instanceof TileEntityEnderChest) {
                            this.doStuff(coord.hashCode(), player, (IInventory)player.func_71005_bN());
                            break;
                        }
                        if (te instanceof BlockJukebox.TileEntityJukebox) {
                            BlockJukebox.TileEntityJukebox realTe = (BlockJukebox.TileEntityJukebox)te;
                            this.doStuff(coord.hashCode(), player, JUKEBOX_NAME, realTe.func_145856_a());
                            break;
                        }
                        this.cleanup(coord, player);
                        break;
                    }
                    case ENTITY: {
                        if (!Helper.weWant(mo.field_72308_g)) break;
                        this.doStuff(mo.field_72308_g.func_145782_y(), player, (IInventory)mo.field_72308_g);
                    }
                }
            }
            catch (Exception e) {
                HoloInventory.getLogger().warn("Some error while sending over inventory, no hologram for you :(");
                HoloInventory.getLogger().warn("Please make an issue on github if this happens.");
                e.printStackTrace();
            }
        }
    }

    private IInventory getCachedPatternsWrapper(WorldServer world, String name, IInventory patterns) {
        CachedPatternInventory cache = this.wrappedInventoryCache.get(patterns);
        if (cache == null || cache.hash != CachedPatternInventory.computeHash(patterns)) {
            cache = new CachedPatternInventory(this.convertToOutputItems(name, patterns, (World)world), patterns);
            this.wrappedInventoryCache.put(patterns, cache);
        }
        return cache.inventory;
    }

    private void checkForChangedType(int id, TileEntity te) {
        if (this.blockMap.containsKey(id)) {
            InventoryData data = this.blockMap.get(id);
            if (!te.getClass().getCanonicalName().equals(data.getType())) {
                this.blockMap.remove(id);
            }
        }
    }

    private void cleanup(Coord coord, EntityPlayerMP player) {
        if (this.blockMap.containsKey(coord.hashCode())) {
            InventoryData inventoryData = this.blockMap.get(coord.hashCode());
            inventoryData.playerSet.remove(player);
            if (inventoryData.playerSet.isEmpty()) {
                this.blockMap.remove(coord.hashCode());
            }
            NBTTagCompound root = new NBTTagCompound();
            root.func_74774_a("type", (byte)0);
            root.func_74768_a("id", coord.hashCode());
            HoloInventory.getSnw().sendTo((IMessage)new RemoveInventoryMessage(root), player);
        }
    }

    private IInventory convertToOutputItems(String name, IInventory patterns, World w) {
        int N = patterns.func_70302_i_();
        ItemStack[] outputs = new ItemStack[N];
        for (int i = 0; i < N; ++i) {
            IAEItemStack[] outs;
            ItemStack stack = patterns.func_70301_a(i);
            outputs[i] = null;
            if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (outs = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, w).getCondensedOutputs()).length <= 0) continue;
            outputs[i] = outs[0].getItemStack();
        }
        return new FakeInventory(name, outputs);
    }

    private void doStuff(int id, EntityPlayerMP player, String name, ItemStack ... itemStacks) {
        this.doStuff(id, player, new FakeInventory(name, itemStacks));
    }

    private void doStuff(int id, EntityPlayerMP player, IInventory inventory) {
        InventoryData inventoryData = this.blockMap.get(id);
        if (inventoryData == null) {
            inventoryData = new InventoryData(inventory, id);
        } else {
            inventoryData.update(inventory);
        }
        inventoryData.sendIfOld(player);
        this.blockMap.put(id, inventoryData);
    }

    public void clear() {
        this.blockMap.clear();
    }

    private static class CachedPatternInventory {
        public IInventory inventory;
        public int hash;

        public static int computeHash(IInventory key) {
            int h = 0;
            for (int i = 0; i < key.func_70302_i_(); ++i) {
                ItemStack s = key.func_70301_a(i);
                if (s == null || s.func_77978_p() == null) continue;
                h ^= s.func_77978_p().hashCode();
            }
            return h;
        }

        public CachedPatternInventory(IInventory wrapper, IInventory key) {
            this.inventory = wrapper;
            this.hash = CachedPatternInventory.computeHash(key);
        }
    }
}

