/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.util;

import com.google.common.base.Strings;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.compat.DecoderRegistry;
import net.dries007.holoInventory.network.BlockInventoryMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryData {
    public final int id;
    public WeakReference<IInventory> te;
    public final WeakHashMap<EntityPlayer, NBTTagCompound> playerSet = new WeakHashMap();
    public final String name;
    public String type;

    public InventoryData(IInventory te, int id) {
        this.id = id;
        this.te = new WeakReference<IInventory>(te);
        this.name = Strings.nullToEmpty((String)te.func_145825_b());
        this.type = te.getClass().getCanonicalName();
        if (this.type == null) {
            this.type = te.getClass().getName();
        }
    }

    public void sendIfOld(EntityPlayerMP player) {
        IInventory ste = (IInventory)this.te.get();
        if (ste == null) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("id", this.id);
        data.func_74778_a("name", this.name);
        data.func_74782_a("list", (NBTBase)DecoderRegistry.toNBT(ste));
        if (!this.playerSet.containsKey(player) || !this.playerSet.get(player).equals((Object)data)) {
            this.playerSet.put((EntityPlayer)player, data);
            HoloInventory.getSnw().sendTo((IMessage)new BlockInventoryMessage(data), player);
        }
    }

    public void update(IInventory inventory) {
        this.te = new WeakReference<IInventory>(inventory);
    }

    public String getType() {
        return this.type;
    }
}

