/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.network.EntityInventoryMessage;
import net.dries007.holoInventory.network.MerchantInventoryMessage;
import net.dries007.holoInventory.network.RemoveInventoryMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;

public class EntityRequestMessage
implements IMessage {
    private int dim;
    private int entityId;

    public EntityRequestMessage() {
    }

    public EntityRequestMessage(int dim, int entityId) {
        this.dim = dim;
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.entityId);
    }

    public static class Handler
    implements IMessageHandler<EntityRequestMessage, IMessage> {
        public static final HashMultimap<Integer, String> map = HashMultimap.create();

        public IMessage onMessage(EntityRequestMessage message, MessageContext ctx) {
            Entity entity;
            if (ctx.side.isServer() && ((entity = DimensionManager.getWorld((int)message.dim).func_73045_a(message.entityId)) instanceof IInventory || entity instanceof IMerchant)) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (Config.bannedEntities.contains(entity.getClass().getCanonicalName())) {
                    if (map.containsEntry((Object)message.entityId, (Object)player.getDisplayName())) {
                        map.remove((Object)message.entityId, (Object)player.getDisplayName());
                        NBTTagCompound root = new NBTTagCompound();
                        root.func_74774_a("type", (byte)1);
                        root.func_74768_a("id", message.entityId);
                        return new RemoveInventoryMessage(root);
                    }
                    return null;
                }
                map.put((Object)message.entityId, (Object)player.getDisplayName());
                if (entity instanceof IInventory) {
                    IInventory inventory = (IInventory)entity;
                    NBTTagCompound root = new NBTTagCompound();
                    root.func_74768_a("id", message.entityId);
                    root.func_74778_a("name", Strings.nullToEmpty((String)inventory.func_145825_b()));
                    root.func_74778_a("class", entity.getClass().getCanonicalName());
                    NBTTagList list = new NBTTagList();
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        if (inventory.func_70301_a(i) == null) continue;
                        list.func_74742_a((NBTBase)inventory.func_70301_a(i).func_77955_b(new NBTTagCompound()));
                    }
                    root.func_74782_a("list", (NBTBase)list);
                    return new EntityInventoryMessage(root);
                }
                NBTTagCompound tag = ((IMerchant)entity).func_70934_b((EntityPlayer)player).func_77202_a();
                tag.func_74768_a("id", message.entityId);
                tag.func_74778_a("name", entity.func_70005_c_());
                tag.func_74778_a("class", entity.getClass().getCanonicalName());
                return new MerchantInventoryMessage(tag);
            }
            return null;
        }
    }
}

