/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge;

import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.CoreTweaksCompat;
import com.mitchej123.hodgepodge.ISimulationDistanceWorld;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.util.ChunkPosUtil;
import cpw.mods.fml.common.FMLLog;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class SimulationDistanceHelper {
    private final WeakReference<World> worldRef;
    private final boolean isServer;
    private final Long2ByteOpenHashMap noTickChunks = new Long2ByteOpenHashMap();
    private final LongBooleanArrayList noTickChunksChanges = new LongBooleanArrayList();
    private final LongOpenHashSet forcedChunksMap = new LongOpenHashSet();
    private final Long2BooleanOpenHashMap cacheShouldProcessTick = new Long2BooleanOpenHashMap();
    private final Map<EntityPlayer, ChunkCoordIntPair> playerPosOldMap = new WeakHashMap<EntityPlayer, ChunkCoordIntPair>();
    private final ObjectAVLTreeSet<NextTickListEntry> pendingTickCandidates = new ObjectAVLTreeSet();
    private final Long2ObjectMap<HashSet<NextTickListEntry>> chunkTickMap = new Long2ObjectOpenHashMap();
    private TreeSet<NextTickListEntry> pendingTickListEntriesTreeSet;
    private Set<NextTickListEntry> pendingTickListEntriesHashSet;
    private BiPredicate<Integer, Integer> chunkExists;
    private int simulationDistanceOld;

    public static void preventChunkSimulation(World world, long packedChunkPos, boolean prevent) {
        if (!FixesConfig.addSimulationDistance) {
            return;
        }
        ISimulationDistanceWorld mixin = (ISimulationDistanceWorld)world;
        mixin.hodgepodge$preventChunkSimulation(packedChunkPos, prevent);
    }

    public static int getSimulationDistance() {
        return TweaksConfig.simulationDistance;
    }

    public static void setSimulationDistance(int distance) {
        TweaksConfig.simulationDistance = distance;
    }

    public SimulationDistanceHelper(World world) {
        this.worldRef = new WeakReference<World>(world);
        this.isServer = world instanceof WorldServer;
    }

    public void preventChunkSimulation(long packedChunkPos, boolean prevent) {
        this.noTickChunksChanges.add(packedChunkPos, prevent);
    }

    private boolean closeToPlayer(long packedChunkPos) {
        int cx = ChunkPosUtil.getPackedX(packedChunkPos);
        int cz = ChunkPosUtil.getPackedZ(packedChunkPos);
        World world = (World)this.worldRef.get();
        if (world == null) {
            return false;
        }
        int simulationDistance = SimulationDistanceHelper.getSimulationDistance();
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_130014_f_() != world) continue;
            int playerCX = (int)player.field_70165_t >> 4;
            int playerCZ = (int)player.field_70161_v >> 4;
            if (Math.abs(playerCX - cx) > simulationDistance || Math.abs(playerCZ - cz) > simulationDistance) continue;
            return true;
        }
        return false;
    }

    public boolean shouldProcessTick(int x, int z) {
        long key = ChunkPosUtil.toLong(x, z);
        return this.cacheShouldProcessTick.computeIfAbsent(key, k -> {
            if (this.closeToPlayer(k)) {
                return true;
            }
            if (this.noTickChunks.containsKey(k)) {
                return false;
            }
            return this.forcedChunksMap.contains(k);
        });
    }

    private LongOpenHashSet getPlayerChunksForPos(ChunkCoordIntPair pos) {
        int simulationDistance = SimulationDistanceHelper.getSimulationDistance();
        int diameter = simulationDistance * 2 + 1;
        LongOpenHashSet chunks = new LongOpenHashSet(diameter * diameter);
        for (int x = -simulationDistance; x <= simulationDistance; ++x) {
            for (int z = -simulationDistance; z <= simulationDistance; ++z) {
                chunks.add(ChunkCoordIntPair.func_77272_a((int)(pos.field_77276_a + x), (int)(pos.field_77275_b + z)));
            }
        }
        return chunks;
    }

    private void mergeNoTickChunkChanges() {
        for (int i = 0; i < this.noTickChunksChanges.size(); ++i) {
            long key = this.noTickChunksChanges.getLong(i);
            boolean prevent = this.noTickChunksChanges.getBoolean(i);
            byte value = this.noTickChunks.getOrDefault(key, (byte)0);
            if ((value = (byte)(value + (byte)(prevent ? 1 : -1))) > 0) {
                this.noTickChunks.put(key, value);
                continue;
            }
            this.noTickChunks.remove(key);
        }
        this.noTickChunksChanges.clear();
    }

    private void checkForAddedChunks(LongOpenHashSet forcedChunksOld) {
        World world = (World)this.worldRef.get();
        if (world == null) {
            return;
        }
        LongOpenHashSet added = new LongOpenHashSet();
        int simulationDistance = SimulationDistanceHelper.getSimulationDistance();
        LongIterator iterator = this.forcedChunksMap.iterator();
        while (iterator.hasNext()) {
            long chunk = iterator.nextLong();
            if (forcedChunksOld.contains(chunk)) continue;
            added.add(chunk);
        }
        for (EntityPlayer player : world.field_73010_i) {
            LongOpenHashSet chunksNewPos;
            if (player.func_130014_f_() != world) continue;
            ChunkCoordIntPair playerPos = new ChunkCoordIntPair((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            ChunkCoordIntPair playerPosOld = this.playerPosOldMap.getOrDefault(player, null);
            if (playerPosOld == null || simulationDistance != this.simulationDistanceOld) {
                chunksNewPos = this.getPlayerChunksForPos(playerPos);
                added.addAll((LongCollection)chunksNewPos);
                continue;
            }
            if (playerPos.equals((Object)playerPosOld)) continue;
            chunksNewPos = this.getPlayerChunksForPos(playerPos);
            LongOpenHashSet chunksOldPos = this.getPlayerChunksForPos(playerPosOld);
            iterator = chunksNewPos.iterator();
            while (iterator.hasNext()) {
                long pos = iterator.nextLong();
                if (chunksOldPos.contains(pos)) continue;
                added.add(pos);
            }
        }
        iterator = added.iterator();
        while (iterator.hasNext()) {
            long chunk = iterator.nextLong();
            HashSet entries = (HashSet)this.chunkTickMap.get(chunk);
            if (entries == null) continue;
            this.pendingTickCandidates.addAll((Collection)entries);
        }
        this.simulationDistanceOld = simulationDistance;
    }

    public void tickStart() {
        World world = (World)this.worldRef.get();
        if (world == null) {
            return;
        }
        this.mergeNoTickChunkChanges();
        this.cacheShouldProcessTick.clear();
        LongOpenHashSet forcedChunksOld = new LongOpenHashSet((LongCollection)this.forcedChunksMap);
        this.forcedChunksMap.clear();
        for (ChunkCoordIntPair key : ForgeChunkManager.getPersistentChunksFor((World)world).keys()) {
            this.forcedChunksMap.add(ChunkCoordIntPair.func_77272_a((int)key.field_77276_a, (int)key.field_77275_b));
        }
        if (!this.isServer) {
            return;
        }
        this.checkForAddedChunks(forcedChunksOld);
        this.playerPosOldMap.clear();
        for (EntityPlayer player : world.field_73010_i) {
            this.playerPosOldMap.put(player, new ChunkCoordIntPair((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4));
        }
    }

    private void dumpTickList(NextTickListEntry removingEntry) {
        FMLLog.info((String)("Trying to remove entry: " + removingEntry), (Object[])new Object[0]);
        FMLLog.info((String)"pendingTickListEntriesTreeSet:", (Object[])new Object[0]);
        for (NextTickListEntry entry : this.pendingTickListEntriesTreeSet) {
            FMLLog.info((String)("    " + entry), (Object[])new Object[0]);
        }
    }

    public void chunkUnloaded(long chunk) {
        World world = (World)this.worldRef.get();
        if (world == null) {
            return;
        }
        HashSet entries = (HashSet)this.chunkTickMap.get(chunk);
        if (!this.isServer || entries == null) {
            return;
        }
        this.chunkTickMap.remove(chunk);
        for (NextTickListEntry entry : entries) {
            if (!this.pendingTickListEntriesTreeSet.remove(entry)) {
                this.dumpTickList(entry);
                throw new IllegalStateException("Failed to remove tick! See logs for more.");
            }
            this.pendingTickListEntriesHashSet.remove(entry);
            if (Compat.isCoreTweaksPresent()) {
                CoreTweaksCompat.removeTickEntry(world, entry);
            }
            this.pendingTickCandidates.remove((Object)entry);
        }
    }

    private void removeTick(NextTickListEntry entry) {
        long key;
        HashSet entries;
        World world = (World)this.worldRef.get();
        if (world == null) {
            return;
        }
        if (!this.pendingTickListEntriesTreeSet.remove(entry)) {
            this.dumpTickList(entry);
            throw new IllegalStateException("Failed to remove tick! See logs for more.");
        }
        this.pendingTickListEntriesHashSet.remove(entry);
        if (Compat.isCoreTweaksPresent()) {
            CoreTweaksCompat.removeTickEntry(world, entry);
        }
        if ((entries = (HashSet)this.chunkTickMap.get(key = ChunkCoordIntPair.func_77272_a((int)(entry.field_77183_a >> 4), (int)(entry.field_77182_c >> 4)))) != null) {
            entries.remove(entry);
        }
    }

    public void addTick(NextTickListEntry entry) {
        this.pendingTickCandidates.add((Object)entry);
        long key = ChunkCoordIntPair.func_77272_a((int)(entry.field_77183_a >> 4), (int)(entry.field_77182_c >> 4));
        HashSet<NextTickListEntry> entries = (HashSet<NextTickListEntry>)this.chunkTickMap.get(key);
        if (entries == null) {
            entries = new HashSet<NextTickListEntry>();
            this.chunkTickMap.put(key, entries);
        }
        entries.add(entry);
    }

    public void tickUpdates(boolean processAll, List<NextTickListEntry> pendingTickListEntriesThisTick) {
        World world = (World)this.worldRef.get();
        if (world == null) {
            return;
        }
        if (this.pendingTickListEntriesTreeSet.size() != this.pendingTickListEntriesHashSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        ObjectBidirectionalIterator iterator = this.pendingTickCandidates.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry entry = (NextTickListEntry)iterator.next();
            if (!processAll && entry.field_77180_e > world.func_72912_H().func_82573_f()) break;
            iterator.remove();
            if (!this.chunkExists.test(entry.field_77183_a >> 4, entry.field_77182_c >> 4)) {
                this.removeTick(entry);
                continue;
            }
            if (!this.shouldProcessTick(entry.field_77183_a >> 4, entry.field_77182_c >> 4)) continue;
            this.removeTick(entry);
            pendingTickListEntriesThisTick.add(entry);
            if (pendingTickListEntriesThisTick.size() < 1000) continue;
            break;
        }
    }

    public void setServerVariables(TreeSet<NextTickListEntry> pendingTickListEntriesTreeSet, Set<NextTickListEntry> pendingTickListEntriesHashSet, BiPredicate<Integer, Integer> chunkExists) {
        this.pendingTickListEntriesTreeSet = pendingTickListEntriesTreeSet;
        this.pendingTickListEntriesHashSet = pendingTickListEntriesHashSet;
        this.chunkExists = chunkExists;
    }

    static class LongBooleanArrayList {
        private final LongArrayList longs = new LongArrayList();
        private final BooleanArrayList booleans = new BooleanArrayList();

        LongBooleanArrayList() {
        }

        public void add(long packedChunkPos, boolean prevent) {
            this.longs.add(packedChunkPos);
            this.booleans.add(prevent);
        }

        public int size() {
            return this.longs.size();
        }

        public long getLong(int i) {
            return this.longs.getLong(i);
        }

        public boolean getBoolean(int i) {
            return this.booleans.getBoolean(i);
        }

        public void clear() {
            this.longs.clear();
            this.booleans.clear();
        }
    }
}

