/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge;

import com.mitchej123.hodgepodge.util.BlockMatcher;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public class LoadingConfig {
    public boolean addSystemInfo;
    public boolean arabicNumbersForEnchantsPotions;
    public int chatLength;
    public int ic2SeedMaxStackSize;
    public int itemStacksPickedUpPerTick;
    public int particleLimit;
    public boolean addCVSupportToWandPedestal;
    public boolean addToggleDebugMessage;
    public boolean deduplicateForestryCompatInBOP;
    public boolean dimensionManagerDebug;
    public boolean disableWitcheryPotionExtender;
    public boolean displayIc2FluidLocalizedName;
    public boolean dropPickedLootOnDespawn;
    public boolean enableDefaultLanPort;
    public boolean changeSprintCategory;
    public boolean enlargePotionArray;
    public boolean fixBibliocraftPackets;
    public boolean fixComponentsPoppingOff;
    public boolean fixDebugBoundingBox;
    public boolean fixDimensionChangeHearts;
    public boolean fixEatingStackedStew;
    public boolean fixEnchantmentNumerals;
    public boolean fixExtraUtilitiesItemRendering;
    public boolean fixExtraUtilitiesUnEnchanting;
    public boolean fixFenceConnections;
    public boolean fixFireSpread;
    public boolean fixFriendlyCreatureSounds;
    public boolean fixGetBlockLightValue;
    public boolean fixGlStateBugs;
    public boolean fixGuiGameOver;
    public boolean fixHasteArmSwing;
    public boolean fixHopperHitBox;
    public boolean fixHopperVoidingItems;
    public boolean fixHudLightingGlitch;
    public boolean fixHugeChatKick;
    public boolean fixHungerOverhaul;
    public boolean fixHungerOverhaulRestore0Hunger;
    public boolean fixIc2DirectInventoryAccess;
    public boolean fixIc2Hazmat;
    public boolean fixIc2Nightvision;
    public boolean fixIc2ReactorDupe;
    public boolean fixIc2UnprotectedGetBlock;
    public boolean fixIgnisFruitAABB;
    public boolean fixImmobileFireballs;
    public boolean fixJourneymapKeybinds;
    public boolean fixJourneymapJumpyScrolling;
    public boolean fixJourneymapFilePath;
    public boolean fixNetherLeavesFaceRendering;
    public boolean fixNorthWestBias;
    public boolean fixOptifineChunkLoadingCrash;
    public boolean fixPerspectiveCamera;
    public boolean fixPotionEffectNumerals;
    public boolean fixPotionEffectRender;
    public boolean fixPotionIterating;
    public boolean fixPotionLimit;
    public boolean fixPotionRenderOffset;
    public boolean fixResizableFullscreen;
    public boolean fixResourcePackOpening;
    public boolean fixThaumcraftAspectSorting;
    public boolean fixTimeCommandWithGC;
    public boolean fixUnfocusedFullscreen;
    public boolean fixUrlDetection;
    public boolean fixVanillaUnprotectedGetBlock;
    public boolean fixVillageUncheckedGetBlock;
    public boolean fixWorldGetBlock;
    public boolean fixWorldServerLeakingUnloadedEntities;
    public boolean fixXaerosWorldMapScroll;
    public boolean fixZTonesPackets;
    public boolean hideCrosshairInThirdPerson;
    public boolean hideIc2ReactorSlots;
    public boolean hidePotionParticlesFromSelf;
    public boolean increaseParticleLimit;
    public boolean installAnchorAlarm;
    public boolean java12BopCompat;
    public boolean java12ImmersiveEngineeringCompat;
    public boolean logHugeChat;
    public boolean longerChat;
    public boolean makeBigFirsPlantable;
    public boolean optimizeASMDataTable;
    public boolean optimizeIc2ReactorInventoryAccess;
    public boolean optimizeTileentityRemoval;
    public boolean optimizeWorldUpdateLight;
    public boolean preventPickupLoot;
    public boolean removeSpawningMinecartSound;
    public boolean enableMacosCmdShortcuts;
    public boolean fixFontRendererLinewrapRecursion;
    public boolean removeUpdateChecks;
    public boolean speedupAnimations;
    public boolean speedupBOPFogHandling;
    public boolean speedupChunkCoordinatesHashCode;
    public boolean speedupProgressBar;
    public boolean speedupVanillaFurnace;
    public boolean optimizeTextureLoading;
    public boolean squashBedErrorMessage;
    public boolean tcpNoDelay;
    public boolean thirstyTankContainer;
    public boolean throttleItemPickupEvent;
    public boolean transparentChat;
    public boolean triggerAllConflictingKeybindings;
    public boolean unbindKeybindsByDefault;
    public int defaultLanPort;
    public boolean renderDebug;
    public int renderDebugMode;
    public boolean furnacesPollute;
    public boolean rocketsPollute;
    public boolean railcraftPollutes;
    public int furnacePollutionAmount;
    public int fireboxPollutionAmount;
    public int rocketPollutionAmount;
    public int cokeOvenPollutionAmount;
    public int advancedCokeOvenPollutionAmount;
    public int hobbyistEnginePollutionAmount;
    public int tunnelBorePollutionAmount;
    public double explosionPollutionAmount;
    public boolean cofhWorldTransformer;
    public boolean enableTileRendererProfiler;
    public boolean pollutionAsm;
    public boolean disableAidSpawnByXUSpikes;
    public String thermosCraftServerClass;
    public static Configuration config;
    public static BlockMatcher standardBlocks;
    public static BlockMatcher liquidBlocks;
    public static BlockMatcher doublePlants;
    public static BlockMatcher crossedSquares;
    public static BlockMatcher blockVine;
    public static final String[] defaultPollutionRenderStandardBlock;
    public static final String[] defaultPollutionRenderLiquidBlocks;
    public static final String[] defaultPollutionRenderDoublePlant;
    public static final String[] defaultPollutionRenderCrossedSquares;
    public static final String[] defaultPollutionRenderblockVine;
    public static final String pollutionRecolorComment = "Blocks that should be colored by pollution. \n\tGrouped by the render type. \n\tFormat: [BlockClass]:[colortype] \n\tValid types: GRASS, LEAVES, FLOWER, LIQUID \n\tAdd [-] first to blacklist.";

    public LoadingConfig(File file) {
        config = new Configuration(file);
        this.addCVSupportToWandPedestal = config.get(Category.TWEAKS.toString(), "addCVSupportToWandPedestal", true, "Add CV support to Thaumcraft wand recharge pedestal").getBoolean();
        this.addSystemInfo = config.get(Category.TWEAKS.toString(), "addSystemInfo", true, "Adds system info to the F3 overlay (Java version and vendor; GPU name; OpenGL version; CPU cores; OS name, version and architecture)").getBoolean();
        this.addToggleDebugMessage = config.get(Category.TWEAKS.toString(), "addToggleDebugMessage", true, "Add a debug message in the chat when toggling vanilla debug options").getBoolean();
        this.arabicNumbersForEnchantsPotions = config.get(Category.TWEAKS.toString(), "arabicNumbersForEnchantsPotions", false, "Uses arabic numbers for enchantment levels and potion amplifier levels instead of roman numbers").getBoolean();
        this.chatLength = Math.max(100, Math.min(Short.MAX_VALUE, config.get(Category.TWEAKS.toString(), "chatLength", 8191, "Amount of chat lines kept [100(Vanilla) - 32767]").getInt()));
        this.cofhWorldTransformer = config.get(Category.ASM.toString(), "cofhWorldTransformer", true, "Enable Glease's ASM patch to disable unused CoFH tileentity cache").getBoolean();
        this.deduplicateForestryCompatInBOP = config.get(Category.FIXES.toString(), "deduplicateForestryCompatInBOP", true, "Removes duplicate Fermenter and Squeezer recipes and flower registration").getBoolean();
        this.defaultLanPort = config.get(Category.TWEAKS.toString(), "defaultLanPort", 25565, "Specify default LAN port to open an integrated server on. Set to 0 to always open the server on an automatically allocated port.").getInt();
        this.dimensionManagerDebug = config.get(Category.DEBUG.toString(), "dimensionManagerDebug", true, "Prints debug log if DimensionManager got crashed").getBoolean();
        this.disableWitcheryPotionExtender = config.get(Category.FIXES.toString(), "disableWitcheryPotionExtender", true, "Disable Witchery potion extender for Java 12 compat").getBoolean();
        this.displayIc2FluidLocalizedName = config.get(Category.TWEAKS.toString(), "displayIc2FluidLocalizedName", true, "Display fluid localized name in IC2 fluid cell tooltip").getBoolean();
        this.dropPickedLootOnDespawn = config.get(Category.TWEAKS.toString(), "dropPickedLootOnDespawn", true, "Drop picked loot on entity despawn").getBoolean();
        this.enableDefaultLanPort = config.get(Category.TWEAKS.toString(), "enableDefaultLanPort", true, "Open an integrated server on a static port.").getBoolean();
        this.enableTileRendererProfiler = config.get(Category.TWEAKS.toString(), "enableTileRendererProfiler", true, "Shows renderer's impact on FPS in vanilla lagometer").getBoolean();
        this.changeSprintCategory = config.get(Category.TWEAKS.toString(), "changeSprintCategory", true, "Moves the sprint keybind to the movement category").getBoolean();
        this.fixComponentsPoppingOff = config.get(Category.TWEAKS.toString(), "fixComponentsPoppingOff", true, "Fix Project Red components popping off on unloaded chunks").getBoolean();
        this.fixDebugBoundingBox = config.get(Category.FIXES.toString(), "fixDebugBoundingBox", true, "Fixes the debug hitbox of the player beeing offset").getBoolean();
        this.fixDimensionChangeHearts = config.get(Category.FIXES.toString(), "fixDimensionChangeHearts", true, "Fix losing bonus hearts on dimension change").getBoolean();
        this.fixEatingStackedStew = config.get(Category.FIXES.toString(), "fixEatingStackedStew", true, "Fix deleting stack when eating mushroom stew").getBoolean();
        this.fixEnchantmentNumerals = config.get(Category.FIXES.toString(), "fixEnchantmentNumerals", true, "Fix enchantment levels not displaying properly above a certain value").getBoolean();
        this.fixExtraUtilitiesItemRendering = config.get(Category.FIXES.toString(), "fixExtraUtilitiesItemRendering", true, "Fixes rendering issues with transparent items from extra utilities").getBoolean();
        this.fixExtraUtilitiesUnEnchanting = config.get(Category.FIXES.toString(), "fixExtraUtilitiesUnEnchanting", true, "Fix dupe bug with division sigil removing enchantment").getBoolean();
        this.fixFenceConnections = config.get(Category.FIXES.toString(), "fixFenceConnections", true, "Fix fence connections with other types of fence").getBoolean();
        this.fixFireSpread = config.get(Category.FIXES.toString(), "fixFireSpread", true, "Fix vanilla fire spread sometimes cause NPE on thermos").getBoolean();
        this.fixFontRendererLinewrapRecursion = config.get(Category.FIXES.toString(), "fixFontRendererLinewrapRecursion", true, "Replace recursion with iteration in FontRenderer line wrapping code").getBoolean();
        this.fixFriendlyCreatureSounds = config.get(Category.FIXES.toString(), "fixFriendlyCreatureSounds", true, "Fix vanilla issue where player sounds register as animal sounds").getBoolean();
        this.fixGetBlockLightValue = config.get(Category.FIXES.toString(), "fixGetBlockLightValue", true, "Fix vanilla light calculation sometimes cause NPE on thermos").getBoolean();
        this.fixGlStateBugs = config.get(Category.FIXES.toString(), "fixGlStateBugs", true, "Fix vanilla GL state bugs causing lighting glitches in various perspectives (MC-10135).").getBoolean();
        this.fixGuiGameOver = config.get(Category.FIXES.toString(), "fixGuiGameOver", true, "Fix Game Over GUI buttons disabled if switching fullscreen").getBoolean();
        this.fixHasteArmSwing = config.get(Category.FIXES.toString(), "fixHasteArmSwing", true, "Fix arm not swinging when having too much haste").getBoolean();
        this.fixTimeCommandWithGC = config.get(Category.FIXES.toString(), "fixTimeCommandWithGC", true, "Fix time commands with GC").getBoolean();
        this.fixBibliocraftPackets = config.get(Category.FIXES.toString(), "fixBibliocraftPackets", true, "Fix Biblocraft packet exploits").getBoolean();
        this.fixZTonesPackets = config.get(Category.FIXES.toString(), "fixZTonesPackets", true, "Fix ZTones packet exploits").getBoolean();
        this.fixHopperHitBox = config.get(Category.FIXES.toString(), "fixHopperHitBox", true, "Fix vanilla hopper hit box").getBoolean();
        this.fixHopperVoidingItems = config.get(Category.FIXES.toString(), "fixHopperVoidingItems", true, "Fix Drawer + Hopper voiding items").getBoolean();
        this.fixHudLightingGlitch = config.get(Category.TWEAKS.toString(), "fixHudLightingGlitch", true, "Fix hotbars being dark when Project Red is installed").getBoolean();
        this.fixHugeChatKick = config.get(Category.FIXES.toString(), "fixHugeChatKick", true, "Fix oversized chat message kicking player.").getBoolean();
        this.fixHungerOverhaul = config.get(Category.FIXES.toString(), "fixHungerOverhaul", true, "Fix hunger overhaul low stat effects").getBoolean();
        this.fixHungerOverhaulRestore0Hunger = config.get(Category.FIXES.toString(), "fixHungerOverhaulRestore0Hunger", true, "Fix some items restore 0 hunger").getBoolean();
        this.fixIc2DirectInventoryAccess = config.get(Category.FIXES.toString(), "fixIc2DirectInventoryAccess", true, "Fix IC2's direct inventory access").getBoolean();
        this.fixIc2Hazmat = config.get(Category.FIXES.toString(), "fixIc2Hazmat", true, "Fix IC2 armors to avoid giving poison").getBoolean();
        this.fixIc2Nightvision = config.get(Category.FIXES.toString(), "fixIc2Nightvision", true, "Prevent IC2's nightvision from blinding you").getBoolean();
        this.fixIc2ReactorDupe = config.get(Category.FIXES.toString(), "fixIc2ReactorDupe", true, "Fix IC2's reactor dupe").getBoolean();
        this.fixIc2UnprotectedGetBlock = config.get(Category.FIXES.toString(), "fixIc2UnprotectedGetBlock", true, "Fixes various unchecked IC2 getBlock() methods").getBoolean();
        this.fixIgnisFruitAABB = config.get(Category.FIXES.toString(), "fixIgnisFruitAABB", true, "Fix Axis aligned Bounding Box of Ignis Fruit").getBoolean();
        this.fixImmobileFireballs = config.get(Category.FIXES.toString(), "fixImmobileFireballs", true, "Fix the bug that makes fireballs stop moving when chunk unloads").getBoolean();
        this.fixJourneymapKeybinds = config.get(Category.FIXES.toString(), "fixJourneymapKeybinds", true, "Prevent unbinded keybinds from triggering when pressing certain keys").getBoolean();
        this.fixJourneymapJumpyScrolling = config.get(Category.FIXES.toString(), "fixJourneymapJumpyScrolling", true, "Fix jumpy scrolling in the waypoint manager screen").getBoolean();
        this.fixJourneymapFilePath = config.get(Category.FIXES.toString(), "fixJourneymapFilePath", true, "Prevents journeymap from using illegal character in file paths").getBoolean();
        this.fixNetherLeavesFaceRendering = config.get(Category.FIXES.toString(), "fixNetherLeavesFaceRendering", true, "If fancy graphics are enabled, Nether Leaves render sides with other Nether Leaves adjacent too").getBoolean();
        this.fixNorthWestBias = config.get(Category.FIXES.toString(), "fixNorthWestBias", true, "Fix northwest bias on RandomPositionGenerator").getBoolean();
        this.fixOptifineChunkLoadingCrash = config.get(Category.FIXES.toString(), "fixOptifineChunkLoadingCrash", true, "Forces the chunk loading option from optifine to default since other values can crash the game").getBoolean();
        this.fixPerspectiveCamera = config.get(Category.FIXES.toString(), "fixPerspectiveCamera", true, "Prevent tall grass and such to affect the perspective camera").getBoolean();
        this.fixPotionEffectNumerals = config.get(Category.FIXES.toString(), "fixPotionEffectNumerals", true, "Properly display level of potion effects in the inventory and on tooltips").getBoolean();
        this.fixPotionEffectRender = config.get(Category.TWEAKS.toString(), "fixPotionEffectRender", true, "Fix vanilla potion effects rendering above the NEI tooltips in the inventory").getBoolean();
        this.fixPotionIterating = config.get(Category.FIXES.toString(), "fixPotionIterating", true, "Fix crashes with ConcurrentModificationException because of incorrectly iterating over active potions").getBoolean();
        this.enlargePotionArray = config.get(Category.FIXES.toString(), "enlargePotionArray", true, "Safely enlarge the potion array before other mods").getBoolean();
        this.fixPotionLimit = config.get(Category.FIXES.toString(), "fixPotionLimit", true, "Fix potions >= 128").getBoolean();
        this.fixPotionRenderOffset = config.get(Category.TWEAKS.toString(), "fixPotionRenderOffset", true, "Prevents the inventory from shifting when the player has active potion effects").getBoolean();
        this.fixResizableFullscreen = config.get(Category.FIXES.toString(), "fixResizableFullscreen", true, "Fix game window becoming not resizable after toggling fullscrean in any way").getBoolean();
        this.fixResourcePackOpening = config.get(Category.FIXES.toString(), "fixResourcePackOpening", true, "Fix resource pack folder not opening on Windows if file path has a space").getBoolean();
        this.fixThaumcraftAspectSorting = config.get(Category.FIXES.toString(), "fixThaumcraftAspectSorting", true, "Fix Thaumcraft Aspects being sorted by tag instead of by name").getBoolean();
        this.fixUnfocusedFullscreen = config.get(Category.FIXES.toString(), "fixUnfocusedFullscreen", true, "Fix exiting fullscreen when you tab out of the game").getBoolean();
        this.fixUrlDetection = config.get(Category.FIXES.toString(), "fixUrlDetection", true, "Fix URISyntaxException in forge.").getBoolean();
        this.fixVanillaUnprotectedGetBlock = config.get(Category.FIXES.toString(), "fixVanillaUnprotectedGetBlock", true, "Fixes various unchecked vanilla getBlock() methods").getBoolean();
        this.fixVillageUncheckedGetBlock = config.get(Category.FIXES.toString(), "fixVillageUncheckedGetBlock", true, "Fixes village unchecked getBlock() calls").getBoolean();
        this.fixWorldGetBlock = config.get(Category.FIXES.toString(), "fixWorldGetBlock", true, "Fix unprotected getBlock() in World").getBoolean();
        this.fixWorldServerLeakingUnloadedEntities = config.get(Category.FIXES.toString(), "fixWorldServerLeakingUnloadedEntities", true, "Fix WorldServer leaking entities when no players are present in a dimension").getBoolean();
        this.fixXaerosWorldMapScroll = config.get(Category.FIXES.toString(), "fixXaerosWorldMapScrolling", true, "Fix scrolling in the world map screen").getBoolean();
        this.hideCrosshairInThirdPerson = config.get(Category.TWEAKS.toString(), "hideCrosshairInThirdPerson", true, "Stops rendering the crosshair when you are playing in third person").getBoolean();
        this.hideIc2ReactorSlots = config.get(Category.TWEAKS.toString(), "hideIc2ReactorSlots", true, "Prevent IC2's reactor's coolant slots from being accessed by automations if not a fluid reactor").getBoolean();
        this.hidePotionParticlesFromSelf = config.get(Category.TWEAKS.toString(), "hidePotionParticlesFromSelf", true, "Stops rendering potion particles from yourself").getBoolean();
        this.ic2SeedMaxStackSize = config.get(Category.TWEAKS.toString(), "ic2SeedMaxStackSize", 64, "IC2 seed max stack size", 1, 64).getInt();
        this.increaseParticleLimit = config.get(Category.TWEAKS.toString(), "increaseParticleLimit", true, "Increase particle limit").getBoolean();
        this.installAnchorAlarm = config.get(Category.TWEAKS.toString(), "installAnchorAlarm", true, "Wake up passive & personal anchors on player login").getBoolean();
        this.itemStacksPickedUpPerTick = Math.max(1, config.get(Category.FIXES.toString(), "itemStacksPickedUpPerTick", 36, "Stacks picked up per tick").getInt());
        this.java12BopCompat = config.get(Category.FIXES.toString(), "java12BopCompat", true, "BiomesOPlenty Java 12 compatibility patches.").getBoolean();
        this.java12ImmersiveEngineeringCompat = config.get(Category.FIXES.toString(), "java12ImmersiveEngineeringCompat", true, "Immersive Engineering Java 12 compatibility patch").getBoolean();
        this.logHugeChat = config.get(Category.FIXES.toString(), "logHugeChat", true, "Log oversized chat message to console. WARNING: might create huge log files if this happens very often.").getBoolean();
        this.longerChat = config.get(Category.TWEAKS.toString(), "longerChat", true, "Makes the chat history longer instead of 100 lines").getBoolean();
        this.makeBigFirsPlantable = config.get(Category.TWEAKS.toString(), "makeBigFirsPlantable", true, "Allow 5 Fir Sapling planted together ('+' shape) to grow to a big fir tree").getBoolean();
        this.optimizeASMDataTable = config.get(Category.SPEEDUPS.toString(), "optimizeASMDataTable", true, "Optimize ASMDataTable getAnnotationsFor for faster startup").getBoolean();
        this.optimizeIc2ReactorInventoryAccess = config.get(Category.FIXES.toString(), "optimizeIc2ReactorInventoryAccess", true, "Optimize inventory access to IC2 nuclear reactor").getBoolean();
        this.optimizeTileentityRemoval = config.get(Category.SPEEDUPS.toString(), "optimizeTileentityRemoval", true, "Optimize tileEntity removal in World.class").getBoolean();
        this.optimizeWorldUpdateLight = config.get(Category.FIXES.toString(), "optimizeWorldUpdateLight", true, "Fix too early light initialization").getBoolean();
        this.particleLimit = Math.max(Math.min(config.get(Category.TWEAKS.toString(), "particleLimit", 8000, "Particle limit [4000-16000]").getInt(), 16000), 4000);
        this.preventPickupLoot = config.get(Category.TWEAKS.toString(), "preventPickupLoot", true, "Prevent monsters from picking up loot.").getBoolean();
        this.enableMacosCmdShortcuts = config.get(Category.TWEAKS.toString(), "enableMacosCmdShortcuts", true, "Use CMD key on MacOS to COPY / INSERT / SELECT in text fields (Chat, NEI, Server IP etc.)").getBoolean();
        this.removeSpawningMinecartSound = config.get(Category.TWEAKS.toString(), "removeSpawningMinecartSound", true, "Stop playing a sound when spawning a minecart in the world").getBoolean();
        this.removeUpdateChecks = config.get(Category.FIXES.toString(), "removeUpdateChecks", true, "Remove old/stale/outdated update checks.").getBoolean();
        this.renderDebug = config.get(Category.DEBUG.toString(), "renderDebug", true, "Enable GL state debug hooks. Will not do anything useful unless mode is changed to nonzero.").getBoolean();
        this.renderDebugMode = config.get(Category.DEBUG.toString(), "renderDebugMode", 0, "Default GL state debug mode. 0 - off, 1 - reduced, 2 - full").setMinValue(0).setMaxValue(2).getInt();
        this.speedupAnimations = config.get(Category.FIXES.toString(), "speedupAnimations", true, "Drastically speedup animated textures (Basically the same as with optifine animations off but animations are working)").getBoolean();
        this.speedupBOPFogHandling = config.get(Category.SPEEDUPS.toString(), "speedupBOPFogHandling", true, "Speedup biome fog rendering in BiomesOPlenty").getBoolean();
        this.speedupChunkCoordinatesHashCode = config.get(Category.SPEEDUPS.toString(), "speedupChunkCoordinatesHashCode", true, "Speedup ChunkCoordinates hashCode").getBoolean();
        this.speedupProgressBar = config.get(Category.ASM.toString(), "speedupProgressBar", true, "Speedup progressbar").getBoolean();
        this.speedupVanillaFurnace = config.get(Category.SPEEDUPS.toString(), "speedupVanillaFurnace", true, "Speedup Vanilla Furnace recipe lookup").getBoolean();
        this.optimizeTextureLoading = config.get(Category.SPEEDUPS.toString(), "optimizeTextureLoading", true, "Optimize texture loading").getBoolean();
        this.squashBedErrorMessage = config.get(Category.FIXES.toString(), "squashBedErrorMessage", true, "Stop \"You can only sleep at night\" message filling the chat").getBoolean();
        this.tcpNoDelay = config.get(Category.SPEEDUPS.toString(), "tcpNoDelay", true, "Sets TCP_NODELAY to true, reducing network latency in multiplayer. Works on server as well as client. From makamys/CoreTweaks").getBoolean();
        this.thermosCraftServerClass = config.get(Category.ASM.toString(), "thermosCraftServerClass", "org.bukkit.craftbukkit.v1_7_R4.CraftServer", "If using Bukkit/Thermos, the CraftServer package.").getString();
        this.thirstyTankContainer = config.get(Category.TWEAKS.toString(), "thirstyTankContainer", true, "Implement container for thirsty tank").getBoolean();
        this.throttleItemPickupEvent = config.get(Category.FIXES.toString(), "throttleItemPickupEvent", true, "Limits the amount of times the ItemPickupEvent triggers per tick since it can lead to a lot of lag").getBoolean();
        this.transparentChat = config.get(Category.TWEAKS.toString(), "transparentChat", true, "Doesn't render the black box behind messages when the chat is closed").getBoolean();
        this.triggerAllConflictingKeybindings = config.get(Category.FIXES.toString(), "triggerAllConflictingKeybindings", true, "Triggers all conflicting key bindings on key press instead of a random one").getBoolean();
        this.unbindKeybindsByDefault = config.get(Category.TWEAKS.toString(), "unbindKeybindsByDefault", true, "Unbinds keybinds of certain ARR mods to avoid keybinds conflicts").getBoolean();
        this.pollutionAsm = config.get(Category.ASM.toString(), "pollutionAsm", false, "Enable pollution rendering ASM").getBoolean();
        this.furnacesPollute = config.get(Category.POLLUTION.toString(), "furnacesPollute", true, "Make furnaces Pollute").getBoolean();
        this.rocketsPollute = config.get(Category.POLLUTION.toString(), "rocketsPollute", true, "Make rockets Pollute").getBoolean();
        this.railcraftPollutes = config.get(Category.POLLUTION.toString(), "railcraftPollutes", true, "Make Railcraft Pollute").getBoolean();
        this.disableAidSpawnByXUSpikes = config.get(Category.TWEAKS.toString(), "disableAidSpawnByXUSpikes", true, "Disables the spawn of zombie aid when zombie is killed by Extra Utilities Spikes, since it can spawn them too far.").getBoolean();
        this.furnacePollutionAmount = config.get(Category.POLLUTION.toString(), "furnacePollution", 20, "Furnace pollution per second, min 1!", 1, Integer.MAX_VALUE).getInt();
        this.fireboxPollutionAmount = config.get(Category.POLLUTION.toString(), "fireboxPollution", 15, "Pollution Amount for RC Firebox", 1, Integer.MAX_VALUE).getInt();
        this.rocketPollutionAmount = config.get(Category.POLLUTION.toString(), "rocketPollution", 1000, "Pollution Amount for Rockets", 1, Integer.MAX_VALUE).getInt();
        this.cokeOvenPollutionAmount = config.get(Category.POLLUTION.toString(), "cokeOvenPollution", 3, "Pollution Amount for Coke Ovens", 1, Integer.MAX_VALUE).getInt();
        this.advancedCokeOvenPollutionAmount = config.get(Category.POLLUTION.toString(), "advancedCokeOvenPollution", 80, "Pollution Amount for Advanced Coke Ovens", 1, Integer.MAX_VALUE).getInt();
        this.hobbyistEnginePollutionAmount = config.get(Category.POLLUTION.toString(), "hobbyistEnginePollution", 20, "Pollution Amount for hobbyist steam engine", 1, Integer.MAX_VALUE).getInt();
        this.tunnelBorePollutionAmount = config.get(Category.POLLUTION.toString(), "tunnelBorePollution", 2, "Pollution Amount for tunnel bore", 1, Integer.MAX_VALUE).getInt();
        this.explosionPollutionAmount = config.get(Category.POLLUTION.toString(), "explosionPollution", 33.34, "Explosion pollution").getDouble();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postInitClient() {
        if (config == null) {
            System.err.println("Didn't load HODGEPODGE");
            config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        standardBlocks.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderStandardBlock", defaultPollutionRenderStandardBlock).getStringList());
        liquidBlocks.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderBlockLiquid", defaultPollutionRenderLiquidBlocks).getStringList());
        doublePlants.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderBlockDoublePlant", defaultPollutionRenderDoublePlant).getStringList());
        crossedSquares.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderCrossedSquares", defaultPollutionRenderCrossedSquares).getStringList());
        blockVine.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderblockVine", defaultPollutionRenderblockVine).getStringList());
        config.getCategory(Category.POLLUTION_RECOLOR.toString()).setComment(pollutionRecolorComment);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        standardBlocks = new BlockMatcher();
        liquidBlocks = new BlockMatcher();
        doublePlants = new BlockMatcher();
        crossedSquares = new BlockMatcher();
        blockVine = new BlockMatcher();
        defaultPollutionRenderStandardBlock = new String[]{"net.minecraft.block.BlockGrass:GRASS", "net.minecraft.block.BlockLeavesBase:LEAVES", "biomesoplenty.common.blocks.BlockOriginGrass:GRASS", "biomesoplenty.common.blocks.BlockLongGrass:GRASS", "biomesoplenty.common.blocks.BlockNewGrass:GRASS", "tconstruct.blocks.slime.SlimeGrass:GRASS", "thaumcraft.common.blocks.BlockMagicalLeaves:LEAVES"};
        defaultPollutionRenderLiquidBlocks = new String[]{"net.minecraft.block.BlockLiquid:LIQUID"};
        defaultPollutionRenderDoublePlant = new String[]{"net.minecraft.block.BlockDoublePlant:FLOWER"};
        defaultPollutionRenderCrossedSquares = new String[]{"net.minecraft.block.BlockTallGrass:FLOWER", "net.minecraft.block.BlockFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower2:FLOWER", "biomesoplenty.common.blocks.BlockBOPFoliage:FLOWER"};
        defaultPollutionRenderblockVine = new String[]{"net.minecraft.block.BlockVine:FLOWER"};
    }

    static enum Category {
        ASM,
        DEBUG,
        FIXES,
        OVERALL,
        SPEEDUPS,
        TWEAKS,
        POLLUTION_RECOLOR,
        POLLUTION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

