/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.core.util.ColorOverrideType;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.event.world.WorldEvent;

public class BlockMatcher {
    public Map<Class<?>, ColorOverrideType> whiteList = Maps.newHashMap();
    public Set<Class<?>> blackList = Sets.newHashSet();
    public Map<Integer, ColorOverrideType> blockIDs = Maps.newHashMap();

    public ColorOverrideType matchesID(int blockId) {
        return this.blockIDs.get(blockId);
    }

    public ColorOverrideType matchesID(Block block) {
        return this.blockIDs.get(Block.field_149771_c.func_148757_b((Object)block));
    }

    public void updateClassList(String[] cfg) {
        this.whiteList.clear();
        this.blackList.clear();
        for (String line : cfg) {
            Common.log.info("Checking for block:" + line);
            String[] lines = line.split(":");
            ColorOverrideType type = null;
            if (lines.length > 1) {
                try {
                    type = ColorOverrideType.get(lines[1].trim());
                }
                catch (NumberFormatException e) {
                    Common.log.error(String.format("Invalid type [%s]", line));
                    continue;
                }
            }
            if (lines[0].startsWith("-")) {
                try {
                    this.blackList.add(Class.forName(lines[0].substring(1)));
                    Common.log.info("\t added blacklist:" + lines[0].substring(1));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            if (type == null) {
                Common.log.error(String.format("Invalid type [%s]", line));
                continue;
            }
            try {
                this.whiteList.put(Class.forName(lines[0]), type);
                Common.log.info("\t added whitelist:" + lines[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void updateBlockIDs() {
        this.blockIDs.clear();
        FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
        for (Block block : blockRegistry.typeSafeIterable()) {
            ColorOverrideType t = this.matchesClass(block);
            if (t == null) continue;
            this.blockIDs.put(Block.field_149771_c.func_148757_b((Object)block), t);
        }
    }

    private ColorOverrideType matchesClass(Block block) {
        for (Class<?> clazz : this.blackList) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return null;
        }
        for (Class<?> clazz : this.whiteList.keySet()) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return this.whiteList.get(clazz);
        }
        return null;
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof WorldClient) {
            this.updateBlockIDs();
        }
    }
}

