/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.core.util.BlockMatcher;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import java.io.File;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public class LoadingConfig {
    public String[] requiredMods;
    public boolean requiredModsInDev;
    public int ic2SeedMaxStackSize;
    public int particleLimit;
    public int itemStacksPickedUpPerTick;
    public int chatLength;
    public boolean addSystemInfo;
    public boolean addCVSupportToWandPedestal;
    public boolean dropPickedLootOnDespawn;
    public boolean fixFenceConnections;
    public boolean fixFireSpread;
    public boolean fixGetBlockLightValue;
    public boolean fixGuiGameOver;
    public boolean fixHopperHitBox;
    public boolean fixHungerOverhaul;
    public boolean fixIc2DirectInventoryAccess;
    public boolean fixIc2Hazmat;
    public boolean fixIc2Nightvision;
    public boolean fixIc2ReactorDupe;
    public boolean longerChat;
    public boolean transparentChat;
    public boolean optimizeIc2ReactorInventoryAccess;
    public boolean fixIc2UnprotectedGetBlock;
    public boolean fixNorthWestBias;
    public boolean fixPotionEffectRender;
    public boolean fixPotionRenderOffset;
    public boolean fixPotionLimit;
    public boolean fixImmobileFireballs;
    public boolean fixPerspectiveCamera;
    public boolean fixDebugBoundingBox;
    public boolean fixHopperVoidingItems;
    public boolean fixHugeChatKick;
    public boolean logHugeChat;
    public boolean fixThaumcraftUnprotectedGetBlock;
    public boolean fixGTSawSpawningWaterWithIceBLock;
    public boolean fixUrlDetection;
    public boolean fixVanillaUnprotectedGetBlock;
    public boolean fixWorldGetBlock;
    public boolean fixDimensionChangeHearts;
    public boolean increaseParticleLimit;
    public boolean fixGlStateBugs;
    public boolean hideIc2ReactorSlots;
    public boolean displayIc2FluidLocalizedName;
    public boolean installAnchorAlarm;
    public boolean preventPickupLoot;
    public boolean removeUpdateChecks;
    public boolean tcpNoDelay;
    public boolean speedupChunkCoordinatesHashCode;
    public boolean speedupProgressBar;
    public boolean speedupVanillaFurnace;
    public boolean fixJourneymapKeybinds;
    public boolean deduplicateForestryCompatInBOP;
    public boolean speedupBOPFogHandling;
    public boolean makeBigFirsPlantable;
    public boolean fixHudLightingGlitch;
    public boolean fixComponentsPoppingOff;
    public boolean thirstyTankContainer;
    public boolean fixWorldServerLeakingUnloadedEntities;
    public boolean fixResizableFullscreen;
    public boolean fixUnfocusedFullscreen;
    public boolean addToggleDebugMessage;
    public boolean speedupAnimations;
    public boolean fixPotionIterating;
    public boolean fixIgnisFruitAABB;
    public boolean fixNetherLeavesFaceRendering;
    public boolean optimizeASMDataTable;
    public boolean squashBedErrorMessage;
    public boolean throttleItemPickupEvent;
    public boolean fixOptifineChunkLoadingCrash;
    public boolean hideCrosshairInThirdPerson;
    public boolean hidePotionParticlesFromSelf;
    public boolean enableDefaultLanPort;
    public int defaultLanPort;
    public boolean renderDebug;
    public int renderDebugMode;
    public boolean pollutionAsm;
    public boolean cofhWorldTransformer;
    public boolean enableTileRendererProfiler;
    public boolean biblocraftRecipes;
    public String thermosCraftServerClass;
    public static Configuration config;
    public static BlockMatcher standardBlocks;
    public static BlockMatcher liquidBlocks;
    public static BlockMatcher doublePlants;
    public static BlockMatcher crossedSquares;
    public static BlockMatcher blockVine;
    private static final String[] defaultRequiredMods;
    public static final String[] defaultPollutionRenderStandardBlock;
    public static final String[] defaultPollutionRenderLiquidBlocks;
    public static final String[] defaultPollutionRenderDoublePlant;
    public static final String[] defaultPollutionRenderCrossedSquares;
    public static final String[] defaultPollutionRenderblockVine;
    public static final String pollutionRecolorComment = "Blocks that should be colored by pollution. \n\tGrouped by the render type. \n\tFormat: [BlockClass]:[colortype] \n\tValid types: GRASS, LEAVES, FLOWER, LIQUID \n\tAdd [-] first to blacklist.";

    public LoadingConfig(File file) {
        config = new Configuration(file);
        this.requiredMods = config.get(Category.OVERALL.toString(), "requiredMods", defaultRequiredMods, "Subset of TargetMods that are required").getStringList();
        this.requiredModsInDev = config.get(Category.OVERALL.toString(), "requiredModsInDev", false, "Require the Required Mods in dev").getBoolean();
        this.fixWorldGetBlock = config.get(Category.FIXES.toString(), "fixWorldGetBlock", true, "Fix unprotected getBlock() in World").getBoolean();
        this.fixNorthWestBias = config.get(Category.FIXES.toString(), "fixNorthWestBias", true, "Fix northwest bias on RandomPositionGenerator").getBoolean();
        this.fixFenceConnections = config.get(Category.FIXES.toString(), "fixFenceConnections", true, "Fix fence connections with other types of fence").getBoolean();
        this.fixIc2DirectInventoryAccess = config.get(Category.FIXES.toString(), "fixIc2DirectInventoryAccess", true, "Fix IC2's direct inventory access").getBoolean();
        this.fixIc2ReactorDupe = config.get(Category.FIXES.toString(), "fixIc2ReactorDupe", true, "Fix IC2's reactor dupe").getBoolean();
        this.optimizeIc2ReactorInventoryAccess = config.get(Category.FIXES.toString(), "optimizeIc2ReactorInventoryAccess", true, "Optimize inventory access to IC2 nuclear reactor").getBoolean();
        this.fixIc2Nightvision = config.get(Category.FIXES.toString(), "fixIc2Nightvision", true, "Prevent IC2's nightvision from blinding you").getBoolean();
        this.fixIc2Hazmat = config.get(Category.FIXES.toString(), "fixIc2Hazmat", true, "Fix IC2 armors to avoid giving poison").getBoolean();
        this.fixVanillaUnprotectedGetBlock = config.get(Category.FIXES.toString(), "fixVanillaUnprotectedGetBlock", true, "Fixes various unchecked vanilla getBlock() methods").getBoolean();
        this.fixIc2UnprotectedGetBlock = config.get(Category.FIXES.toString(), "fixIc2UnprotectedGetBlock", true, "Fixes various unchecked IC2 getBlock() methods").getBoolean();
        this.fixThaumcraftUnprotectedGetBlock = config.get(Category.FIXES.toString(), "fixThaumcraftUnprotectedGetBlock", true, "Various Thaumcraft unchecked getBlock() patches").getBoolean();
        this.fixGTSawSpawningWaterWithIceBLock = config.get(Category.FIXES.toString(), "fixGTSawSpawningWaterWithIceBLock", true, "Fixes GT bug that spawns a water source after breaking an ice block with a GT Saw").getBoolean();
        this.fixHungerOverhaul = config.get(Category.FIXES.toString(), "fixHungerOverhaul", true, "Fix hunger overhaul low stat effects").getBoolean();
        this.removeUpdateChecks = config.get(Category.FIXES.toString(), "removeUpdateChecks", true, "Remove old/stale/outdated update checks.").getBoolean();
        this.fixGuiGameOver = config.get(Category.FIXES.toString(), "fixGuiGameOver", true, "Fix Game Over GUI buttons disabled if switching fullscreen").getBoolean();
        this.fixHopperHitBox = config.get(Category.FIXES.toString(), "fixHopperHitBox", true, "Fix vanilla hopper hit box").getBoolean();
        this.fixGetBlockLightValue = config.get(Category.FIXES.toString(), "fixGetBlockLightValue", true, "Fix vanilla light calculation sometimes cause NPE on thermos").getBoolean();
        this.fixFireSpread = config.get(Category.FIXES.toString(), "fixFireSpread", true, "Fix vanilla fire spread sometimes cause NPE on thermos").getBoolean();
        this.fixUrlDetection = config.get(Category.FIXES.toString(), "fixUrlDetection", true, "Fix URISyntaxException in forge.").getBoolean();
        this.fixDimensionChangeHearts = config.get(Category.FIXES.toString(), "fixDimensionChangeHearts", true, "Fix losing bonus hearts on dimension change").getBoolean();
        this.fixPotionLimit = config.get(Category.FIXES.toString(), "fixPotionLimit", true, "Fix potions >= 128").getBoolean();
        this.fixImmobileFireballs = config.get(Category.FIXES.toString(), "fixImmobileFireballs", true, "Fix the bug that makes fireballs stop moving when chunk unloads").getBoolean();
        this.fixPerspectiveCamera = config.get(Category.FIXES.toString(), "fixPerspectiveCamera", true, "Prevent tall grass and such to affect the perspective camera").getBoolean();
        this.fixDebugBoundingBox = config.get(Category.FIXES.toString(), "fixDebugBoundingBox", true, "Fixes the debug hitbox of the player beeing offset").getBoolean();
        this.fixGlStateBugs = config.get(Category.FIXES.toString(), "fixGlStateBugs", true, "Fix vanilla GL state bugs causing lighting glitches in various perspectives (MC-10135).").getBoolean();
        this.deduplicateForestryCompatInBOP = config.get(Category.FIXES.toString(), "deduplicateForestryCompatInBOP", true, "Removes duplicate Fermenter and Squeezer recipes and flower registration").getBoolean();
        this.fixHopperVoidingItems = config.get(Category.FIXES.toString(), "fixHopperVoidingItems", true, "Fix Drawer + Hopper voiding items").getBoolean();
        this.fixHugeChatKick = config.get(Category.FIXES.toString(), "fixHugeChatKick", true, "Fix oversized chat message kicking player.").getBoolean();
        this.logHugeChat = config.get(Category.FIXES.toString(), "logHugeChat", true, "Log oversized chat message to console. WARNING: might create huge log files if this happens very often.").getBoolean();
        this.fixWorldServerLeakingUnloadedEntities = config.get(Category.FIXES.toString(), "fixWorldServerLeakingUnloadedEntities", true, "Fix WorldServer leaking entities when no players are present in a dimension").getBoolean();
        this.fixResizableFullscreen = config.get(Category.FIXES.toString(), "fixResizableFullscreen", true, "Fix game window becoming not resizable after toggling fullscrean in any way").getBoolean();
        this.fixUnfocusedFullscreen = config.get(Category.FIXES.toString(), "fixUnfocusedFullscreen", true, "Fix exiting fullscreen when you tab out of the game").getBoolean();
        this.speedupAnimations = config.get(Category.FIXES.toString(), "speedupAnimations", true, "Drastically speedup animated textures (Basically the same as with optifine animations off but animations are working)").getBoolean();
        this.fixPotionIterating = config.get(Category.FIXES.toString(), "fixPotionIterating", true, "Fix crashes with ConcurrentModificationException because of incorrectly iterating over active potions").getBoolean();
        this.fixIgnisFruitAABB = config.get(Category.FIXES.toString(), "fixIgnisFruitAABB", true, "Fix Axis aligned Bounding Box of Ignis Fruit").getBoolean();
        this.fixNetherLeavesFaceRendering = config.get(Category.FIXES.toString(), "fixNetherLeavesFaceRendering", true, "If fancy graphics are enabled, Nether Leaves render sides with other Nether Leaves adjacent too").getBoolean();
        this.fixJourneymapKeybinds = config.get(Category.FIXES.toString(), "fixJourneymapKeybinds", true, "Prevent unbinded keybinds from triggering when pressing certain keys").getBoolean();
        this.squashBedErrorMessage = config.get(Category.FIXES.toString(), "squashBedErrorMessage", true, "Stop \"You can only sleep at night\" message filling the chat").getBoolean();
        this.throttleItemPickupEvent = config.get(Category.FIXES.toString(), "throttleItemPickupEvent", true, "Limits the amount of times the ItemPickupEvent triggers per tick since it can lead to a lot of lag").getBoolean();
        this.itemStacksPickedUpPerTick = Math.max(1, config.get(Category.FIXES.toString(), "itemStacksPickedUpPerTick", 36, "Stacks picked up per tick").getInt());
        this.fixOptifineChunkLoadingCrash = config.get(Category.FIXES.toString(), "fixOptifineChunkLoadingCrash", true, "Forces the chunk loading option from optifine to default since other values can crash the game").getBoolean();
        this.increaseParticleLimit = config.get(Category.TWEAKS.toString(), "increaseParticleLimit", true, "Increase particle limit").getBoolean();
        this.particleLimit = Math.max(Math.min(config.get(Category.TWEAKS.toString(), "particleLimit", 8000, "Particle limit [4000-16000]").getInt(), 16000), 4000);
        this.fixPotionEffectRender = config.get(Category.TWEAKS.toString(), "fixPotionEffectRender", true, "Fix vanilla potion effects rendering above the NEI tooltips in the inventory").getBoolean();
        this.fixPotionRenderOffset = config.get(Category.TWEAKS.toString(), "fixPotionRenderOffset", true, "Prevents the inventory from shifting when the player has active potion effects").getBoolean();
        this.installAnchorAlarm = config.get(Category.TWEAKS.toString(), "installAnchorAlarm", true, "Wake up passive & personal anchors on player login").getBoolean();
        this.preventPickupLoot = config.get(Category.TWEAKS.toString(), "preventPickupLoot", true, "Prevent monsters from picking up loot.").getBoolean();
        this.dropPickedLootOnDespawn = config.get(Category.TWEAKS.toString(), "dropPickedLootOnDespawn", true, "Drop picked loot on entity despawn").getBoolean();
        this.hideIc2ReactorSlots = config.get(Category.TWEAKS.toString(), "hideIc2ReactorSlots", true, "Prevent IC2's reactor's coolant slots from being accessed by automations if not a fluid reactor").getBoolean();
        this.displayIc2FluidLocalizedName = config.get(Category.TWEAKS.toString(), "displayIc2FluidLocalizedName", true, "Display fluid localized name in IC2 fluid cell tooltip").getBoolean();
        this.enableTileRendererProfiler = config.get(Category.TWEAKS.toString(), "enableTileRendererProfiler", true, "Shows renderer's impact on FPS in vanilla lagometer").getBoolean();
        this.addCVSupportToWandPedestal = config.get(Category.TWEAKS.toString(), "addCVSupportToWandPedestal", true, "Add CV support to Thaumcraft wand recharge pedestal").getBoolean();
        this.makeBigFirsPlantable = config.get(Category.TWEAKS.toString(), "makeBigFirsPlantable", true, "Allow 5 Fir Sapling planted together ('+' shape) to grow to a big fir tree").getBoolean();
        this.ic2SeedMaxStackSize = config.get(Category.TWEAKS.toString(), "ic2SeedMaxStackSize", 64, "IC2 seed max stack size").getInt();
        this.addSystemInfo = config.get(Category.TWEAKS.toString(), "addSystemInfo", true, "Adds system info to the F3 overlay (Java version and vendor; GPU name; OpenGL version; CPU cores; OS name, version and architecture)").getBoolean();
        this.fixHudLightingGlitch = config.get(Category.TWEAKS.toString(), "fixHudLightingGlitch", true, "Fix hotbars being dark when Project Red is installed").getBoolean();
        this.fixComponentsPoppingOff = config.get(Category.TWEAKS.toString(), "fixComponentsPoppingOff", true, "Fix Project Red components popping off on unloaded chunks").getBoolean();
        this.thirstyTankContainer = config.get(Category.TWEAKS.toString(), "thirstyTankContainer", true, "Implement container for thirsty tank").getBoolean();
        this.enableDefaultLanPort = config.get(Category.TWEAKS.toString(), "enableDefaultLanPort", true, "Open an integrated server on a static port.").getBoolean();
        this.defaultLanPort = config.get(Category.TWEAKS.toString(), "defaultLanPort", 25565, "Specify default LAN port to open an integrated server on. Set to 0 to always open the server on an automatically allocated port.").getInt();
        this.addToggleDebugMessage = config.get(Category.TWEAKS.toString(), "addToggleDebugMessage", true, "Add a debug message in the chat when toggling vanilla debug options").getBoolean();
        this.hideCrosshairInThirdPerson = config.get(Category.TWEAKS.toString(), "hideCrosshairInThirdPerson", true, "Stops rendering the crosshair when you are playing in third person").getBoolean();
        this.longerChat = config.get(Category.TWEAKS.toString(), "longerChat", true, "Makes the chat history longer instead of 100 lines").getBoolean();
        this.chatLength = Math.max(100, Math.min(Short.MAX_VALUE, config.get(Category.TWEAKS.toString(), "chatLength", 8191, "Amount of chat lines kept [100(Vanilla) - 32767]").getInt()));
        this.transparentChat = config.get(Category.TWEAKS.toString(), "transparentChat", true, "Doesn't render the black box behind messages when the chat is closed").getBoolean();
        this.hidePotionParticlesFromSelf = config.get(Category.TWEAKS.toString(), "hidePotionParticlesFromSelf", true, "Stops rendering potion particles from yourself").getBoolean();
        this.optimizeASMDataTable = config.get(Category.SPEEDUPS.toString(), "optimizeASMDataTable", true, "Optimize ASMDataTable getAnnotationsFor for faster startup").getBoolean();
        this.tcpNoDelay = config.get(Category.SPEEDUPS.toString(), "tcpNoDelay", true, "Sets TCP_NODELAY to true, reducing network latency in multiplayer. Works on server as well as client. From makamys/CoreTweaks").getBoolean();
        this.speedupChunkCoordinatesHashCode = config.get(Category.SPEEDUPS.toString(), "speedupChunkCoordinatesHashCode", true, "Speedup ChunkCoordinates hashCode").getBoolean();
        this.speedupVanillaFurnace = config.get(Category.SPEEDUPS.toString(), "speedupVanillaFurnace", true, "Speedup Vanilla Furnace recipe lookup").getBoolean();
        this.speedupBOPFogHandling = config.get(Category.SPEEDUPS.toString(), "speedupBOPFogHandling", true, "Speedup biome fog rendering in BiomesOPlenty").getBoolean();
        this.speedupProgressBar = config.get(Category.ASM.toString(), "speedupProgressBar", true, "Speedup progressbar").getBoolean();
        this.pollutionAsm = config.get(Category.ASM.toString(), "pollutionAsm", false, "Enable pollution rendering ASM").getBoolean();
        this.cofhWorldTransformer = config.get(Category.ASM.toString(), "cofhWorldTransformer", true, "Enable Glease's ASM patch to disable unused CoFH tileentity cache").getBoolean();
        this.biblocraftRecipes = config.get(Category.ASM.toString(), "biblocraftRecipes", true, "Remove recipe generation from BiblioCraft").getBoolean();
        this.thermosCraftServerClass = config.get(Category.ASM.toString(), "thermosCraftServerClass", "org.bukkit.craftbukkit.v1_7_R4.CraftServer", "If using Bukkit/Thermos, the CraftServer package.").getString();
        this.renderDebug = config.get(Category.DEBUG.toString(), "renderDebug", true, "Enable GL state debug hooks. Will not do anything useful unless mode is changed to nonzero.").getBoolean();
        this.renderDebugMode = config.get(Category.DEBUG.toString(), "renderDebugMode", 0, "Default GL state debug mode. 0 - off, 1 - reduced, 2 - full").setMinValue(0).setMaxValue(2).getInt();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postInitClient() {
        if (config == null) {
            System.err.println("Didn't load HODGEPODGE");
            config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        standardBlocks.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderStandardBlock", defaultPollutionRenderStandardBlock).getStringList());
        liquidBlocks.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderBlockLiquid", defaultPollutionRenderLiquidBlocks).getStringList());
        doublePlants.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderBlockDoublePlant", defaultPollutionRenderDoublePlant).getStringList());
        crossedSquares.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderCrossedSquares", defaultPollutionRenderCrossedSquares).getStringList());
        blockVine.updateClassList(config.get(Category.POLLUTION_RECOLOR.toString(), "renderblockVine", defaultPollutionRenderblockVine).getStringList());
        config.getCategory(Category.POLLUTION_RECOLOR.toString()).setComment(pollutionRecolorComment);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        standardBlocks = new BlockMatcher();
        liquidBlocks = new BlockMatcher();
        doublePlants = new BlockMatcher();
        crossedSquares = new BlockMatcher();
        blockVine = new BlockMatcher();
        defaultRequiredMods = (String[])Arrays.stream(TargetedMod.values()).filter(mod -> mod.optional == false).map(f -> f.modName).toArray(String[]::new);
        defaultPollutionRenderStandardBlock = new String[]{"net.minecraft.block.BlockGrass:GRASS", "net.minecraft.block.BlockLeavesBase:LEAVES", "biomesoplenty.common.blocks.BlockOriginGrass:GRASS", "biomesoplenty.common.blocks.BlockLongGrass:GRASS", "biomesoplenty.common.blocks.BlockNewGrass:GRASS", "tconstruct.blocks.slime.SlimeGrass:GRASS", "thaumcraft.common.blocks.BlockMagicalLeaves:LEAVES"};
        defaultPollutionRenderLiquidBlocks = new String[]{"net.minecraft.block.BlockLiquid:LIQUID"};
        defaultPollutionRenderDoublePlant = new String[]{"net.minecraft.block.BlockDoublePlant:FLOWER"};
        defaultPollutionRenderCrossedSquares = new String[]{"net.minecraft.block.BlockTallGrass:FLOWER", "net.minecraft.block.BlockFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower2:FLOWER", "biomesoplenty.common.blocks.BlockBOPFoliage:FLOWER"};
        defaultPollutionRenderblockVine = new String[]{"net.minecraft.block.BlockVine:FLOWER"};
    }

    static enum Category {
        ASM,
        DEBUG,
        FIXES,
        OVERALL,
        SPEEDUPS,
        TWEAKS,
        POLLUTION_RECOLOR;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

