/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.mixins.Mixins;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import ru.timeconqueror.spongemixins.MinecraftURLClassPath;

public class HodgepodgeMixinPlugin
implements IMixinConfigPlugin {
    public static boolean isEnvironmentDeobfuscated;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        isEnvironmentDeobfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        List<TargetedMod> loadedMods = Arrays.stream(TargetedMod.values()).filter(mod -> mod == TargetedMod.VANILLA || isEnvironmentDeobfuscated && MinecraftURLClassPath.findJarInClassPath((String)mod.devJarName) || this.loadModJar((TargetedMod)((Object)mod))).collect(Collectors.toList());
        for (TargetedMod mod2 : TargetedMod.values()) {
            if (loadedMods.contains((Object)mod2)) {
                Common.log.info("Found Mod " + mod2.modName + "!");
                continue;
            }
            if (ArrayUtils.contains((Object[])Common.config.requiredMods, (Object)mod2.modName) && (!isEnvironmentDeobfuscated || Common.config.requiredModsInDev)) {
                Common.log.error("CRITICAL ERROR: Could not find required jar {}.  If this mod is not required please remove it from the 'requiredMods' section of the config.", new Object[]{mod2.modName});
                FMLCommonHandler.instance().exitJava(-1, true);
                continue;
            }
            Common.log.info("Could not find " + mod2.modName + "! Skipping mixins....");
        }
        ArrayList<String> mixins = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.shouldLoad(loadedMods)) {
                mixins.addAll(mixin.mixinClass);
                Common.log.info("Loading hodgepodge mixin: " + mixin.mixinClass);
                continue;
            }
            Common.log.info("NOT loading mixin: " + mixin.mixinClass);
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean loadModJar(TargetedMod mod) {
        try {
            File jar = MinecraftURLClassPath.getJarInModPath((String)mod.jarName);
            if (jar == null) {
                Common.log.info("Jar not found for " + (Object)((Object)mod));
                return false;
            }
            Common.log.info("Attempting to add " + jar + " to the URL Class Path");
            if (!jar.exists()) {
                throw new FileNotFoundException(jar.toString());
            }
            MinecraftURLClassPath.addJar((File)jar);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

