/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.client;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.core.HodgePodgeClient;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class DebugScreenHandler {
    public static final DebugScreenHandler INSTANCE = new DebugScreenHandler();
    private boolean is64bit = DebugScreenHandler.check64bit();
    private String javaVersion = System.getProperty("java.version");
    private String javaVendor = System.getProperty("java.vendor");
    private String gpuName = GL11.glGetString((int)7937);
    private String glVersion = GL11.glGetString((int)7938);
    private String osArch = System.getProperty("os.arch");
    private String osName = System.getProperty("os.name");
    private String osVersion = System.getProperty("os.version");

    private DebugScreenHandler() {
    }

    @SubscribeEvent
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.right.add(2, null);
            event.right.add(3, "Java: " + this.javaVersion + (this.is64bit ? " 64bit (" : " 32bit (") + this.javaVendor + ")");
            event.right.add(4, "GPU: " + this.gpuName);
            event.right.add(5, "OpenGL: " + this.glVersion);
            event.right.add(6, "CPU Cores: " + Runtime.getRuntime().availableProcessors());
            event.right.add(7, "OS: " + this.osName + " (" + this.osVersion + ", " + this.osArch + ")");
            if (Common.config.speedupAnimations || Common.config.renderDebug) {
                event.right.add(8, null);
                if (Common.config.speedupAnimations) {
                    event.right.add(9, "animationsMode: " + HodgePodgeClient.animationsMode);
                }
                if (Common.config.renderDebug) {
                    event.right.add(9, "renderDebugMode: " + HodgePodgeClient.renderDebugMode);
                }
            }
        }
    }

    private static boolean check64bit() {
        String[] keys;
        for (String key : keys = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String value = System.getProperty(key);
            if (value == null || !value.contains("64")) continue;
            return true;
        }
        return false;
    }
}

