/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.util;

import com.mitchej123.hodgepodge.core.HodgePodgeClient;
import java.util.HashMap;

public enum ColorOverrideType {
    GRASS("GRASS"),
    LEAVES("LEAVES"),
    FLOWER("FLOWER"),
    LIQUID("LIQUID");

    private static final HashMap<String, ColorOverrideType> byString;
    public String name;

    private ColorOverrideType(String name) {
        this.name = name;
    }

    public static ColorOverrideType get(String name) {
        return byString.get(name);
    }

    public int getColor(int oColor, int x, int z) {
        try {
            switch (this) {
                case GRASS: {
                    return (Integer)HodgePodgeClient.colorGrass.invoke(null, oColor, x, z);
                }
                case FLOWER: {
                    return (Integer)HodgePodgeClient.colorFoliage.invoke(null, oColor, x, z);
                }
                case LEAVES: {
                    return (Integer)HodgePodgeClient.colorLeaves.invoke(null, oColor, x, z);
                }
                case LIQUID: {
                    return (Integer)HodgePodgeClient.colorLiquid.invoke(null, oColor, x, z);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oColor;
    }

    static {
        byString = new HashMap();
        for (ColorOverrideType type : ColorOverrideType.values()) {
            byString.put(type.name, type);
        }
    }
}

