/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.core.util.BlockMatcher;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import java.io.File;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public class LoadingConfig {
    public String[] requiredMods;
    public boolean requiredModsInDev;
    public int ic2SeedMaxStackSize;
    public int particleLimit;
    public boolean addCVSupportToWandPedestal;
    public boolean dropPickedLootOnDespawn;
    public boolean fixFenceConnections;
    public boolean fixFireSpread;
    public boolean fixGetBlockLightValue;
    public boolean fixGuiGameOver;
    public boolean fixHopperHitBox;
    public boolean fixHungerOverhaul;
    public boolean fixIc2DirectInventoryAccess;
    public boolean fixIc2Hazmat;
    public boolean fixIc2Nightvision;
    public boolean fixIc2ReactorDupe;
    public boolean fixIc2UnprotectedGetBlock;
    public boolean fixNorthWestBias;
    public boolean fixPotionEffectRender;
    public boolean fixPotionLimit;
    public boolean fixThaumcraftUnprotectedGetBlock;
    public boolean fixUrlDetection;
    public boolean fixVanillaUnprotectedGetBlock;
    public boolean fixWorldGetBlock;
    public boolean fixDimensionChangeHearts;
    public boolean increaseParticleLimit;
    public boolean hideIc2ReactorSlots;
    public boolean installAnchorAlarm;
    public boolean preventPickupLoot;
    public boolean removeUpdateChecks;
    public boolean speedupChunkCoordinatesHashCode;
    public boolean speedupProgressBar;
    public boolean speedupVanillaFurnace;
    public boolean pollutionAsm;
    public boolean cofhWorldTransformer;
    public boolean enableTileRendererProfiler;
    public boolean biblocraftRecipes;
    public String thermosCraftServerClass;
    public static Configuration config;
    public static BlockMatcher standardBlocks;
    public static BlockMatcher liquidBlocks;
    public static BlockMatcher doublePlants;
    public static BlockMatcher crossedSquares;
    public static BlockMatcher blockVine;
    private static final String[] defaultRequiredMods;
    public static final String[] defaultPollutionRenderStandardBlock;
    public static final String[] defaultPollutionRenderLiquidBlocks;
    public static final String[] defaultPollutionRenderDoublePlant;
    public static final String[] defaultPollutionRenderCrossedSquares;
    public static final String[] defaultPollutionRenderblockVine;
    public static final String pollutionRecolorComment = "Blocks that should be colored by pollution. \n\tGrouped by the render type. \n\tFormat: [BlockClass]:[colortype] \n\tValid types: GRASS, LEAVES, FLOWER, LIQUID \n\tAdd [-] first to blacklist.";

    public LoadingConfig(File file) {
        config = new Configuration(file);
        this.requiredMods = config.get("overall", "requiredMods", defaultRequiredMods, "Subset of TargetMods that are required").getStringList();
        this.requiredModsInDev = config.get("overall", "requiredModsInDev", false, "Require the Required Mods in dev").getBoolean();
        this.fixWorldGetBlock = config.get("fixes", "fixWorldGetBlock", true, "Fix unprotected getBlock() in World").getBoolean();
        this.fixNorthWestBias = config.get("fixes", "fixNorthWestBias", true, "Fix northwest bias on RandomPositionGenerator").getBoolean();
        this.fixFenceConnections = config.get("fixes", "fixFenceConnections", true, "Fix fence connections with other types of fence").getBoolean();
        this.fixIc2DirectInventoryAccess = config.get("fixes", "fixIc2DirectInventoryAccess", true, "Fix IC2's direct inventory access").getBoolean();
        this.fixIc2ReactorDupe = config.get("fixes", "fixIc2ReactorDupe", true, "Fix IC2's reactor dupe").getBoolean();
        this.fixIc2Nightvision = config.get("fixes", "fixIc2Nightvision", true, "Prevent IC2's nightvision from blinding you").getBoolean();
        this.fixIc2Hazmat = config.get("fixes", "fixIc2Hazmat", true, "Fix IC2 armors to avoid giving poison").getBoolean();
        this.fixVanillaUnprotectedGetBlock = config.get("fixes", "fixVanillaUnprotectedGetBlock", true, "Fixes various unchecked vanilla getBlock() methods").getBoolean();
        this.fixIc2UnprotectedGetBlock = config.get("fixes", "fixIc2UnprotectedGetBlock", true, "Fixes various unchecked IC2 getBlock() methods").getBoolean();
        this.fixThaumcraftUnprotectedGetBlock = config.get("fixes", "fixThaumcraftUnprotectedGetBlock", true, "Various Thaumcraft unchecked getBlock() patches").getBoolean();
        this.fixHungerOverhaul = config.get("fixes", "fixHungerOverhaul", true, "Fix hunger overhaul low stat effects").getBoolean();
        this.removeUpdateChecks = config.get("fixes", "removeUpdateChecks", true, "Remove old/stale/outdated update checks.").getBoolean();
        this.fixGuiGameOver = config.get("fixes", "fixGuiGameOver", true, "Fix Game Over GUI buttons disabled if switching fullscreen").getBoolean();
        this.fixHopperHitBox = config.get("fixes", "fixHopperHitBox", true, "Fix vanilla hopper hit box").getBoolean();
        this.fixGetBlockLightValue = config.get("fixes", "fixGetBlockLightValue", true, "Fix vanilla light calculation sometimes cause NPE on thermos").getBoolean();
        this.fixFireSpread = config.get("fixes", "fixFireSpread", true, "Fix vanilla fire spread sometimes cause NPE on thermos").getBoolean();
        this.fixUrlDetection = config.get("fixes", "fixUrlDetection", true, "Fix URISyntaxException in forge.").getBoolean();
        this.fixDimensionChangeHearts = config.get("fixes", "fixDimensionChangeHearts", true, "Fix losing bonus hearts on dimension change").getBoolean();
        this.fixPotionLimit = config.get("fixes", "fixPotionLimit", true, "Fix potions >= 128").getBoolean();
        this.increaseParticleLimit = config.get("tweaks", "increaseParticleLimit", true, "Increase particle limit").getBoolean();
        this.particleLimit = Math.max(Math.min(config.get("tweaks", "particleLimit", 8000, "Particle limit [4000-16000]").getInt(), 16000), 4000);
        this.fixPotionEffectRender = config.get("tweaks", "fixPotionEffectRender", true, "Move vanilla potion effect status rendering before everything else").getBoolean();
        this.installAnchorAlarm = config.get("tweaks", "installAnchorAlarm", true, "Wake up passive & personal anchors on player login").getBoolean();
        this.preventPickupLoot = config.get("tweaks", "preventPickupLoot", true, "Prevent monsters from picking up loot.").getBoolean();
        this.dropPickedLootOnDespawn = config.get("tweaks", "dropPickedLootOnDespawn", true, "Drop picked loot on entity despawn").getBoolean();
        this.hideIc2ReactorSlots = config.get("tweaks", "hideIc2ReactorSlots", true, "Prevent IC2's reactor's coolant slots from being accessed by automations if not a fluid reactor").getBoolean();
        this.enableTileRendererProfiler = config.get("tweaks", "enableTileRendererProfiler", true, "Shows renderer's impact on FPS in vanilla lagometer").getBoolean();
        this.addCVSupportToWandPedestal = config.get("tweaks", "addCVSupportToWandPedestal", true, "Add CV support to Thaumcraft wand recharge pedestal").getBoolean();
        this.ic2SeedMaxStackSize = config.get("tweaks", "ic2SeedMaxStackSize", 64, "IC2 seed max stack size").getInt();
        this.speedupChunkCoordinatesHashCode = config.get("speedups", "speedupChunkCoordinatesHashCode", true, "Speedup ChunkCoordinates hashCode").getBoolean();
        this.speedupVanillaFurnace = config.get("speedups", "speedupVanillaFurnace", true, "Speedup Vanilla Furnace recipe lookup").getBoolean();
        this.speedupProgressBar = config.get("asm", "speedupProgressBar", true, "Speedup progressbar").getBoolean();
        this.pollutionAsm = config.get("asm", "pollutionAsm", true, "Enable pollution rendering ASM").getBoolean();
        this.cofhWorldTransformer = config.get("asm", "cofhWorldTransformer", true, "Enable Glease's ASM patch to disable unused CoFH tileentity cache").getBoolean();
        this.biblocraftRecipes = config.get("asm", "biblocraftRecipes", true, "Remove recipe generation from BiblioCraft").getBoolean();
        this.thermosCraftServerClass = config.get("asm", "thermosCraftServerClass", "org.bukkit.craftbukkit.v1_7_R4.CraftServer", "If using Bukkit/Thermos, the CraftServer package.").getString();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postInitClient() {
        if (config == null) {
            System.err.println("Didn't load HODGEPODGE");
            config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        standardBlocks.updateClassList(config.get("pollutionrecolor", "renderStandardBlock", defaultPollutionRenderStandardBlock).getStringList());
        liquidBlocks.updateClassList(config.get("pollutionrecolor", "renderBlockLiquid", defaultPollutionRenderLiquidBlocks).getStringList());
        doublePlants.updateClassList(config.get("pollutionrecolor", "renderBlockDoublePlant", defaultPollutionRenderDoublePlant).getStringList());
        crossedSquares.updateClassList(config.get("pollutionrecolor", "renderCrossedSquares", defaultPollutionRenderCrossedSquares).getStringList());
        blockVine.updateClassList(config.get("pollutionrecolor", "renderblockVine", defaultPollutionRenderblockVine).getStringList());
        config.getCategory("pollutionrecolor").setComment(pollutionRecolorComment);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        standardBlocks = new BlockMatcher();
        liquidBlocks = new BlockMatcher();
        doublePlants = new BlockMatcher();
        crossedSquares = new BlockMatcher();
        blockVine = new BlockMatcher();
        defaultRequiredMods = (String[])Arrays.stream(TargetedMod.values()).map(f -> f.modName).toArray(String[]::new);
        defaultPollutionRenderStandardBlock = new String[]{"net.minecraft.block.BlockGrass:GRASS", "net.minecraft.block.BlockLeavesBase:LEAVES", "biomesoplenty.common.blocks.BlockOriginGrass:GRASS", "biomesoplenty.common.blocks.BlockLongGrass:GRASS", "biomesoplenty.common.blocks.BlockNewGrass:GRASS", "tconstruct.blocks.slime.SlimeGrass:GRASS", "thaumcraft.common.blocks.BlockMagicalLeaves:LEAVES"};
        defaultPollutionRenderLiquidBlocks = new String[]{"net.minecraft.block.BlockLiquid:LIQUID"};
        defaultPollutionRenderDoublePlant = new String[]{"net.minecraft.block.BlockDoublePlant:FLOWER"};
        defaultPollutionRenderCrossedSquares = new String[]{"net.minecraft.block.BlockTallGrass:FLOWER", "net.minecraft.block.BlockFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower2:FLOWER", "biomesoplenty.common.blocks.BlockBOPFoliage:FLOWER"};
        defaultPollutionRenderblockVine = new String[]{"net.minecraft.block.BlockVine:FLOWER"};
    }
}

