/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.core.util.BlockMatcher;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public class LoadingConfig {
    public boolean fixNorthWestBias;
    public boolean fixFenceConnections;
    public boolean fixIc2DirectInventoryAccess;
    public boolean fixIc2ReactorDupe;
    public boolean fixIc2Nightvision;
    public boolean fixVanillaUnprotectedGetBlock;
    public boolean fixIc2UnprotectedGetBlock;
    public boolean fixThaumcraftUnprotectedGetBlock;
    public boolean speedupChunkCoordinatesHashCode;
    public boolean fixHungerOverhaul;
    public boolean fixGuiGameOver;
    public boolean fixHopperHitBox;
    public boolean removeUpdateChecks;
    public boolean preventPickupLoot;
    public boolean dropPickedLootOnDespawn;
    public boolean installAnchorAlarm;
    public boolean hideIc2ReactorSlots;
    public boolean pollutionAsm;
    public boolean cofhWorldTransformer;
    public static Configuration config;
    public static BlockMatcher standardBlocks;
    public static BlockMatcher liquidBlocks;
    public static BlockMatcher doublePlants;
    public static BlockMatcher crossedSquares;
    public static BlockMatcher blockVine;

    public LoadingConfig(File file) {
        config = new Configuration(file);
        this.fixNorthWestBias = config.get("fixes", "fixNorthWestBias", true, "Fix northwest bias on RandomPositionGenerator").getBoolean();
        this.fixFenceConnections = config.get("fixes", "fixFenceConnections", true, "Fix fence connections with other types of fence").getBoolean();
        this.fixIc2DirectInventoryAccess = config.get("fixes", "fixIc2DirectInventoryAccess", true, "Fix IC2's direct inventory access").getBoolean();
        this.fixIc2ReactorDupe = config.get("fixes", "fixIc2ReactorDupe", true, "Fix IC2's reactor dupe").getBoolean();
        this.fixIc2Nightvision = config.get("fixes", "fixIc2Nightvision", true, "Prevent IC2's nightvision from blinding you").getBoolean();
        this.fixVanillaUnprotectedGetBlock = config.get("fixes", "fixVanillaUnprotectedGetBlock", true, "Fixes various unchecked vanilla getBlock() methods").getBoolean();
        this.fixIc2UnprotectedGetBlock = config.get("fixes", "fixIc2UnprotectedGetBlock", true, "Fixes various unchecked IC2 getBlock() methods").getBoolean();
        this.fixThaumcraftUnprotectedGetBlock = config.get("fixes", "fixThaumcraftUnprotectedGetBlock", true, "Various Thaumcraft unchecked getBlock() patches").getBoolean();
        this.fixHungerOverhaul = config.get("fixes", "fixHungerOverhaul", true, "Fix hunger overhaul low stat effects").getBoolean();
        this.removeUpdateChecks = config.get("fixes", "removeUpdateChecks", true, "Remove old/stale/outdated update checks.").getBoolean();
        this.fixGuiGameOver = config.get("fixes", "fixGuiGameOver", true, "Fix Game Over GUI buttons disabled if switching fullscreen").getBoolean();
        this.fixHopperHitBox = config.get("fixes", "fixHopperHitBox", true, "Fix vanilla hopper hit box").getBoolean();
        this.installAnchorAlarm = config.get("tweaks", "installAnchorAlarm", true, "Wake up passive & personal anchors on player login").getBoolean();
        this.preventPickupLoot = config.get("tweaks", "preventPickupLoot", true, "Prevent monsters from picking up loot.").getBoolean();
        this.dropPickedLootOnDespawn = config.get("tweaks", "dropPickedLootOnDespawn", true, "Drop picked loot on entity despawn").getBoolean();
        this.hideIc2ReactorSlots = config.get("tweaks", "hideIc2ReactorSlots", true, "Prevent IC2's reactor's coolant slots from being accessed by automations if not a fluid reactor").getBoolean();
        this.speedupChunkCoordinatesHashCode = config.get("speedups", "speedupChunkCoordinatesHashCode", true, "Speedup ChunkCoordinates hashCode").getBoolean();
        this.pollutionAsm = config.get("asm", "pollutionAsm", true, "Enable pollution rendering ASM").getBoolean();
        this.cofhWorldTransformer = config.get("asm", "cofhWorldTransformer", true, "Enable Glease's ASM patch to disable unused CoFH tileentity cache").getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postInitClient() {
        if (config == null) {
            System.err.println("Didnt load HODGE");
            config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        standardBlocks.updateClassList(config.get("pollutionrecolor", "renderStandardBlock", new String[]{"net.minecraft.block.BlockGrass:GRASS", "net.minecraft.block.BlockLeavesBase:LEAVES", "biomesoplenty.common.blocks.BlockOriginGrass:GRASS", "biomesoplenty.common.blocks.BlockLongGrass:GRASS", "biomesoplenty.common.blocks.BlockNewGrass:GRASS", "tconstruct.blocks.slime.SlimeGrass:GRASS", "thaumcraft.common.blocks.BlockMagicalLeaves:LEAVES"}).getStringList());
        liquidBlocks.updateClassList(config.get("pollutionrecolor", "renderBlockLiquid", new String[]{"net.minecraft.block.BlockLiquid:LIQUID"}).getStringList());
        doublePlants.updateClassList(config.get("pollutionrecolor", "renderBlockDoublePlant", new String[]{"net.minecraft.block.BlockDoublePlant:FLOWER"}).getStringList());
        crossedSquares.updateClassList(config.get("pollutionrecolor", "renderCrossedSquares", new String[]{"net.minecraft.block.BlockTallGrass:FLOWER", "net.minecraft.block.BlockFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower2:FLOWER", "biomesoplenty.common.blocks.BlockBOPFoliage:FLOWER"}).getStringList());
        blockVine.updateClassList(config.get("pollutionrecolor", "renderblockVine", new String[]{"net.minecraft.block.BlockVine:FLOWER"}).getStringList());
        config.getCategory("pollutionrecolor").setComment("Blocks that should be colored by pollution. \n\tGrouped by the render type. \n\tFormat: [BlockClass]:[colortype] \n\tValid types: GRASS, LEAVES, FLOWER, LIQUID \n\tAdd [-] first to blacklist.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        standardBlocks = new BlockMatcher();
        liquidBlocks = new BlockMatcher();
        doublePlants = new BlockMatcher();
        crossedSquares = new BlockMatcher();
        blockVine = new BlockMatcher();
    }
}

