/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.util;

import com.google.common.collect.Maps;
import com.mitchej123.hodgepodge.asm.HodgePodgeASMLoader;
import com.mitchej123.hodgepodge.asm.util.AbstractMethodTransformer;
import com.mitchej123.hodgepodge.asm.util.MethodRef;
import com.mitchej123.hodgepodge.asm.util.Namespace;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class AbstractClassTransformer
implements IClassTransformer {
    protected final Logger log = LogManager.getLogger((String)this.getClass().getSimpleName());
    protected Namespace environment = Namespace.MCP;
    protected Map<MethodRef, AbstractMethodTransformer> methodTransformers = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!transformedName.equals(name)) {
            this.environment = HodgePodgeASMLoader.getSortingIndex() >= 1001 ? Namespace.SRG : Namespace.OBF;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean hasTransformed = false;
        for (Map.Entry<MethodRef, AbstractMethodTransformer> entry : this.methodTransformers.entrySet()) {
            if (!transformedName.equals(entry.getKey().parent.getName(Namespace.MCP))) continue;
            for (MethodNode methodNode : classNode.methods) {
                if (!(entry.getKey().getName(Namespace.MCP).equals(methodNode.name) && entry.getKey().getAsmDescriptor(Namespace.MCP).equals(methodNode.desc) || entry.getKey().getName(Namespace.SRG).equals(methodNode.name) && entry.getKey().getAsmDescriptor(Namespace.SRG).equals(methodNode.desc)) && (!entry.getKey().getName(Namespace.OBF).equals(methodNode.name) || !entry.getKey().getAsmDescriptor(Namespace.OBF).equals(methodNode.desc))) continue;
                AbstractMethodTransformer transformer = entry.getValue();
                hasTransformed = true;
                AbstractMethodTransformer abstractMethodTransformer = transformer;
                synchronized (abstractMethodTransformer) {
                    transformer.currentClass = classNode;
                    transformer.currentMethod = methodNode;
                    transformer.environment = this.environment;
                    try {
                        transformer.transform();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ClassWriter writer = new ClassWriter(2);
        if (hasTransformed) {
            classNode.accept((ClassVisitor)writer);
        }
        return !hasTransformed ? basicClass : writer.toByteArray();
    }
}

