/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

public class BlockMeta
implements ImmutableBlockMeta {
    @Nonnull
    private Block block;
    private int meta;

    public BlockMeta(@Nonnull Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public BlockMeta(@Nonnull Block block) {
        this(block, 0);
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getBlockMeta() {
        return this.meta;
    }

    public BlockMeta setBlock(@Nonnull Block block) {
        this.block = Objects.requireNonNull(block);
        return this;
    }

    public BlockMeta setBlockMeta(int meta) {
        this.meta = meta;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.block.hashCode();
        result = 31 * result + this.meta;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockMeta other = (BlockMeta)obj;
        if (!this.block.equals(other.block)) {
            return false;
        }
        return this.meta == other.meta;
    }

    public String toString() {
        return "BlockMeta [block=" + this.block + ", meta=" + this.meta + "]";
    }
}

