/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.FastImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.data.ItemId;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ItemStackPredicate
extends Predicate<ImmutableItemStack> {
    public static final ItemStackPredicate ALL = stack -> true;

    @Override
    public boolean test(ImmutableItemStack var1);

    @Override
    default public boolean test(ItemStack stack) {
        return this.test(new FastImmutableItemStack(stack));
    }

    @Nullable
    default public Collection<ItemStack> getStacks() {
        return null;
    }

    @NotNull
    default public ItemStackPredicate and(final ItemStackPredicate other) {
        Objects.requireNonNull(other);
        return new ItemStackPredicate(){
            private List<ItemStack> stacks;

            @Override
            public boolean test(ImmutableItemStack t) {
                return ItemStackPredicate.this.test(t) && other.test(t);
            }

            @Override
            @Nullable
            public Collection<ItemStack> getStacks() {
                Collection<ItemStack> a = ItemStackPredicate.this.getStacks();
                Collection<ItemStack> b = other.getStacks();
                if (a == null && b == null) {
                    return null;
                }
                if (a == null || b == null) {
                    return a == null ? b : a;
                }
                if (this.stacks != null) {
                    return this.stacks;
                }
                this.stacks = new ArrayList<ItemStack>(a.size() + b.size());
                this.stacks.addAll(a);
                this.stacks.addAll(b);
                return this.stacks;
            }
        };
    }

    @NotNull
    default public ItemStackPredicate negate() {
        return t -> !this.test(t);
    }

    @NotNull
    default public ItemStackPredicate or(final ItemStackPredicate other) {
        Objects.requireNonNull(other);
        return new ItemStackPredicate(){

            @Override
            public boolean test(ImmutableItemStack t) {
                return ItemStackPredicate.this.test(t) || other.test(t);
            }

            @Override
            @Nullable
            public Collection<ItemStack> getStacks() {
                Collection<ItemStack> a = ItemStackPredicate.this.getStacks();
                Collection<ItemStack> b = other.getStacks();
                if (a == null && b == null) {
                    return null;
                }
                if (a == null || b == null) {
                    return a == null ? b : a;
                }
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(a.size() + b.size());
                stacks.addAll(a);
                stacks.addAll(b);
                return stacks;
            }
        };
    }

    @NotNull
    default public ItemStackPredicate withStackSize(int size) {
        return this.withStackSize(size, size);
    }

    @NotNull
    default public ItemStackPredicate withStackSize(final int min, final int max) {
        return new ItemStackPredicate(){

            @Override
            public boolean test(ImmutableItemStack stack) {
                if (stack.getStackSize() < min || stack.getStackSize() > max) {
                    return false;
                }
                return ItemStackPredicate.this.test(stack);
            }

            @Override
            @Nullable
            public Collection<ItemStack> getStacks() {
                return ItemStackPredicate.this.getStacks();
            }
        };
    }

    @NotNull
    public static ItemStackPredicate not(ItemStackPredicate target) {
        Objects.requireNonNull(target);
        return target.negate();
    }

    @NotNull
    public static ItemStackPredicate and(ItemStackPredicate a, ItemStackPredicate b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return a.and(b);
    }

    public static ItemStackPredicate matches(final ItemStack test) {
        if (test == null) {
            return ALL;
        }
        return new ItemStackPredicate(){
            private List<ItemStack> list;

            @Override
            public boolean test(ImmutableItemStack stack) {
                if (stack == null) {
                    return false;
                }
                return stack.matches(test);
            }

            public List<ItemStack> getStacks() {
                if (this.list == null) {
                    this.list = Collections.singletonList(test);
                }
                return this.list;
            }
        };
    }

    public static ItemStackPredicate oredict(String name, boolean checkNBT) {
        final List ores = OreDictionary.getOres((String)name, (boolean)false);
        final ObjectOpenCustomHashSet<Object> stacks = new ObjectOpenCustomHashSet<Object>(ores, checkNBT ? ItemId.GENERIC_ITEM_META_NBT_STRATEGY : ItemId.GENERIC_ITEM_META_STRATEGY);
        return new ItemStackPredicate(){

            @Override
            public boolean test(ImmutableItemStack stack) {
                return stacks.contains(stack);
            }

            @Override
            public Collection<ItemStack> getStacks() {
                return ores;
            }
        };
    }

    public static ItemStackPredicate stackSize(int stackSize) {
        return stack -> stack.getStackSize() == stackSize;
    }

    public static ItemStackPredicate stackSizeRange(int lower, int upper) {
        return stack -> stack.getStackSize() >= lower && stack.getStackSize() <= upper;
    }
}

