/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.font;

import com.gtnewhorizon.gtnhlib.util.font.IFontParameters;
import net.minecraft.client.gui.FontRenderer;

public class FontRendering {
    private static final char FORMATTING_CHAR = '\u00a7';

    public static boolean charInRange(char what, char fromInclusive, char toInclusive) {
        return what >= fromInclusive && what <= toInclusive;
    }

    private static boolean determineIfBold(boolean wasBold, char fmtChar) {
        char c = Character.toLowerCase(fmtChar);
        if (c == 'l') {
            return true;
        }
        boolean is09 = FontRendering.charInRange(c, '0', '9');
        boolean isAF = FontRendering.charInRange(c, 'a', 'f');
        if (c == 'r' || is09 || isAF) {
            return false;
        }
        return wasBold;
    }

    public static int getStringWidth(String str, FontRenderer fr) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        IFontParameters fontParams = (IFontParameters)fr;
        float width = 0.0f;
        boolean curBold = false;
        boolean spacingOmittedOnce = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            float charWidth = fontParams.getCharWidthFine(ch);
            if (charWidth < 0.0f && i + 1 < str.length()) {
                char fmtChar = str.charAt(++i);
                curBold = FontRendering.determineIfBold(curBold, fmtChar);
                charWidth = 0.0f;
            }
            width += charWidth;
            if (charWidth > 0.0f) {
                if (spacingOmittedOnce) {
                    width += fontParams.getGlyphSpacing();
                } else {
                    spacingOmittedOnce = true;
                }
            }
            if (!curBold || !(charWidth > 0.0f)) continue;
            width += fontParams.getShadowOffset();
        }
        return (int)Math.ceil(width);
    }

    public static int sizeStringToWidth(String str, int wrapWidth, FontRenderer fr) {
        int i;
        int originalStringLength = str.length();
        float width = 0.0f;
        int lastBreakSpot = -1;
        boolean curBold = false;
        boolean spacingOmittedOnce = false;
        IFontParameters fontParams = (IFontParameters)fr;
        for (i = 0; i < originalStringLength; ++i) {
            char currentChar = str.charAt(i);
            if (currentChar == '\n') {
                lastBreakSpot = i;
                break;
            }
            switch (currentChar) {
                case '\u00a7': {
                    if (i + 1 >= originalStringLength) break;
                    char fmtChar = str.charAt(++i);
                    curBold = FontRendering.determineIfBold(curBold, fmtChar);
                    break;
                }
                case ' ': {
                    lastBreakSpot = i;
                }
                default: {
                    width += fontParams.getCharWidthFine(currentChar);
                    if (spacingOmittedOnce) {
                        width += fontParams.getGlyphSpacing();
                    } else {
                        spacingOmittedOnce = true;
                    }
                    if (!curBold) break;
                    width += fontParams.getShadowOffset();
                }
            }
            if (Math.ceil(width) > (double)wrapWidth) break;
        }
        if (i != originalStringLength && lastBreakSpot != -1 && lastBreakSpot < i) {
            return lastBreakSpot;
        }
        return i;
    }

    public static String trimStringToWidth(String str, int trimWidth, boolean reverse, FontRenderer fr) {
        StringBuilder stringbuilder = new StringBuilder();
        float width = 0.0f;
        int startOrEnd = reverse ? str.length() - 1 : 0;
        int increment = reverse ? -1 : 1;
        boolean curBold = false;
        boolean spacingOmittedOnce = false;
        boolean parsingFormatCode = false;
        IFontParameters fontParams = (IFontParameters)fr;
        for (int i = startOrEnd; i >= 0 && i < str.length() && width < (float)trimWidth; i += increment) {
            char ch = str.charAt(i);
            float charWidth = fontParams.getCharWidthFine(ch);
            if (parsingFormatCode) {
                parsingFormatCode = false;
                curBold = FontRendering.determineIfBold(curBold, ch);
            } else if (charWidth < 0.0f) {
                parsingFormatCode = true;
            } else {
                width += charWidth;
                if (spacingOmittedOnce) {
                    width += fontParams.getGlyphSpacing();
                } else {
                    spacingOmittedOnce = true;
                }
                if (curBold) {
                    width += fontParams.getShadowOffset();
                }
            }
            if (Math.ceil(width) > (double)trimWidth) break;
            if (reverse) {
                stringbuilder.insert(0, ch);
                continue;
            }
            stringbuilder.append(ch);
        }
        return stringbuilder.toString();
    }
}

