/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import com.gtnewhorizon.gtnhlib.util.data.IMod;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import com.gtnewhorizon.gtnhlib.util.data.ItemMeta;
import com.gtnewhorizon.gtnhlib.util.data.ItemStackSupplier;
import com.gtnewhorizon.gtnhlib.util.data.ItemSupplier;
import com.gtnewhorizon.gtnhlib.util.data.Lazy;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LazyItem
extends Lazy<ImmutableItemMeta>
implements ImmutableItemMeta {
    private final IMod mod;

    public LazyItem(IMod mod, String itemName, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            Item item = GameRegistry.findItem((String)mod.getID(), (String)itemName);
            Objects.requireNonNull(item, "could not find item: " + mod.getID() + ":" + itemName);
            return new ItemMeta(item, meta);
        });
        this.mod = mod;
    }

    public LazyItem(IMod mod, String itemName) {
        this(mod, itemName, 0);
    }

    public LazyItem(IMod mod, ItemStackSupplier getter) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            ItemStack stack = (ItemStack)getter.get();
            if (stack == null || stack.func_77973_b() == null) {
                return null;
            }
            return new ItemMeta(stack.func_77973_b(), Items.field_151008_G.getDamage(stack));
        });
        this.mod = mod;
    }

    public LazyItem(IMod mod, ItemSupplier getter, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            Item item = (Item)getter.get();
            if (item == null) {
                return null;
            }
            return new ItemMeta(item, meta);
        });
        this.mod = mod;
    }

    public LazyItem(IMod mod, ItemSupplier getter) {
        this(mod, getter, 0);
    }

    public boolean isLoaded() {
        return this.mod.isModLoaded();
    }

    public IMod getMod() {
        return this.mod;
    }

    @Override
    @Nonnull
    public Item getItem() {
        return ((ImmutableItemMeta)this.get()).getItem();
    }

    @Override
    public int getItemMeta() {
        return ((ImmutableItemMeta)this.get()).getItemMeta();
    }

    @Override
    public boolean matches(Item other, int metaOther) {
        if (!this.isLoaded()) {
            return false;
        }
        ImmutableItemMeta bm = (ImmutableItemMeta)this.get();
        if (bm == null) {
            return false;
        }
        return bm.getItem() == other && (bm.getItemMeta() == metaOther || bm.getItemMeta() == Short.MAX_VALUE || metaOther == Short.MAX_VALUE);
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.matches(stack.func_77973_b(), Items.field_151008_G.getDamage(stack));
    }

    @Override
    public ItemStack toStack(int amount) {
        if (!this.isLoaded()) {
            return null;
        }
        ImmutableItemMeta bm = (ImmutableItemMeta)this.get();
        if (bm == null) {
            return null;
        }
        return bm.toStack(amount);
    }
}

