/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.IConfigElementProxy;
import cpw.mods.fml.client.config.IConfigElement;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"GTNHLibConfig");
    private static final Map<String, Configuration> configs = new HashMap<String, Configuration>();
    private static final Map<Configuration, Set<Class<?>>> configToClassMap = new HashMap();
    private static final ConfigurationManager instance = new ConfigurationManager();
    private static boolean initialized = false;
    private static Path configDir;

    public static void registerConfig(Class<?> configClass) throws ConfigException {
        ConfigurationManager.init();
        Config cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
        String category = Optional.of(cfg.category().trim()).map(cat -> cat.length() == 0 ? null : cat).orElseThrow(() -> new ConfigException("Config class " + configClass.getName() + " has an empty category!"));
        Configuration rawConfig = configs.computeIfAbsent(cfg.modid(), ignored -> {
            Path newConfigDir = configDir;
            if (!cfg.configSubDirectory().trim().isEmpty()) {
                newConfigDir = newConfigDir.resolve(cfg.configSubDirectory().trim());
            }
            String fileName = cfg.filename().trim().isEmpty() ? cfg.modid() : cfg.filename().trim();
            Configuration c = new Configuration(newConfigDir.resolve(fileName + ".cfg").toFile());
            c.load();
            return c;
        });
        configToClassMap.computeIfAbsent(rawConfig, ignored -> new HashSet()).add(configClass);
        try {
            ConfigurationManager.processConfigInternal(configClass, category, rawConfig);
            rawConfig.save();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigException(e);
        }
    }

    private static void processConfigInternal(Class<?> configClass, String category, Configuration rawConfig) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException, ConfigException {
        ConfigCategory cat = rawConfig.getCategory(category);
        for (Field field : configClass.getDeclaredFields()) {
            String[] defaultValue;
            if (field.getAnnotation(Config.Ignore.class) != null) continue;
            field.setAccessible(true);
            String comment = Optional.ofNullable(field.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
            String name = Optional.ofNullable(field.getAnnotation(Config.Name.class)).map(Config.Name::value).orElse(field.getName());
            String langKey = Optional.ofNullable(field.getAnnotation(Config.LangKey.class)).map(Config.LangKey::value).orElse(name);
            Class<?> fieldClass = field.getType();
            boolean boxed = false;
            boxed = fieldClass.equals(Boolean.class);
            if (boxed || fieldClass.equals(Boolean.TYPE)) {
                defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultBoolean.class)).map(Config.DefaultBoolean::value).orElse(boxed ? ((Boolean)field.get(null)).booleanValue() : field.getBoolean(null));
                field.setBoolean(null, rawConfig.getBoolean(name, category, defaultValue.booleanValue(), comment, langKey));
            } else {
                Number defaultValue2;
                Number max;
                Number min;
                Optional<Annotation> range;
                boxed = fieldClass.equals(Integer.class);
                if (boxed || fieldClass.equals(Integer.TYPE)) {
                    range = Optional.ofNullable(field.getAnnotation(Config.RangeInt.class));
                    min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
                    max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
                    defaultValue2 = Optional.ofNullable(field.getAnnotation(Config.DefaultInt.class)).map(Config.DefaultInt::value).orElse(boxed ? ((Integer)field.get(null)).intValue() : field.getInt(null));
                    field.setInt(null, rawConfig.getInt(name, category, ((Integer)defaultValue2).intValue(), ((Integer)min).intValue(), ((Integer)max).intValue(), comment, langKey));
                } else {
                    boxed = fieldClass.equals(Float.class);
                    if (boxed || fieldClass.equals(Float.TYPE)) {
                        range = Optional.ofNullable(field.getAnnotation(Config.RangeFloat.class));
                        min = range.map(Config.RangeFloat::min).orElse(Float.valueOf(Float.MIN_VALUE));
                        max = range.map(Config.RangeFloat::max).orElse(Float.valueOf(Float.MAX_VALUE));
                        defaultValue2 = Optional.ofNullable(field.getAnnotation(Config.DefaultFloat.class)).map(Config.DefaultFloat::value).orElse(Float.valueOf(boxed ? ((Float)field.get(null)).floatValue() : field.getFloat(null)));
                        field.setFloat(null, rawConfig.getFloat(name, category, ((Float)defaultValue2).floatValue(), ((Float)min).floatValue(), ((Float)max).floatValue(), comment, langKey));
                    } else if (fieldClass.equals(String.class)) {
                        defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultString.class)).map(Config.DefaultString::value).orElse((String)field.get(null));
                        Pattern pattern = Optional.ofNullable(field.getAnnotation(Config.Pattern.class)).map(Config.Pattern::value).map(Pattern::compile).orElse(null);
                        field.set(null, rawConfig.getString(name, category, (String)defaultValue, comment, langKey, pattern));
                    } else if (fieldClass.isEnum()) {
                        List enumValues = Arrays.stream((Object[])fieldClass.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0])).map(obj -> (Enum)obj).collect(Collectors.toList());
                        Enum defaultValue3 = (Enum)Optional.ofNullable(field.getAnnotation(Config.DefaultEnum.class)).map(Config.DefaultEnum::value).map(defName -> ConfigurationManager.extractField(fieldClass, defName)).map(ConfigurationManager::extractValue).orElse(field.get(null));
                        Object[] possibleValues = (String[])enumValues.stream().map(Enum::name).toArray(String[]::new);
                        String value = rawConfig.getString(name, category, defaultValue3.name(), comment + "\nPossible values: " + Arrays.toString(possibleValues) + "\n", (String[])possibleValues, langKey);
                        try {
                            if (!Arrays.asList(possibleValues).contains(value)) {
                                throw new NoSuchFieldException();
                            }
                            Field enumField = fieldClass.getDeclaredField(value);
                            if (!enumField.isEnumConstant()) {
                                throw new NoSuchFieldException();
                            }
                            field.set(null, enumField.get(null));
                        }
                        catch (NoSuchFieldException e) {
                            LOGGER.warn("Invalid value " + value + " for enum configuration field " + field.getName() + " of type " + fieldClass.getName() + " in config class " + configClass.getName() + "! Using default value of " + defaultValue3 + "!");
                            field.set(null, defaultValue3);
                        }
                    } else if (fieldClass.isArray() && fieldClass.getComponentType().equals(String.class)) {
                        defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultStringList.class)).map(Config.DefaultStringList::value).orElse((String[])field.get(null));
                        String[] value = rawConfig.getStringList(name, category, defaultValue, comment, null, langKey);
                        field.set(null, value);
                    } else {
                        throw new ConfigException("Illegal config field: " + field.getName() + " in " + configClass.getName() + ": Unsupported type " + fieldClass.getName() + "! Did you forget an @Ignore annotation?");
                    }
                }
            }
            if (field.isAnnotationPresent(Config.RequiresMcRestart.class)) {
                cat.setRequiresMcRestart(true);
            }
            if (!field.isAnnotationPresent(Config.RequiresWorldRestart.class)) continue;
            cat.setRequiresWorldRestart(true);
        }
    }

    private static Field extractField(Class<?> clazz, String field) {
        return clazz.getDeclaredField(field);
    }

    private static Object extractValue(Field field) {
        return field.get(null);
    }

    public static List<IConfigElement> getConfigElements(Class<?> configClass) throws ConfigException {
        ConfigurationManager.init();
        Config cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
        Configuration rawConfig = Optional.ofNullable(configs.get(cfg.modid())).map(conf -> Optional.ofNullable(configToClassMap.get(conf)).map(l -> l.contains(configClass)).orElse(false) != false ? conf : null).orElseThrow(() -> new ConfigException("Tried to get config elements for non-registered config class!"));
        String category = cfg.category();
        List elements = new ConfigElement(rawConfig.getCategory(category)).getChildElements();
        return elements.stream().map(element -> new IConfigElementProxy(element, () -> {
            try {
                ConfigurationManager.processConfigInternal(configClass, category, rawConfig);
                rawConfig.save();
            }
            catch (ConfigException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        })).collect(Collectors.toList());
    }

    public static List<IConfigElement> getConfigElementsMulti(Class<?> ... configClasses) throws ConfigException {
        switch (configClasses.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return ConfigurationManager.getConfigElements(configClasses[0]);
            }
        }
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        for (Class<?> configClass : configClasses) {
            result.addAll(ConfigurationManager.getConfigElements(configClass));
        }
        return result;
    }

    private static File minecraftHome() {
        return Launch.minecraftHome != null ? Launch.minecraftHome : new File(".");
    }

    private static void init() {
        if (initialized) {
            return;
        }
        configDir = ConfigurationManager.minecraftHome().toPath().resolve("config");
        initialized = true;
    }

    private ConfigurationManager() {
    }
}

