/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile;

import com.gtnewhorizons.gtnhintergalactic.config.Config;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.List;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntitySpaceElevatorCable
extends TileEntityAdvanced {
    private static final float VERTICAL_SPEED = 1.0f;
    private static final float ROTATION_SPEED = 0.5f;
    private static final float MAX_HEIGHT = 250.0f;
    private static final int STANDBY_TIME_TICKS = 200;
    private static final int ACCELERATION_DISTANCE = 30;
    private static final float ACCELERATION_FACTOR = 0.033333335f;
    private static final String ELEVATOR_CLIMBER_NBT_TAG = "SE:";
    private static final String HEIGHT_NBT_TAG = "SE:height";
    private static final String VERTICAL_DIRECTION_NBT_TAG = "SE:verticalDirection";
    private static final String VERTICAL_MOVEMENT_NBT_TAG = "SE:verticalMovement";
    private static final String ROTATION_NBT_TAG = "SE:rotation";
    private static final String ROTATION_DIRECTION_NBT_TAG = "SE:rotationDirection";
    private static final String ROTATION_MOVEMENT_NBT_TAG = "SE:rotationMovement";
    private static final String WAIT_TIME_NBT_TAG = "SE:waitTime";
    private static final String SHOULD_RENDER_NBT_TAG = "SE:shouldRender";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRender = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float currentHeight = 250.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float currentRotation = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean isMoving = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean isRotating = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean isMovingDirectionUp = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean isRotationDirectionClockwise = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int currentWaitTime = 0;
    public ClimberAnimation animation = ClimberAnimation.NO_ANIMATION;
    private boolean shouldRenderConfirmation = false;

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 20.0 * super.func_145833_n();
    }

    public float getClimberHeight() {
        return this.currentHeight;
    }

    public float getClimberRotation() {
        return this.currentRotation;
    }

    public void setShouldRender(boolean shouldRender) {
        if (!this.shouldRender && shouldRender) {
            this.startAnimation(ClimberAnimation.FORMATION_ANIMATION);
        } else if (this.shouldRender && !shouldRender) {
            this.currentRotation = 0.0f;
            this.currentHeight = 250.0f;
        }
        this.shouldRender = shouldRender;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public void func_145845_h() {
        if (!Config.isCableRenderingEnabled) {
            return;
        }
        super.func_145845_h();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.shouldRender != this.shouldRenderConfirmation) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.shouldRenderConfirmation = this.shouldRender;
        }
        switch (this.animation) {
            case DELIVER_ANIMATION: {
                this.animateDelivery();
                break;
            }
            case FORMATION_ANIMATION: {
                this.animateFormation();
                break;
            }
        }
    }

    public double getPacketRange() {
        return 128.0;
    }

    public int getPacketCooldown() {
        return 20;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            networkedList.add(this.animation.ordinal());
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            int animationOrdinal = dataStream.readInt();
            this.animation = animationOrdinal < ClimberAnimation.values().length ? ClimberAnimation.values()[animationOrdinal] : ClimberAnimation.NO_ANIMATION;
        }
    }

    public void startAnimation(ClimberAnimation animation) {
        this.animation = animation;
        this.isMoving = true;
        this.isRotating = true;
    }

    public ClimberAnimation getAnimation() {
        return this.animation;
    }

    public void stopAnimation() {
        this.animation = ClimberAnimation.NO_ANIMATION;
        this.isRotating = false;
        this.isMoving = false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a(HEIGHT_NBT_TAG, this.currentHeight);
        compound.func_74776_a(ROTATION_NBT_TAG, this.currentRotation);
        compound.func_74757_a(VERTICAL_DIRECTION_NBT_TAG, this.isMovingDirectionUp);
        compound.func_74757_a(ROTATION_DIRECTION_NBT_TAG, this.isRotationDirectionClockwise);
        compound.func_74757_a(ROTATION_MOVEMENT_NBT_TAG, this.isRotating);
        compound.func_74757_a(VERTICAL_MOVEMENT_NBT_TAG, this.isMoving);
        compound.func_74768_a(WAIT_TIME_NBT_TAG, this.currentWaitTime);
        compound.func_74757_a(SHOULD_RENDER_NBT_TAG, this.shouldRender);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentHeight = compound.func_74760_g(HEIGHT_NBT_TAG);
        this.currentRotation = compound.func_74760_g(ROTATION_NBT_TAG);
        this.isMoving = compound.func_74767_n(VERTICAL_MOVEMENT_NBT_TAG);
        this.isRotating = compound.func_74767_n(ROTATION_MOVEMENT_NBT_TAG);
        this.isMovingDirectionUp = compound.func_74767_n(VERTICAL_DIRECTION_NBT_TAG);
        this.isRotationDirectionClockwise = compound.func_74767_n(ROTATION_DIRECTION_NBT_TAG);
        this.currentHeight = compound.func_74762_e(WAIT_TIME_NBT_TAG);
        this.shouldRender = compound.func_74767_n(SHOULD_RENDER_NBT_TAG);
    }

    private void animateFormation() {
        if (this.isRotating) {
            this.currentRotation = this.isRotationDirectionClockwise ? (this.currentRotation + 0.5f) % 360.0f : (this.currentRotation - 0.5f) % 360.0f;
        }
        if (this.isMoving) {
            if (this.currentHeight <= 0.0f) {
                this.isMovingDirectionUp = true;
                this.stopAnimation();
            } else {
                this.currentHeight = this.currentHeight < 30.0f ? (this.currentHeight -= 0.033333335f * Math.max(this.currentHeight, 1.0f)) : (this.currentHeight -= 1.0f);
            }
        }
    }

    private void animateDelivery() {
        if (this.isRotating) {
            this.currentRotation = this.isRotationDirectionClockwise ? (this.currentRotation + 0.5f) % 360.0f : (this.currentRotation - 0.5f) % 360.0f;
        }
        if (this.isMoving && this.currentWaitTime <= 0) {
            if (this.isMovingDirectionUp) {
                if (this.currentHeight >= 250.0f) {
                    this.isMovingDirectionUp = false;
                    this.currentWaitTime = 200;
                } else {
                    this.currentHeight = this.currentHeight <= 30.0f ? (this.currentHeight += 0.033333335f * Math.max(this.currentHeight, 1.0f)) : (this.currentHeight >= 220.0f ? (this.currentHeight += 0.033333335f * Math.max(250.0f - this.currentHeight, 1.0f)) : (this.currentHeight += 1.0f));
                }
            } else if (this.currentHeight <= 0.0f) {
                this.isMovingDirectionUp = true;
                this.stopAnimation();
            } else {
                this.currentHeight = this.currentHeight < 30.0f ? (this.currentHeight -= 0.033333335f * Math.max(this.currentHeight, 1.0f)) : (this.currentHeight >= 220.0f ? (this.currentHeight -= 0.033333335f * Math.max(250.0f - this.currentHeight, 1.0f)) : (this.currentHeight -= 1.0f));
            }
        } else if (this.currentWaitTime > 0) {
            --this.currentWaitTime;
        }
    }

    public static enum ClimberAnimation {
        NO_ANIMATION,
        DELIVER_ANIMATION,
        FORMATION_ANIMATION;

    }
}

