/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.gtnewhorizons.gtnhintergalactic.recipe.SpacePumpingRecipes;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntityModulePump
extends TileEntityModuleBase {
    public static final int ENERGY_CONSUMPTION = (int)GT_Values.VP[9];
    Parameters.Group.ParameterIn[] parallelSettings;
    Parameters.Group.ParameterIn[] gasTypeSettings;
    Parameters.Group.ParameterIn[] planetTypeSettings;
    private static final INameFunction<TileEntityModulePump> PLANET_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.0") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> PLANET_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModulePump> GAS_TYPE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.1") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> GAS_TYPE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)100.0, (double)100.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModulePump> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.2") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TileEntityModulePump> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getParallels(), (double[])new double[0]);

    public TileEntityModulePump(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
    }

    public TileEntityModulePump(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        if (GT_Values.V[this.tTier] * (long)this.getParallelRecipes() * (long)this.getParallels() > this.getEUVar()) {
            return false;
        }
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        int usedEUt = 0;
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            FluidStack fluid = SpacePumpingRecipes.RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[i].get()), (Object)((int)this.gasTypeSettings[i].get())));
            if (fluid == null) continue;
            fluid = fluid.copy();
            fluid.amount *= Math.min((int)this.parallelSettings[i].get(), this.getParallels());
            usedEUt += ENERGY_CONSUMPTION * Math.min((int)this.parallelSettings[i].get(), this.getParallels());
            outputs.add(fluid);
        }
        this.lEUt = -usedEUt;
        this.mOutputFluids = outputs.toArray(new FluidStack[0]);
        this.eAmpereFlow = 1L;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return outputs.size() > 0;
    }

    protected abstract int getParallels();

    protected abstract int getParallelRecipes();

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        int parallels = this.getParallelRecipes();
        this.planetTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.gasTypeSettings = new Parameters.Group.ParameterIn[parallels];
        this.parallelSettings = new Parameters.Group.ParameterIn[parallels];
        for (int i = 0; i < this.getParallelRecipes(); ++i) {
            this.planetTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(0, 1.0, PLANET_TYPE_SETTING_NAME, PLANET_TYPE_STATUS);
            this.gasTypeSettings[i] = this.parametrization.getGroup(i * 2, false).makeInParameter(1, 1.0, GAS_TYPE_SETTING_NAME, GAS_TYPE_STATUS);
            this.parallelSettings[i] = this.parametrization.getGroup(i * 2 + 1, false).makeInParameter(0, (double)this.getParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        }
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.config")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        int i = 0;
        while (i < this.getParallelRecipes()) {
            int fluidIndex = i++;
            ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
                String fluidName = this.getPumpedFluid(fluidIndex);
                if (fluidName != null) {
                    return " - " + fluidName;
                }
                return "";
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getPumpedFluid(fluidIndex) != null))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.planetTypeSettings[fluidIndex].id % 10, this.planetTypeSettings[fluidIndex].id / 10, this.planetTypeSettings[fluidIndex].get())))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.planetTypeSettings[fluidIndex].get(), val -> this.parametrization.trySetParameters(this.gasTypeSettings[fluidIndex].id % 10, this.gasTypeSettings[fluidIndex].id / 10, this.gasTypeSettings[fluidIndex].get())));
        }
    }

    private String getPumpedFluid(int index) {
        if (index < 0 || index >= this.getParallelRecipes()) {
            return null;
        }
        FluidStack fluid = SpacePumpingRecipes.RECIPES.get(Pair.of((Object)((int)this.planetTypeSettings[index].get()), (Object)((int)this.gasTypeSettings[index].get())));
        if (fluid == null) {
            return null;
        }
        return fluid.getLocalizedName();
    }

    public static class TileEntityModulePumpT2
    extends TileEntityModulePump {
        protected static final int MODULE_VOLTAGE_TIER = 10;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAX_PARALLELS = 4;
        protected static final int MAX_PARALLEL_RECIPES = 4;

        public TileEntityModulePumpT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 10, 2, 3);
        }

        public TileEntityModulePumpT2(String aName) {
            super(aName, 10, 2, 3);
        }

        @Override
        protected int getParallels() {
            return 4;
        }

        @Override
        protected int getParallelRecipes() {
            return 4;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModulePumpT2(this.mName);
        }

        @Override
        protected GT_Multiblock_Tooltip_Builder createTooltip() {
            GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t2.desc4")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
            return tt;
        }
    }

    public static class TileEntityModulePumpT1
    extends TileEntityModulePump {
        protected static final int MODULE_VOLTAGE_TIER = 9;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 2;
        protected static final int MAX_PARALLELS = 4;
        protected static final int MAX_PARALLEL_RECIPES = 1;

        public TileEntityModulePumpT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 9, 1, 2);
        }

        public TileEntityModulePumpT1(String aName) {
            super(aName, 9, 1, 2);
        }

        @Override
        protected int getParallels() {
            return 4;
        }

        @Override
        protected int getParallelRecipes() {
            return 1;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModulePumpT1(this.mName);
        }

        @Override
        protected GT_Multiblock_Tooltip_Builder createTooltip() {
            GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.t1.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.pump.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT2")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
            return tt;
        }
    }
}

