/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.gtnewhorizons.gtnhintergalactic.recipe.IG_Recipe;
import com.gtnewhorizons.gtnhintergalactic.recipe.IG_RecipeAdder;
import com.gtnewhorizons.gtnhintergalactic.spaceprojects.ProjectAsteroidOutpost;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.enums.SolarSystem;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import gregtech.common.power.BasicMachineEUPower;
import gregtech.common.power.Power;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileEntityModuleMiner
extends TileEntityModuleBase {
    protected static int BONUS_STACK_BASE_CHANCE = 5000;
    protected static int BONUS_STACK_MAX_CHANCE = 7500;
    protected static final double MIN_RECIPE_TIME_MODIFIER = 0.5;
    protected static int PLASMA_HELIUM_USAGE = 1000;
    protected static int PLASMA_BISMUTH_USAGE = 500;
    protected static int PLASMA_RADON_USAGE = 300;
    protected static final ISpaceProject ASTEROID_OUTPOST = SpaceProjectManager.getProject((String)"AsteroidOutput");
    Parameters.Group.ParameterIn distanceSetting;
    Parameters.Group.ParameterIn parallelSetting;
    Parameters.Group.ParameterIn overdriveSetting;
    Parameters.Group.ParameterIn modeSetting;
    Parameters.Group.ParameterIn rangeSetting;
    Parameters.Group.ParameterIn stepSetting;
    Parameters.Group.ParameterOut distanceDisplay;
    private static final INameFunction<TileEntityModuleMiner> DISTANCE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.0");
    private static final IStatusFunction<TileEntityModuleMiner> DISTANCE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)200.0, (double)300.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.1");
    private static final IStatusFunction<TileEntityModuleMiner> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getParallels(), (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> OVERDRIVE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.2");
    private static final IStatusFunction<TileEntityModuleMiner> OVERDRIVE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)1.5, (double)2.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> MODE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4");
    private static final IStatusFunction<TileEntityModuleMiner> MODE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)1.1, (double)1.1, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> RANGE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.5");
    private static final IStatusFunction<TileEntityModuleMiner> RANGE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)50.0, (double)150.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> STEP_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.6");
    private static final IStatusFunction<TileEntityModuleMiner> STEP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)10.0, (double)20.0, (double[])new double[0]);
    protected final Power power;
    protected ProjectAsteroidOutpost asteroidOutpost;

    public TileEntityModuleMiner(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
        this.power = new MinerPower((byte)tTier, tModuleTier);
    }

    public TileEntityModuleMiner(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
        this.power = new MinerPower((byte)tTier, tModuleTier);
    }

    public Power getPower() {
        return this.power;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        if (GT_Values.V[this.tTier] * (long)this.parallelSetting.get() > this.getEUVar()) {
            return false;
        }
        this.lEUt = 0L;
        this.eAmpereFlow = 0L;
        this.eRequiredData = 0L;
        this.mEfficiencyIncrease = 0;
        this.mPollution = 0;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        if (this.getStoredFluids().size() <= 0) {
            return false;
        }
        for (FluidStack fluidStack : this.getStoredFluids()) {
            int availablePlasmaTier = this.getTierFromPlasma(fluidStack);
            if (availablePlasmaTier <= 0 || !this.process(this.getStoredInputs().toArray(new ItemStack[0]), this.getStoredFluids().toArray(new FluidStack[0]), availablePlasmaTier, fluidStack, this.getParallels(fluidStack, this.getPlasmaUsageFromTier(availablePlasmaTier)))) continue;
            this.cycleDistance();
            return true;
        }
        this.cycleDistance();
        return false;
    }

    public boolean process(ItemStack[] inputs, FluidStack[] fluidInputs, int availablePlasmaTier, FluidStack plasma, int maxParallels) {
        int recipeIndex;
        if (inputs == null && fluidInputs == null || plasma == null) {
            return false;
        }
        if (availablePlasmaTier <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        List<IG_Recipe.IG_SpaceMiningRecipe> recipes = IG_RecipeAdder.instance.sSpaceMiningRecipes.findRecipes((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), null, false, false, tVoltage, fluidInputs, null, (int)this.distanceDisplay.get(), this.tModuleTier, inputs);
        if (recipes == null || recipes.size() <= 0) {
            return false;
        }
        float compModifier = 1.0f;
        float plasmaModifier = 1.0f;
        if (this.asteroidOutpost != null) {
            compModifier -= this.asteroidOutpost.getComputationDiscount();
            plasmaModifier -= this.asteroidOutpost.getPlasmaDiscount();
        }
        int totalWeight = recipes.stream().mapToInt(IG_Recipe.IG_SpaceMiningRecipe::getRecipeWeight).sum();
        double r = Math.random() * (double)totalWeight;
        for (recipeIndex = 0; recipeIndex < recipes.size() - 1 && !((r -= (double)recipes.get(recipeIndex).getRecipeWeight()) <= 0.0); ++recipeIndex) {
        }
        IG_Recipe.IG_SpaceMiningRecipe tRecipe = recipes.get(recipeIndex);
        if (tRecipe == null || (long)tRecipe.mEUt > tVoltage) {
            return false;
        }
        if ((maxParallels = (int)Math.min((float)maxParallels, (float)this.getAvailableData_EM() / ((float)tRecipe.computation * compModifier))) <= 0) {
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setMaxParallel(maxParallels).setRecipe((GT_Recipe)tRecipe).setFluidInputs(fluidInputs).setItemInputs(inputs).setAvailableEUt(GT_Values.V[this.tTier]).enableConsumption().build();
        int parallels = helper.getCurrentParallel();
        if (parallels <= 0) {
            return false;
        }
        ItemStack[] outputs = new ItemStack[tRecipe.maxSize * parallels];
        int totalChance = Arrays.stream(tRecipe.mChances).sum();
        try {
            block3: for (int i = 0; i < tRecipe.maxSize * parallels; ++i) {
                int bonusStackChance = 0;
                if (i >= tRecipe.minSize * parallels) {
                    bonusStackChance = this.getBonusStackChance(availablePlasmaTier);
                }
                if (i >= tRecipe.minSize * parallels && bonusStackChance <= XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                int random = XSTR.XSTR_INSTANCE.nextInt(totalChance);
                int currentChance = 0;
                for (int j = 0; j < tRecipe.mChances.length; ++j) {
                    if (random > (currentChance += tRecipe.mChances[j])) continue;
                    outputs[i] = tRecipe.mOutputs[j].func_77946_l();
                    continue block3;
                }
            }
        }
        catch (Exception ignored) {
            return false;
        }
        plasma.amount = (int)Math.max(0.0, Math.ceil((float)plasma.amount - (float)(parallels * this.getPlasmaUsageFromTier(availablePlasmaTier)) * plasmaModifier));
        this.mOutputItems = outputs;
        this.lEUt = (long)(-tRecipe.mEUt) * (long)parallels;
        this.eAmpereFlow = 1L;
        this.eRequiredData = (int)Math.ceil((float)(tRecipe.computation * parallels) * compModifier);
        this.mMaxProgresstime = this.getRecipeTime(tRecipe.mDuration, availablePlasmaTier);
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    protected int getTierFromPlasma(FluidStack fluidStack) {
        if (fluidStack == null) {
            return 0;
        }
        if (fluidStack.isFluidEqual(Materials.Radon.getPlasma(1L)) && fluidStack.amount >= PLASMA_RADON_USAGE) {
            return 3;
        }
        if (fluidStack.isFluidEqual(Materials.Bismuth.getPlasma(1L)) && fluidStack.amount >= PLASMA_BISMUTH_USAGE) {
            return 2;
        }
        if (fluidStack.isFluidEqual(Materials.Helium.getPlasma(1L)) && fluidStack.amount >= PLASMA_HELIUM_USAGE) {
            return 1;
        }
        return 0;
    }

    protected int getPlasmaUsageFromTier(int plasmaTier) {
        switch (plasmaTier) {
            case 1: {
                return PLASMA_HELIUM_USAGE;
            }
            case 2: {
                return PLASMA_BISMUTH_USAGE;
            }
            case 3: {
                return PLASMA_RADON_USAGE;
            }
        }
        return 0;
    }

    protected int getBonusStackChance(int plasmaTier) {
        if (plasmaTier <= 0 || plasmaTier > 3) {
            return 0;
        }
        return Math.min((int)((double)(BONUS_STACK_BASE_CHANCE + 1000 * (plasmaTier - 1)) * (2.0 - this.overdriveSetting.get())), BONUS_STACK_MAX_CHANCE);
    }

    protected abstract int getParallels();

    protected int getParallels(FluidStack plasma, int plasmaUsage) {
        if (plasma == null) {
            return 0;
        }
        float plasmaModifier = this.asteroidOutpost != null ? 1.0f - this.asteroidOutpost.getPlasmaDiscount() : 1.0f;
        return Math.min((int)this.parallelSetting.get(), (int)((float)plasma.amount / ((float)plasmaUsage * plasmaModifier)));
    }

    protected int getRecipeTime(int unboostedTime, int plasmaTier) {
        return plasmaTier > 0 ? (int)((double)unboostedTime * Math.max((1.0 - 0.1 * (double)(plasmaTier - 1)) / this.overdriveSetting.get(), 0.5)) : unboostedTime;
    }

    protected void cycleDistance() {
        if ((int)this.modeSetting.get() != 0) {
            if (this.distanceDisplay.get() + this.stepSetting.get() < this.distanceSetting.get() + this.rangeSetting.get()) {
                this.distanceDisplay.set(this.distanceDisplay.get() + this.stepSetting.get());
            } else {
                this.distanceDisplay.set(this.distanceSetting.get() - this.rangeSetting.get());
            }
        } else {
            this.distanceDisplay.set(this.distanceSetting.get());
        }
    }

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        Parameters.Group hatch_1 = this.parametrization.getGroup(1, false);
        Parameters.Group hatch_2 = this.parametrization.getGroup(2, false);
        Parameters.Group hatch_3 = this.parametrization.getGroup(3, false);
        this.distanceSetting = hatch_0.makeInParameter(0, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
        this.parallelSetting = hatch_0.makeInParameter(1, (double)this.getParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        this.overdriveSetting = hatch_1.makeInParameter(0, 1.0, OVERDRIVE_SETTING_NAME, OVERDRIVE_STATUS);
        this.modeSetting = hatch_2.makeInParameter(0, 0.0, MODE_SETTING_NAME, MODE_STATUS);
        this.rangeSetting = hatch_2.makeInParameter(1, 0.0, RANGE_SETTING_NAME, RANGE_STATUS);
        this.stepSetting = hatch_3.makeInParameter(0, 0.0, STEP_SETTING_NAME, STEP_STATUS);
        this.distanceDisplay = hatch_0.makeOutParameter(1, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4") + ": " + ((int)this.modeSetting.get() == 0 ? StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4.1") : StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4.2"))).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.modeSetting.get(), val -> this.parametrization.trySetParameters(this.modeSetting.id % 10, this.modeSetting.id / 10, this.modeSetting.get())));
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        ISpaceProject proj;
        if (!super.checkMachine_EM(aBaseMetaTileEntity, aStack)) {
            return false;
        }
        if (SpaceProjectManager.teamHasProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceProject)ASTEROID_OUTPOST) && (proj = SpaceProjectManager.getTeamProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceBody)SolarSystem.KuiperBelt, (String)"AsteroidOutpost")).isFinished()) {
            this.asteroidOutpost = (ProjectAsteroidOutpost)proj;
        }
        return true;
    }

    private static class MinerPower
    extends BasicMachineEUPower {
        public MinerPower(byte tier, int moduleTier) {
            super(tier, 1, moduleTier);
        }

        public void computePowerUsageAndDuration(int euPerTick, int duration) {
            this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
            this.recipeEuPerTick = euPerTick;
            this.recipeDuration = duration;
        }

        public String getTierString() {
            return GT_Values.TIER_COLORS[this.tier] + "MK " + this.specialValue + EnumChatFormatting.RESET;
        }
    }

    public static class TileEntityModuleMinerT3
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 10;
        protected static final int MODULE_TIER = 3;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAXIMUM_PARALLELS = 8;

        public TileEntityModuleMinerT3(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 10, 3, 3);
        }

        public TileEntityModuleMinerT3(String aName) {
            super(aName, 10, 3, 3);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT3(this.mName);
        }

        @Override
        protected int getParallels() {
            return 8;
        }

        @Override
        protected GT_Multiblock_Tooltip_Builder createTooltip() {
            GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t3.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t3.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT3")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
            return tt;
        }
    }

    public static class TileEntityModuleMinerT2
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 9;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 2;
        protected static final int MAXIMUM_PARALLELS = 4;

        public TileEntityModuleMinerT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 9, 2, 2);
        }

        public TileEntityModuleMinerT2(String aName) {
            super(aName, 9, 2, 2);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT2(this.mName);
        }

        @Override
        protected int getParallels() {
            return 4;
        }

        @Override
        protected GT_Multiblock_Tooltip_Builder createTooltip() {
            GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t2.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t2.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT2")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
            return tt;
        }
    }

    public static class TileEntityModuleMinerT1
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 8;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 1;
        protected static final int MAXIMUM_PARALLELS = 2;

        public TileEntityModuleMinerT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 8, 1, 1);
        }

        public TileEntityModuleMinerT1(String aName) {
            super(aName, 8, 1, 1);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT1(this.mName);
        }

        @Override
        protected int getParallels() {
            return 2;
        }

        @Override
        protected GT_Multiblock_Tooltip_Builder createTooltip() {
            GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t1.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t1.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT1")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
            return tt;
        }
    }
}

