/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import pers.gwyog.gtneioreplugin.plugin.item.ItemDimensionDisplay;

public class ItemDimensionDisplayRenderer
implements IItemRenderer {
    private final RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        String dimension = ItemDimensionDisplay.getDimension(stack);
        if (dimension == null) {
            return;
        }
        this.renderItem.renderItemIntoGUI(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, stack, 0, 0, false);
        String prefix = ItemDimensionDisplayRenderer.getPrefix(dimension);
        if (!prefix.isEmpty()) {
            FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
            float smallTextScale = 0.75f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            GL11.glScalef((float)smallTextScale, (float)smallTextScale, (float)1.0f);
            fontRender.func_85187_a(prefix, 0, (int)(16.0f / smallTextScale) - fontRender.field_78288_b + 1, 0xFFFFFF, true);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3008);
    }

    private static String getPrefix(String dimName) {
        switch (dimName) {
            case "Mo": {
                return "T1";
            }
            case "De": 
            case "Ma": 
            case "Ph": {
                return "T2";
            }
            case "As": 
            case "Ca": 
            case "Ce": 
            case "Eu": 
            case "Ga": 
            case "Rb": {
                return "T3";
            }
            case "Io": 
            case "Me": 
            case "Ve": {
                return "T4";
            }
            case "En": 
            case "Mi": 
            case "Ob": 
            case "Ti": 
            case "Ra": {
                return "T5";
            }
            case "Pr": 
            case "Tr": {
                return "T6";
            }
            case "Ha": 
            case "KB": 
            case "MM": 
            case "Pl": {
                return "T7";
            }
            case "BC": 
            case "BE": 
            case "BF": 
            case "CB": 
            case "TE": 
            case "DD": 
            case "VB": {
                return "T8";
            }
        }
        return "";
    }
}

