/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.StatCollector;
import pers.gwyog.gtneioreplugin.GTNEIOrePlugin;
import pers.gwyog.gtneioreplugin.util.StringPaddingHack;

public class DimensionHelper {
    public static final String[] DimName = new String[]{"Overworld", "Nether", "Twilight", "TheEnd", "Vanilla_EndAsteroids", "EndAsteroid", "GalacticraftCore_Moon", "GalaxySpace_Deimos", "GalacticraftMars_Mars", "GalaxySpace_Phobos", "GalacticraftMars_Asteroids", "GalaxySpace_Callisto", "GalaxySpace_Ceres", "GalaxySpace_Europa", "GalaxySpace_Ganymede", "Ross128b", "GalaxySpace_Io", "GalaxySpace_Mercury", "GalaxySpace_Venus", "GalaxySpace_Enceladus", "GalaxySpace_Miranda", "GalaxySpace_Oberon", "GalaxySpace_Titan", "Ross128ba", "GalaxySpace_Proteus", "GalaxySpace_Triton", "GalaxySpace_Haumea", "GalaxySpace_Kuiperbelt", "GalaxySpace_MakeMake", "GalaxySpace_Pluto", "GalaxySpace_BarnardC", "GalaxySpace_BarnardE", "GalaxySpace_BarnardF", "GalaxySpace_CentauriA", "GalaxySpace_TcetiE", "GalaxySpace_VegaB", "GalacticraftAmunRa_Anubis", "GalacticraftAmunRa_Horus", "GalacticraftAmunRa_Maahes", "GalacticraftAmunRa_Mehen Belt", "GalacticraftAmunRa_Neper", "GalacticraftAmunRa_Seth", "Underdark"};
    public static final String[] DimNameTrimmed = (String[])Arrays.stream(DimName).map(n -> n.replaceAll("GalacticraftCore_", "").replaceAll("GalacticraftMars_", "").replaceAll("GalaxySpace_", "").replaceAll("GalacticraftAmunRa_", "").replaceAll("Vanilla_", "Vanilla ")).toArray(String[]::new);
    public static final String[] DimNameDisplayed = new String[]{"Ow", "Ne", "TF", "ED", "VA", "EA", "Mo", "De", "Ma", "Ph", "As", "Ca", "Ce", "Eu", "Ga", "Rb", "Io", "Me", "Ve", "En", "Mi", "Ob", "Ti", "Ra", "Pr", "Tr", "Ha", "KB", "MM", "Pl", "BC", "BE", "BF", "CB", "TE", "VB", "An", "Ho", "Mh", "MB", "Np", "Se", "DD"};
    private static final HashMap<String, List<String>> tooltipBuffer = new HashMap();

    private static List<String> computeString(String line) {
        String[] dims = DimensionHelper.parseDimNames(line);
        for (int j = 0; j < dims.length; ++j) {
            String s = dims[j];
            for (int i = 0; i < DimNameDisplayed.length; ++i) {
                String string;
                if (!s.equals(DimNameDisplayed[i])) continue;
                String k = DimNameTrimmed[i];
                s = StatCollector.func_74838_a((String)("gtnop.world." + k));
                switch (k) {
                    case "Moon": {
                        string = "T1: " + s;
                        break;
                    }
                    case "Deimos": 
                    case "Mars": 
                    case "Phobos": {
                        string = "T2: " + s;
                        break;
                    }
                    case "Asteroids": 
                    case "Callisto": 
                    case "Ceres": 
                    case "Europa": 
                    case "Ganymede": 
                    case "Ross128b": {
                        string = "T3: " + s;
                        break;
                    }
                    case "Io": 
                    case "Mercury": 
                    case "Venus": {
                        string = "T4: " + s;
                        break;
                    }
                    case "Enceladus": 
                    case "Miranda": 
                    case "Oberon": 
                    case "Titan": 
                    case "Ross128ba": {
                        string = "T5: " + s;
                        break;
                    }
                    case "Proteus": 
                    case "Triton": {
                        string = "T6: " + s;
                        break;
                    }
                    case "Haumea": 
                    case "Kuiperbelt": 
                    case "MakeMake": 
                    case "Pluto": {
                        string = "T7: " + s;
                        break;
                    }
                    case "BarnardC": 
                    case "BarnardE": 
                    case "BarnardF": 
                    case "CentauriA": 
                    case "TcetiE": 
                    case "VegaB": {
                        string = "T8: " + s;
                        break;
                    }
                    case "Anubis": 
                    case "Horus": 
                    case "Maahes": 
                    case "Mehen Belt": 
                    case "Neper": 
                    case "Seth": {
                        string = "T9: " + s;
                        break;
                    }
                    case "Underdark": {
                        string = "T10: " + s;
                        break;
                    }
                    default: {
                        string = s;
                    }
                }
                dims[j] = s = string;
            }
        }
        if (dims.length > GTNEIOrePlugin.maxTooltipLines) {
            dims = StringPaddingHack.stringsToSpacedColumns(dims, dims.length / GTNEIOrePlugin.maxTooltipLines + (dims.length % GTNEIOrePlugin.maxTooltipLines == 0 ? 0 : 1), 2);
        }
        return Arrays.asList(dims);
    }

    public static String[] parseDimNames(String line) {
        String[] dims = line.split(",");
        for (int j = 0; j < dims.length; ++j) {
            String s = dims[j];
            s = s.replaceAll(",", "");
            dims[j] = s = s.trim();
        }
        return dims;
    }

    public static List<String> convertCondensedStringToToolTip(String line) {
        return tooltipBuffer.computeIfAbsent(line, tmp -> DimensionHelper.computeString(line));
    }
}

