/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.upgrade;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import tectech.thing.metaTileEntity.multi.godforge.util.MilestoneIcon;
import tectech.thing.metaTileEntity.multi.godforge.util.UpgradeColor;

public enum ForgeOfGodsUpgrade {
    START,
    IGCC,
    STEM,
    CFCE,
    GISS,
    FDIM,
    SA,
    GPCI,
    REC,
    GEM,
    CTCDD,
    QGPIU,
    SEFCP,
    TCT,
    GGEBE,
    TPTP,
    DOP,
    CNTI,
    EPEC,
    IMKG,
    NDPE,
    POS,
    DOR,
    NGMS,
    SEDS,
    PA,
    CD,
    TSE,
    TBF,
    EE,
    END;

    public static final ForgeOfGodsUpgrade[] VALUES;
    static final Set<ForgeOfGodsUpgrade> SPLIT_UPGRADES;
    private ForgeOfGodsUpgrade[] prerequisites;
    private boolean requireAllPrerequisites;
    private int shardCost;
    private final List<ItemStack> extraCost = new ArrayList<ItemStack>();
    private UpgradeColor color;
    private MilestoneIcon icon;
    private BGWindowSize windowSize;
    private Pos2d treePos;
    private ForgeOfGodsUpgrade[] dependents = new ForgeOfGodsUpgrade[0];
    private final String name = "fog.upgrade.tt." + this.ordinal();
    private final String nameShort = "fog.upgrade.tt.short." + this.ordinal();
    private final String bodyText = "fog.upgrade.text." + this.ordinal();
    private final String loreText = "fog.upgrade.lore." + this.ordinal();

    private void build(UnaryOperator<Builder> u) {
        Builder b = (Builder)u.apply(new Builder());
        this.prerequisites = b.prerequisites != null ? (ForgeOfGodsUpgrade[])b.prerequisites.toArray((Object[])new ForgeOfGodsUpgrade[0]) : new ForgeOfGodsUpgrade[]{};
        this.requireAllPrerequisites = b.requireAllPrerequisites;
        this.shardCost = b.shardCost;
        this.color = b.color;
        this.icon = b.icon;
        this.windowSize = b.windowSize;
        this.treePos = b.treePos;
    }

    public void addExtraCost(ItemStack ... cost) {
        if (this.extraCost.size() + cost.length > 12) {
            throw new IllegalArgumentException("Too many inputs for Godforge upgrade cost, cannot be more than 12!");
        }
        this.extraCost.addAll(Arrays.asList(cost));
    }

    public ForgeOfGodsUpgrade[] getPrerequisites() {
        return this.prerequisites;
    }

    public boolean requiresAllPrerequisites() {
        return this.requireAllPrerequisites;
    }

    public ForgeOfGodsUpgrade[] getDependents() {
        return this.dependents;
    }

    public int getShardCost() {
        return this.shardCost;
    }

    public boolean hasExtraCost() {
        return !this.extraCost.isEmpty();
    }

    public ItemStack[] getExtraCost() {
        return this.extraCost.toArray(new ItemStack[0]);
    }

    public UITexture getBackground() {
        return this.color.getBackground();
    }

    public UITexture getOverlay() {
        return this.color.getOverlay();
    }

    public UITexture getSymbol() {
        return this.icon.getSymbol();
    }

    public float getSymbolWidthRatio() {
        return this.icon.getWidthRatio();
    }

    public Size getWindowSize() {
        return this.windowSize.getWindowSize();
    }

    public int getLoreYPos() {
        return this.windowSize.getLoreY();
    }

    public Pos2d getTreePos() {
        return this.treePos;
    }

    public String getNameText() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getShortNameText() {
        return StatCollector.func_74838_a((String)this.nameShort);
    }

    public String getBodyText() {
        return StatCollector.func_74838_a((String)this.bodyText);
    }

    public String getLoreText() {
        return StatCollector.func_74838_a((String)this.loreText);
    }

    static {
        VALUES = ForgeOfGodsUpgrade.values();
        START.build(b -> b.background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).windowSize(BGWindowSize.LARGE).treePos(126, 56));
        IGCC.build(b -> b.prereqs(START).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.CONVERSION).treePos(126, 116));
        STEM.build(b -> b.prereqs(IGCC).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.CATALYST).treePos(96, 176));
        CFCE.build(b -> b.prereqs(IGCC).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.CATALYST).treePos(156, 176));
        GISS.build(b -> b.prereqs(STEM).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.CHARGE).treePos(66, 236));
        FDIM.build(b -> b.prereqs(STEM, CFCE).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).treePos(126, 236));
        SA.build(b -> b.prereqs(CFCE).cost(1).background(UpgradeColor.BLUE, MilestoneIcon.CONVERSION).treePos(186, 236));
        GPCI.build(b -> b.prereqs(FDIM).cost(2).background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).treePos(126, 296));
        REC.build(b -> b.prereqs(GISS, GPCI).requireAllPrereqs().cost(2).background(UpgradeColor.RED, MilestoneIcon.CHARGE).treePos(56, 356));
        GEM.build(b -> b.prereqs(GPCI).cost(2).background(UpgradeColor.BLUE, MilestoneIcon.CATALYST).treePos(126, 356));
        CTCDD.build(b -> b.prereqs(GPCI, SA).requireAllPrereqs().cost(2).background(UpgradeColor.RED, MilestoneIcon.CONVERSION).treePos(196, 356));
        QGPIU.build(b -> b.prereqs(REC, CTCDD).cost(2).background(UpgradeColor.BLUE, MilestoneIcon.CATALYST).treePos(126, 416));
        SEFCP.build(b -> b.prereqs(QGPIU).cost(3).background(UpgradeColor.PURPLE, MilestoneIcon.CATALYST).treePos(66, 476));
        TCT.build(b -> b.prereqs(QGPIU).cost(3).background(UpgradeColor.ORANGE, MilestoneIcon.CONVERSION).treePos(126, 476));
        GGEBE.build(b -> b.prereqs(QGPIU).cost(3).background(UpgradeColor.GREEN, MilestoneIcon.CHARGE).treePos(186, 476));
        TPTP.build(b -> b.prereqs(GGEBE).cost(4).background(UpgradeColor.GREEN, MilestoneIcon.CONVERSION).treePos(246, 496));
        DOP.build(b -> b.prereqs(CNTI).cost(4).background(UpgradeColor.PURPLE, MilestoneIcon.CONVERSION).treePos(6, 556));
        CNTI.build(b -> b.prereqs(SEFCP).cost(3).background(UpgradeColor.PURPLE, MilestoneIcon.CHARGE).treePos(66, 536));
        EPEC.build(b -> b.prereqs(TCT).cost(3).background(UpgradeColor.ORANGE, MilestoneIcon.CONVERSION).treePos(126, 536));
        IMKG.build(b -> b.prereqs(GGEBE).cost(3).background(UpgradeColor.GREEN, MilestoneIcon.CHARGE).treePos(186, 536));
        NDPE.build(b -> b.prereqs(CNTI).cost(3).background(UpgradeColor.PURPLE, MilestoneIcon.CHARGE).treePos(66, 596));
        POS.build(b -> b.prereqs(EPEC).cost(3).background(UpgradeColor.ORANGE, MilestoneIcon.CONVERSION).treePos(126, 596));
        DOR.build(b -> b.prereqs(IMKG).cost(3).background(UpgradeColor.GREEN, MilestoneIcon.CONVERSION).treePos(186, 596));
        NGMS.build(b -> b.prereqs(NDPE, POS, DOR).cost(4).background(UpgradeColor.BLUE, MilestoneIcon.CHARGE).treePos(126, 656));
        SEDS.build(b -> b.prereqs(NGMS).cost(5).background(UpgradeColor.BLUE, MilestoneIcon.CONVERSION).treePos(126, 718));
        PA.build(b -> b.prereqs(SEDS).cost(6).background(UpgradeColor.BLUE, MilestoneIcon.CONVERSION).treePos(36, 758));
        CD.build(b -> b.prereqs(PA).cost(7).background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).treePos(36, 848));
        TSE.build(b -> b.prereqs(CD).cost(8).background(UpgradeColor.BLUE, MilestoneIcon.CATALYST).treePos(126, 888));
        TBF.build(b -> b.prereqs(TSE).cost(9).background(UpgradeColor.BLUE, MilestoneIcon.CHARGE).treePos(216, 848));
        EE.build(b -> b.prereqs(TBF).cost(10).background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).treePos(216, 758));
        END.build(b -> b.prereqs(EE).cost(12).background(UpgradeColor.BLUE, MilestoneIcon.COMPOSITION).windowSize(BGWindowSize.LARGE).treePos(126, 798));
        SPLIT_UPGRADES = ImmutableSet.of((Object)((Object)SEFCP), (Object)((Object)TCT), (Object)((Object)GGEBE));
        EnumMap<ForgeOfGodsUpgrade, List> dependencies = new EnumMap<ForgeOfGodsUpgrade, List>(ForgeOfGodsUpgrade.class);
        for (ForgeOfGodsUpgrade upgrade : VALUES) {
            for (ForgeOfGodsUpgrade prerequisite : upgrade.prerequisites) {
                dependencies.computeIfAbsent(prerequisite, $ -> new ArrayList()).add(upgrade);
            }
        }
        for (Map.Entry entry : dependencies.entrySet()) {
            ForgeOfGodsUpgrade upgrade = (ForgeOfGodsUpgrade)((Object)entry.getKey());
            List deps = (List)entry.getValue();
            if (deps == null) continue;
            upgrade.dependents = deps.toArray(new ForgeOfGodsUpgrade[0]);
        }
    }

    public static class Builder {
        private ObjectList<ForgeOfGodsUpgrade> prerequisites;
        private boolean requireAllPrerequisites;
        private int shardCost;
        private UpgradeColor color = UpgradeColor.BLUE;
        private MilestoneIcon icon = MilestoneIcon.CHARGE;
        private BGWindowSize windowSize = BGWindowSize.STANDARD;
        private Pos2d treePos = new Pos2d(0, 0);

        private Builder() {
        }

        public Builder prereqs(ForgeOfGodsUpgrade ... prereqs) {
            if (this.prerequisites != null) {
                throw new IllegalArgumentException("Cannot repeat calls to ForgeOfGodsUpgrade$Builder#prereqs");
            }
            this.prerequisites = new ObjectArrayList((Object[])prereqs);
            return this;
        }

        public Builder requireAllPrereqs() {
            this.requireAllPrerequisites = true;
            return this;
        }

        public Builder cost(int shards) {
            this.shardCost = shards;
            return this;
        }

        public Builder background(UpgradeColor color, MilestoneIcon icon) {
            this.color = color;
            this.icon = icon;
            return this;
        }

        public Builder windowSize(BGWindowSize windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder treePos(int x, int y) {
            this.treePos = new Pos2d(x, y);
            return this;
        }
    }

    static enum BGWindowSize {
        STANDARD(250, 250, 110),
        LARGE(300, 300, 85);

        private final Size size;
        private final int loreY;

        private BGWindowSize(int width, int height, int loreY) {
            this.size = new Size(width, height);
            this.loreY = loreY;
        }

        public Size getWindowSize() {
            return this.size;
        }

        public int getLoreY() {
            return this.loreY;
        }
    }
}

