/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.color;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class StarColorSetting {
    private final int r;
    private final int g;
    private final int b;
    private final float gamma;

    public StarColorSetting(int r, int g, int b, float gamma) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.gamma = gamma;
    }

    public int getColorR() {
        return this.r;
    }

    public int getColorG() {
        return this.g;
    }

    public int getColorB() {
        return this.b;
    }

    public float getGamma() {
        return this.gamma;
    }

    protected NBTTagCompound serialize() {
        NBTTagCompound NBT2 = new NBTTagCompound();
        NBT2.func_74768_a("R", this.r);
        NBT2.func_74768_a("G", this.g);
        NBT2.func_74768_a("B", this.b);
        NBT2.func_74776_a("Gamma", this.gamma);
        return NBT2;
    }

    protected static StarColorSetting deserialize(NBTTagCompound NBT2) {
        int r = NBT2.func_74762_e("R");
        int g = NBT2.func_74762_e("G");
        int b = NBT2.func_74762_e("B");
        float gamma = NBT2.func_74760_g("Gamma");
        return new StarColorSetting(r, g, b, gamma);
    }

    public static void writeToBuffer(PacketBuffer buf, StarColorSetting color) {
        buf.writeInt(color.r);
        buf.writeInt(color.g);
        buf.writeInt(color.b);
        buf.writeFloat(color.gamma);
    }

    public static StarColorSetting readFromBuffer(PacketBuffer buf) {
        int r = buf.readInt();
        int g = buf.readInt();
        int b = buf.readInt();
        float gamma = buf.readFloat();
        return new StarColorSetting(r, g, b, gamma);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarColorSetting that = (StarColorSetting)o;
        if (this.r != that.r) {
            return false;
        }
        if (this.g != that.g) {
            return false;
        }
        if (this.b != that.b) {
            return false;
        }
        return this.gamma == that.gamma;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("r", this.r).append("g", this.g).append("b", this.b).append("gamma", this.gamma).build();
    }
}

