/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import kekztech.common.itemBlocks.ItemBlockThaumiumReinforcedJar;
import kekztech.common.tileentities.TileEntityThaumiumReinforcedJar;
import kekztech.common.tileentities.TileEntityThaumiumReinforcedVoidJar;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.blocks.BlockJar;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemEssence;
import thaumcraft.common.tiles.TileJarFillable;

public class BlockThaumiumReinforcedJar
extends BlockJar {
    private static final BlockThaumiumReinforcedJar INSTANCE = new BlockThaumiumReinforcedJar();

    private BlockThaumiumReinforcedJar() {
        super.func_149711_c(6.0f);
        super.func_149752_b(6.0f);
    }

    public static Block registerBlock() {
        String blockName = "kekztech_thaumiumreinforcedjar_block";
        INSTANCE.func_149663_c("kekztech_thaumiumreinforcedjar_block");
        INSTANCE.setHarvestLevel("pickaxe", 2);
        GameRegistry.registerBlock((Block)INSTANCE, ItemBlockThaumiumReinforcedJar.class, (String)"kekztech_thaumiumreinforcedjar_block");
        return INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.iconLiquid = ir.func_94245_a("thaumcraft:animatedglow");
        this.iconJarSide = ir.func_94245_a("kekztech:thaumreinforced_jar_side");
        this.iconJarTop = ir.func_94245_a("kekztech:thaumreinforced_jar_top");
        this.iconJarTopVoid = ir.func_94245_a("kekztech:thaumreinforced_jar_top_void");
        this.iconJarSideVoid = ir.func_94245_a("kekztech:thaumreinforced_jar_side_void");
        this.iconJarBottom = ir.func_94245_a("kekztech:thaumreinforced_jar_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (meta == 3) {
            return new TileEntityThaumiumReinforcedVoidJar();
        }
        return new TileEntityThaumiumReinforcedJar();
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityThaumiumReinforcedJar) {
            TileEntityThaumiumReinforcedJar ite = (TileEntityThaumiumReinforcedJar)te;
            this.breakBlockWarpy(world, x, y, z, ite.amount, 50, 1.0f);
        } else if (te instanceof TileEntityThaumiumReinforcedVoidJar) {
            TileEntityThaumiumReinforcedVoidJar ite = (TileEntityThaumiumReinforcedVoidJar)te;
            this.breakBlockWarpy(world, x, y, z, ite.amount, 50, 1.0f);
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void breakBlockWarpy(World world, int x, int y, int z, int fillAmount, int iterations, float explosionStrength) {
        if (fillAmount > 0) {
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, explosionStrength, false);
            int limit = fillAmount / 16;
            int created = 0;
            for (int i = 0; i < iterations; ++i) {
                int zf;
                int yf;
                int xf = x + world.field_73012_v.nextInt(7) - world.field_73012_v.nextInt(7);
                if (!world.func_147437_c(xf, yf = x + world.field_73012_v.nextInt(7) - world.field_73012_v.nextInt(7), zf = x + world.field_73012_v.nextInt(7) - world.field_73012_v.nextInt(7))) continue;
                if (yf > y) {
                    world.func_147465_d(xf, yf, zf, ConfigBlocks.blockFluxGas, 8, 3);
                } else {
                    world.func_147465_d(xf, yf, zf, ConfigBlocks.blockFluxGoo, 8, 3);
                }
                if (created++ > limit) break;
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f1, float f2, float f3) {
        super.func_149727_a(world, x, y, z, player, side, f1, f2, f3);
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == ConfigItems.itemEssence) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityThaumiumReinforcedJar) {
                return this.dealWithPhial(world, player, x, y, z);
            }
            if (te instanceof TileEntityThaumiumReinforcedVoidJar) {
                return this.dealWithPhial(world, player, x, y, z);
            }
        }
        return true;
    }

    private boolean dealWithPhial(World world, EntityPlayer player, int x, int y, int z) {
        TileJarFillable kte = (TileJarFillable)world.func_147438_o(x, y, z);
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem.func_77960_j() == 0) {
            if (kte.amount >= 8) {
                if (world.field_72995_K) {
                    player.func_71038_i();
                    return false;
                }
                Aspect jarAspect = Aspect.getAspect((String)kte.aspect.getTag());
                if (kte.takeFromContainer(jarAspect, 8)) {
                    --heldItem.field_77994_a;
                    ItemStack filledPhial = new ItemStack(ConfigItems.itemEssence, 1, 1);
                    AspectList phialContent = new AspectList().add(jarAspect, 8);
                    ((ItemEssence)ConfigItems.itemEssence).setAspects(filledPhial, phialContent);
                    if (!player.field_71071_by.func_70441_a(filledPhial)) {
                        world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), filledPhial));
                    }
                    world.func_72956_a((Entity)player, "game.neutral.swim", 0.25f, 1.0f);
                    player.field_71069_bz.func_75142_b();
                    return true;
                }
            }
        } else {
            AspectList phialContent = ((ItemEssence)ConfigItems.itemEssence).getAspects(heldItem);
            if (phialContent != null && phialContent.size() == 1) {
                Aspect phialAspect = phialContent.getAspects()[0];
                if (kte.amount + 8 <= kte.maxAmount && kte.doesContainerAccept(phialAspect)) {
                    if (world.field_72995_K) {
                        player.func_71038_i();
                        return false;
                    }
                    if (kte.addToContainer(phialAspect, 8) == 0) {
                        world.func_147471_g(x, y, z);
                        kte.func_70296_d();
                        --heldItem.field_77994_a;
                        if (!player.field_71071_by.func_70441_a(new ItemStack(ConfigItems.itemEssence, 1, 0))) {
                            world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), new ItemStack(ConfigItems.itemEssence, 1, 0)));
                        }
                        world.func_72956_a((Entity)player, "game.neutral.swim", 0.25f, 1.0f);
                        player.field_71069_bz.func_75142_b();
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this, 1, meta == 3 ? 3 : 0));
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityThaumiumReinforcedJar) {
            TileEntityThaumiumReinforcedJar ite = (TileEntityThaumiumReinforcedJar)te;
            if (ite.aspectFilter != null) {
                ItemStack droppedLabel = new ItemStack(ConfigItems.itemResource, 1, 13);
                droppedLabel.func_77982_d(new NBTTagCompound());
                AspectList aspect = new AspectList().add(ite.aspectFilter, 0);
                aspect.writeToNBT(droppedLabel.func_77978_p());
                drops.add(droppedLabel);
            }
        } else if (te instanceof TileEntityThaumiumReinforcedVoidJar) {
            TileEntityThaumiumReinforcedVoidJar ite = (TileEntityThaumiumReinforcedVoidJar)te;
            if (ite.aspectFilter != null) {
                ItemStack droppedLabel = new ItemStack(ConfigItems.itemResource, 1, 13);
                droppedLabel.func_77982_d(new NBTTagCompound());
                AspectList aspect = new AspectList().add(ite.aspectFilter, 0);
                aspect.writeToNBT(droppedLabel.func_77978_p());
                drops.add(droppedLabel);
            }
        }
        return drops;
    }

    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
    }

    public boolean func_149659_a(Explosion e) {
        return false;
    }
}

