/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gtPlusPlus.xmod.bop.blocks.BOPBlockRegistrator;
import gtPlusPlus.xmod.forestry.ForestryTreeHandler;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.MTETreeFarm;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RecipeLoaderTreeFarm {
    public static void generateRecipes() {
        RecipeLoaderTreeFarm.generateVanillaTrees();
        if (Mods.IndustrialCraft2.isModLoaded()) {
            RecipeLoaderTreeFarm.generateIC2Trees();
        }
        if (Mods.TinkerConstruct.isModLoaded()) {
            RecipeLoaderTreeFarm.generateTinkersTrees();
        }
        RecipeLoaderTreeFarm.generateGTPPTrees();
        if (Mods.TwilightForest.isModLoaded()) {
            RecipeLoaderTreeFarm.generateTwilightForestTrees();
        }
        if (Mods.GalaxySpace.isModLoaded()) {
            RecipeLoaderTreeFarm.generateGalaxySpaceTrees();
        }
        if (Mods.GalacticraftAmunRa.isModLoaded()) {
            RecipeLoaderTreeFarm.generateAmunRaTrees();
        }
        if (Mods.Thaumcraft.isModLoaded()) {
            RecipeLoaderTreeFarm.generateThaumcraftTrees();
        }
        if (Mods.ThaumicBases.isModLoaded()) {
            RecipeLoaderTreeFarm.generateThaumicBasesTrees();
        }
        if (Mods.TaintedMagic.isModLoaded()) {
            RecipeLoaderTreeFarm.generateTaintedMagicTrees();
        }
        if (Mods.ForbiddenMagic.isModLoaded()) {
            RecipeLoaderTreeFarm.generateForbiddenMagicTrees();
        }
        if (Mods.Witchery.isModLoaded()) {
            RecipeLoaderTreeFarm.generateWitcheryTrees();
        }
        if (Mods.Natura.isModLoaded()) {
            RecipeLoaderTreeFarm.generateNaturaTrees();
        }
        if (Mods.BiomesOPlenty.isModLoaded()) {
            RecipeLoaderTreeFarm.generateBOPTrees();
        }
        if (Mods.PamsHarvestCraft.isModLoaded()) {
            RecipeLoaderTreeFarm.generatePamsTrees();
        }
        if (Mods.PamsHarvestTheNether.isModLoaded()) {
            RecipeLoaderTreeFarm.generatePamsNetherTrees();
        }
        if (Mods.EtFuturumRequiem.isModLoaded()) {
            RecipeLoaderTreeFarm.generateEtFuturumRequiemTrees();
        }
        if (Mods.Forestry.isModLoaded()) {
            ForestryTreeHandler.generateForestryTrees();
        }
        if (Mods.Forestry.isModLoaded() && Mods.ExtraTrees.isModLoaded()) {
            ForestryTreeHandler.generateExtraTreesTrees();
        }
    }

    private static void generateVanillaTrees() {
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 0), new ItemStack(Items.field_151034_e, 1, 0));
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150364_r, 2, 1), new ItemStack((Block)Blocks.field_150362_t, 1, 1), null);
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack((Block)Blocks.field_150362_t, 1, 2), null);
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 2, 3), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151100_aR, 1, 3));
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack((Block)Blocks.field_150361_u, 1, 0), null);
        MTETreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack((Block)Blocks.field_150361_u, 1, 1), new ItemStack(Items.field_151034_e, 1, 0));
        MTETreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150338_P, 1, 0), new ItemStack(Blocks.field_150420_aW, 1, 0), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "brown_mushroom", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150337_Q, 1, 0), new ItemStack(Blocks.field_150419_aX, 1, 0), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "red_mushroom", 1L, 0), null);
    }

    private static void generateIC2Trees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "blockRubSapling", 1L, 0), GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "blockRubWood", 1L, 0), GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "blockRubLeaves", 1L, 0), GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "itemHarz", 1L, 0));
    }

    private static void generateTinkersTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TinkerConstruct.ID, "slime.sapling", 1L, 0), GTModHandler.getModItem(Mods.TinkerConstruct.ID, "slime.gel", 1L, 1), GTModHandler.getModItem(Mods.TinkerConstruct.ID, "slime.leaves", 1L, 0), GTModHandler.getModItem(Mods.TinkerConstruct.ID, "strangeFood", 1L, 0));
    }

    private static void generateGTPPTrees() {
        MTETreeFarm.registerTreeProducts(new ItemStack(BOPBlockRegistrator.sapling_Rainforest, 1, 0), new ItemStack(BOPBlockRegistrator.log_Rainforest, 3, 0), new ItemStack(BOPBlockRegistrator.leaves_Rainforest, 1, 0), new ItemStack(Items.field_151034_e, 1, 0));
        MTETreeFarm.registerTreeProducts(new ItemStack(BOPBlockRegistrator.sapling_Pine, 1, 0), new ItemStack(BOPBlockRegistrator.log_Pine, 1, 0), new ItemStack(BOPBlockRegistrator.leaves_Pine, 1, 0), GregtechItemList.Pinecone.get(1L, new Object[0]));
    }

    private static void generateTwilightForestTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 1), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 1L, 1), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 2), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 1L, 2), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 3), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 1L, 3), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.DarkLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 4), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 4L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 5), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLog", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 6), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLog", 1L, 1), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLeaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 8), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLog", 1L, 3), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFMagicLeaves", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 9), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLog", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFThorns", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFThorns", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFThorns", 1L, 1), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves3", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFThornRose", 1L, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TwilightForest.ID, "item.magicBeans", 1L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.HugeStalk", 5L, 0), GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFLeaves3", 1L, 1), null);
    }

    private static void generateGalaxySpaceTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.GalaxySpace.ID, "barnardaCsapling", 1L, 0), GTModHandler.getModItem(Mods.GalaxySpace.ID, "barnardaClog", 1L, 0), GTModHandler.getModItem(Mods.GalaxySpace.ID, "barnardaCleaves", 1L, 0), null);
    }

    private static void generateAmunRaTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.saplings", 1L, 0), GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.log1", 1L, 0), GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.null", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.saplings", 1L, 1), GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.wood1", 1L, 0), null, GTModHandler.getModItem(Mods.GalacticraftAmunRa.ID, "tile.wood1", 1L, 1));
    }

    private static void generateNaturaTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "redwood", 5L, 1), GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 2L, 0), GTModHandler.getModItem(Mods.Natura.ID, "floraleaves", 2L, 0), GTModHandler.getModItem(Mods.Natura.ID, "redwood", 2L, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "tree", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "floraleaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 2), GTModHandler.getModItem(Mods.Natura.ID, "tree", 1L, 3), GTModHandler.getModItem(Mods.Natura.ID, "floraleaves", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 3), GTModHandler.getModItem(Mods.Natura.ID, "tree", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "floraleavesnocolor", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 4), GTModHandler.getModItem(Mods.Natura.ID, "tree", 1L, 2), GTModHandler.getModItem(Mods.Natura.ID, "floraleavesnocolor", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 5), GTModHandler.getModItem(Mods.Natura.ID, "bloodwood", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "floraleavesnocolor", 1L, 2), new ItemStack(Items.field_151137_ax, 1, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 6), GTModHandler.getModItem(Mods.Natura.ID, "Dark Tree", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "Dark Leaves", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "Natura.netherfood", 1L, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "florasapling", 1L, 7), GTModHandler.getModItem(Mods.Natura.ID, "Dark Tree", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "Dark Leaves", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Rare Sapling", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "Rare Tree", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "Rare Leaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Rare Sapling", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "Rare Tree", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "Rare Leaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Rare Sapling", 1L, 2), GTModHandler.getModItem(Mods.Natura.ID, "Rare Tree", 1L, 2), GTModHandler.getModItem(Mods.Natura.ID, "Rare Leaves", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Rare Sapling", 1L, 3), GTModHandler.getModItem(Mods.Natura.ID, "Rare Tree", 1L, 3), GTModHandler.getModItem(Mods.Natura.ID, "Rare Leaves", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Rare Sapling", 1L, 4), GTModHandler.getModItem(Mods.Natura.ID, "willow", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "floraleavesnocolor", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Glowshroom", 1L, 0), GTModHandler.getModItem(Mods.Natura.ID, "greenGlowshroom", 1L, 0), null, null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Glowshroom", 1L, 1), GTModHandler.getModItem(Mods.Natura.ID, "purpleGlowshroom", 1L, 0), null, null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Natura.ID, "Glowshroom", 1L, 2), GTModHandler.getModItem(Mods.Natura.ID, "blueGlowshroom", 1L, 0), null, null);
    }

    private static void generateBOPTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 0), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "appleLeaves", 1L, 0), new ItemStack(Items.field_151034_e, 2, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 1), new ItemStack(Blocks.field_150364_r, 1, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves1", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "food", 1L, 8));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "bamboo", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves1", 1L, 9), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs2", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves1", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 4), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs1", 1L, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves1", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 5), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves2", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "food", 1L, 8));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 6), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs1", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves2", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "misc", 1L, 13));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 7), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs2", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves2", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 8), new ItemStack(Blocks.field_150363_s, 1, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves2", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 9), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves3", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "food", 1L, 8));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 10), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs1", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves3", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 11), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves3", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 12), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs1", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves3", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 13), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs4", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves4", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "food", 1L, 8));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 14), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs4", 1L, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "leaves4", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "saplings", 1L, 15), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "persimmonLeaves", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "food", 2L, 8));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs1", 4L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 2L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves1", 2L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs2", 1L, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves1", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 2), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs2", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves1", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs3", 2L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves1", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 4), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs3", 1L, 1), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves2", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 5), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs4", 1L, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves2", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 6), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs4", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves2", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedSaplings", 1L, 7), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "colorizedLeaves2", 1L, 3), null);
        MTETreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150328_O, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs3", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "petals", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150327_N, 1, 0), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "logs3", 1L, 3), GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "petals", 1L, 1), null);
    }

    private static void addPamTree(String name, int meta) {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pam" + name + "Sapling", 1L, 0), new ItemStack(Blocks.field_150364_r, 1, meta), new ItemStack((Block)Blocks.field_150362_t, 1, meta), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, name + "Item", 2L, 0));
    }

    private static void generatePamsTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pamappleSapling", 1L, 0), new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 0), new ItemStack(Items.field_151034_e, 2, 0));
        RecipeLoaderTreeFarm.addPamTree("almond", 3);
        RecipeLoaderTreeFarm.addPamTree("apricot", 3);
        RecipeLoaderTreeFarm.addPamTree("avocado", 0);
        RecipeLoaderTreeFarm.addPamTree("banana", 3);
        RecipeLoaderTreeFarm.addPamTree("cashew", 3);
        RecipeLoaderTreeFarm.addPamTree("cherry", 0);
        RecipeLoaderTreeFarm.addPamTree("chestnut", 0);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pamcinnamonSapling", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pamCinnamon", 1L, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 3), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "cinnamonItem", 2L, 0));
        RecipeLoaderTreeFarm.addPamTree("coconut", 3);
        RecipeLoaderTreeFarm.addPamTree("date", 3);
        RecipeLoaderTreeFarm.addPamTree("dragonfruit", 3);
        RecipeLoaderTreeFarm.addPamTree("durian", 3);
        RecipeLoaderTreeFarm.addPamTree("fig", 3);
        RecipeLoaderTreeFarm.addPamTree("grapefruit", 3);
        RecipeLoaderTreeFarm.addPamTree("lemon", 3);
        RecipeLoaderTreeFarm.addPamTree("lime", 3);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pammapleSapling", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pamMaple", 1L, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 1), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "maplesyrupItem", 2L, 0));
        RecipeLoaderTreeFarm.addPamTree("mango", 3);
        RecipeLoaderTreeFarm.addPamTree("nutmeg", 0);
        RecipeLoaderTreeFarm.addPamTree("olive", 0);
        RecipeLoaderTreeFarm.addPamTree("orange", 3);
        RecipeLoaderTreeFarm.addPamTree("papaya", 3);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pampaperbarkSapling", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "pamPaperbark", 1L, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151121_aF, 1, 0));
        RecipeLoaderTreeFarm.addPamTree("peach", 3);
        RecipeLoaderTreeFarm.addPamTree("pear", 0);
        RecipeLoaderTreeFarm.addPamTree("pecan", 3);
        RecipeLoaderTreeFarm.addPamTree("peppercorn", 3);
        RecipeLoaderTreeFarm.addPamTree("persimmon", 3);
        RecipeLoaderTreeFarm.addPamTree("pistachio", 3);
        RecipeLoaderTreeFarm.addPamTree("plum", 0);
        RecipeLoaderTreeFarm.addPamTree("pomegranate", 3);
        RecipeLoaderTreeFarm.addPamTree("starfruit", 3);
        RecipeLoaderTreeFarm.addPamTree("vanillabean", 3);
        RecipeLoaderTreeFarm.addPamTree("walnut", 0);
        RecipeLoaderTreeFarm.addPamTree("gooseberry", 0);
    }

    private static void generatePamsNetherTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.PamsHarvestTheNether.ID, "netherSapling", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestTheNether.ID, "netherLog", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestTheNether.ID, "netherLeaves", 1L, 0), GTModHandler.getModItem(Mods.PamsHarvestTheNether.ID, "ignisfruitItem", 2L, 0));
    }

    private static void generateThaumcraftTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockCustomPlant", 1L, 0), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockMagicalLog", 2L, 0), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockMagicalLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockCustomPlant", 1L, 1), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockMagicalLog", 1L, 1), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockMagicalLeaves", 1L, 1), null);
    }

    private static void generateThaumicBasesTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.ThaumicBases.ID, "goldenOakSapling", 1L, 0), new ItemStack(Blocks.field_150364_r, 1, 0), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLeaves", 1L, 0), GTModHandler.getModItem(Mods.Thaumcraft.ID, "blockMagicalLeaves", 1L, 0), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.ThaumicBases.ID, "goldenOakSapling", 1L, 1), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLogs", 1L, 0), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLeaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.ThaumicBases.ID, "goldenOakSapling", 1L, 2), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLogs", 1L, 1), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLeaves", 1L, 2), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.ThaumicBases.ID, "goldenOakSapling", 1L, 3), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLogs", 1L, 2), GTModHandler.getModItem(Mods.ThaumicBases.ID, "genLeaves", 1L, 3), null);
    }

    private static void generateTaintedMagicTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.TaintedMagic.ID, "BlockWarpwoodSapling", 1L, 0), GTModHandler.getModItem(Mods.TaintedMagic.ID, "BlockWarpwoodLog", 1L, 0), GTModHandler.getModItem(Mods.TaintedMagic.ID, "BlockWarpwoodLeaves", 1L, 0), null);
    }

    private static void generateForbiddenMagicTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.ForbiddenMagic.ID, "TaintSapling", 1L, 0), GTModHandler.getModItem(Mods.ForbiddenMagic.ID, "TaintLog", 1L, 0), GTModHandler.getModItem(Mods.ForbiddenMagic.ID, "TaintLeaves", 1L, 0), GTModHandler.getModItem(Mods.ForbiddenMagic.ID, "TaintFruit", 1L, 0));
    }

    private static void generateWitcheryTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Witchery.ID, "witchsapling", 1L, 0), GTModHandler.getModItem(Mods.Witchery.ID, "witchlog", 1L, 0), GTModHandler.getModItem(Mods.Witchery.ID, "witchleaves", 1L, 0), GTModHandler.getModItem(Mods.Witchery.ID, "ingredient", 1L, 63));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Witchery.ID, "witchsapling", 1L, 1), GTModHandler.getModItem(Mods.Witchery.ID, "witchlog", 1L, 1), GTModHandler.getModItem(Mods.Witchery.ID, "witchleaves", 1L, 1), null);
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.Witchery.ID, "witchsapling", 1L, 2), GTModHandler.getModItem(Mods.Witchery.ID, "witchlog", 1L, 2), GTModHandler.getModItem(Mods.Witchery.ID, "witchleaves", 1L, 2), null);
    }

    private static void generateEtFuturumRequiemTrees() {
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "sapling", 1L, 1), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "cherry_log", 1L, 0), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "leaves", 1L, 1), GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "cherryItem", 1L, 0));
        MTETreeFarm.registerTreeProducts(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "chorus_flower", 1L, 0), GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "chorus_plant", 1L, 0), null, GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "chorus_fruit", 1L, 0));
    }
}

