/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.inventories.InventoryFishTrap;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.FishingHooks;

public class TileEntityFishTrap
extends TileEntity
implements ISidedInventory {
    private int tickCount = 0;
    private final InventoryFishTrap inventoryContents = new InventoryFishTrap();
    private String customName;
    private static final short[] waterBlocksToTickRate = new short[]{0, 0, 5600, 4400, 3200, 2000, 1750};
    private int surroundingWaterBlocks = 0;

    private int getNumberOfSurroundingWater() {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return 0;
        }
        Block[] surroundingBlocks = new Block[]{this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)};
        int waterCount = 0;
        int trapCount = 0;
        for (Block checkBlock : surroundingBlocks) {
            if (checkBlock == GregtechItemList.FishTrap.getBlock()) {
                ++trapCount;
                continue;
            }
            if (checkBlock != Blocks.field_150355_j && checkBlock != Blocks.field_150358_i) continue;
            ++waterCount;
        }
        if (waterCount < 2) {
            return 0;
        }
        return waterCount + Math.min(trapCount, 4);
    }

    public InventoryFishTrap getInventory() {
        return this.inventoryContents;
    }

    private void tryAddLoot() {
        ItemUtils.organiseInventory(this.getInventory());
        ItemStack loot = this.generateLootForFishTrap();
        if (loot == null) {
            return;
        }
        for (ItemStack contents : this.getInventory().getInventory()) {
            if (!GTUtility.areStacksEqual(loot, contents) || contents.field_77994_a >= contents.func_77976_d()) continue;
            ++contents.field_77994_a;
            this.func_70296_d();
            return;
        }
        int checkingSlot = 0;
        for (ItemStack contents : this.getInventory().getInventory()) {
            if (contents == null) {
                this.getInventory().func_70299_a(checkingSlot, loot);
                this.func_70296_d();
                return;
            }
            ++checkingSlot;
        }
    }

    @Nullable
    private ItemStack generateLootForFishTrap() {
        int lootWeight = MathUtils.randInt(0, 100);
        ItemStack loot = null;
        if (lootWeight <= 5) {
            loot = new ItemStack(Items.field_151123_aH);
        } else if (lootWeight <= 10) {
            loot = new ItemStack(Items.field_151103_aS);
        } else if (lootWeight <= 15) {
            loot = new ItemStack((Block)Blocks.field_150354_m);
        } else if (lootWeight <= 20) {
            loot = new ItemStack(Items.field_151100_aR, 1, 0);
        } else if (lootWeight <= 23) {
            loot = Mods.PamsHarvestCraft.isModLoaded() ? ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cropSeaweed", 1) : new ItemStack(Blocks.field_150346_d);
        } else if (lootWeight <= 99) {
            Random xstr = new Random();
            loot = FishingHooks.getRandomFishable((Random)xstr, (float)100.0f);
        } else if (lootWeight == 100) {
            int rareLoot = MathUtils.randInt(1, 10);
            loot = rareLoot <= 4 ? Materials.Iron.getNuggets(1) : (rareLoot <= 7 ? new ItemStack(Items.field_151074_bl) : (rareLoot <= 9 ? new ItemStack(Items.field_151166_bC) : new ItemStack(Items.field_151045_i)));
        }
        if (loot != null) {
            loot.field_77994_a = 1;
        }
        return loot;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount % 20 == 0) {
            this.surroundingWaterBlocks = this.getNumberOfSurroundingWater();
        }
        if (waterBlocksToTickRate[this.surroundingWaterBlocks] != 0 && this.tickCount > waterBlocksToTickRate[this.surroundingWaterBlocks]) {
            int aExtraLootChance = MathUtils.randInt(1, 1000);
            if (aExtraLootChance >= 999) {
                this.tryAddLoot();
                this.tryAddLoot();
                this.tryAddLoot();
            } else {
                this.tryAddLoot();
            }
            this.func_70296_d();
            this.tickCount = 0;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound chestData = new NBTTagCompound();
        this.inventoryContents.writeToNBT(chestData);
        nbt.func_74782_a("ContentsChest", (NBTBase)chestData);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventoryContents.readFromNBT(nbt.func_74775_l("ContentsChest"));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getInventory().func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getInventory().func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getInventory().func_94041_b(slot, itemstack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.getInventory().func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.fishtrap";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }
}

