/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.base;

import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.base.SPRequirements;
import gregtech.common.misc.spaceprojects.enums.SpaceBodyType;
import gregtech.common.misc.spaceprojects.enums.UpgradeStatus;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class SPUpgrade
implements ISpaceProject.ISP_Upgrade {
    protected String name;
    protected String unlocalizedName;
    protected ItemStack[] itemsCost;
    protected FluidStack[] fluidsCost;
    protected int totalStages;
    protected int currentStage;
    protected int buildTime;
    protected long voltage;
    protected SPRequirements requirements;
    protected ISpaceProject projectBelongingTo;

    @Override
    public String getUpgradeName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    @Override
    public ItemStack[] getItemsCostPerStage() {
        return this.itemsCost;
    }

    @Override
    public ItemStack getItemCostPerStage(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length) {
            return null;
        }
        return this.itemsCost[index];
    }

    @Override
    public ItemStack[] getCurrentItemsProgress() {
        ItemStack[] currentItemsProgress = new ItemStack[this.itemsCost.length];
        int index = 0;
        for (ItemStack item : this.itemsCost) {
            ItemStack copy = item.func_77946_l();
            copy.field_77994_a *= this.getCurrentStage();
            currentItemsProgress[index++] = copy;
        }
        return currentItemsProgress;
    }

    @Override
    public ItemStack getCurrentItemProgress(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length || this.itemsCost[index] == null) {
            return null;
        }
        ItemStack item = this.itemsCost[index].func_77946_l();
        item.field_77994_a *= this.getCurrentStage();
        return item;
    }

    @Override
    public ItemStack[] getTotalItemsCost() {
        ItemStack[] totalItemsCost = new ItemStack[this.itemsCost.length];
        int index = 0;
        for (ItemStack item : this.itemsCost) {
            ItemStack copy = item.func_77946_l();
            copy.field_77994_a *= this.getTotalStages();
            totalItemsCost[index++] = copy;
        }
        return totalItemsCost;
    }

    @Override
    public ItemStack getTotalItemCost(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length || this.itemsCost[index] == null) {
            return null;
        }
        ItemStack item = this.itemsCost[index].func_77946_l();
        item.field_77994_a *= this.getTotalStages();
        return item;
    }

    @Override
    public FluidStack[] getFluidsCostPerStage() {
        return this.fluidsCost;
    }

    @Override
    public FluidStack getFluidCostPerStage(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length) {
            return null;
        }
        return this.fluidsCost[index];
    }

    @Override
    public FluidStack[] getCurrentFluidsProgress() {
        if (this.fluidsCost == null) {
            return null;
        }
        FluidStack[] currentFluidsProgress = new FluidStack[this.fluidsCost.length];
        int index = 0;
        for (FluidStack fluid : this.fluidsCost) {
            FluidStack copy = fluid.copy();
            copy.amount *= this.getCurrentStage();
            currentFluidsProgress[index++] = copy;
        }
        return currentFluidsProgress;
    }

    @Override
    public FluidStack getCurrentFluidProgress(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length || this.fluidsCost[index] == null) {
            return null;
        }
        FluidStack fluid = this.fluidsCost[index].copy();
        fluid.amount *= this.getCurrentStage();
        return fluid;
    }

    @Override
    public FluidStack[] getTotalFluidsCost() {
        if (this.fluidsCost == null) {
            return null;
        }
        FluidStack[] totalFluidsCost = new FluidStack[this.fluidsCost.length];
        int index = 0;
        for (FluidStack fluid : this.fluidsCost) {
            FluidStack copy = fluid.copy();
            copy.amount *= this.getTotalStages();
            totalFluidsCost[index++] = copy;
        }
        return totalFluidsCost;
    }

    @Override
    public FluidStack getTotalFluidCost(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length || this.fluidsCost[index] == null) {
            return null;
        }
        FluidStack fluid = this.fluidsCost[index].copy();
        fluid.amount *= this.getTotalStages();
        return fluid;
    }

    @Override
    public int getTotalStages() {
        return this.totalStages;
    }

    @Override
    public int getUpgradeBuildTime() {
        return this.buildTime;
    }

    @Override
    public int getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public float getCurrentProgress() {
        return (float)(this.currentStage / this.totalStages) * 100.0f;
    }

    @Override
    public long getVoltage() {
        return this.voltage;
    }

    @Override
    public UpgradeStatus getStatus() {
        if (this.requirements == null) {
            return UpgradeStatus.Unlocked;
        }
        if (this.isFinished()) {
            return UpgradeStatus.Finished;
        }
        return UpgradeStatus.Locked;
    }

    @Override
    public SPRequirements getUpgradeRequirements() {
        return this.requirements;
    }

    @Override
    public ISpaceProject getParentProject() {
        return this.projectBelongingTo;
    }

    public SPUpgrade setUpgradeName(String upgradeName) {
        this.name = upgradeName;
        return this;
    }

    public SPUpgrade setUpgradeUnlocalizedName(String upgradeUnlocalizedName) {
        this.unlocalizedName = upgradeUnlocalizedName;
        return this;
    }

    public SPUpgrade setUpgradeItemsCost(ItemStack ... upgradeItemsCost) {
        this.itemsCost = upgradeItemsCost;
        return this;
    }

    public SPUpgrade setUpgradeFluidsCost(FluidStack ... upgradeFluidsCost) {
        this.fluidsCost = upgradeFluidsCost;
        return this;
    }

    public SPUpgrade setUpgradeRequirements(SPRequirements upgradeRequirements) {
        this.requirements = upgradeRequirements;
        return this;
    }

    public SPUpgrade setUpgradeTotalStages(int upgradeTotalStages) {
        this.totalStages = upgradeTotalStages;
        return this;
    }

    public SPUpgrade setUpgradeBuildTime(int upgradeBuildTime) {
        this.buildTime = upgradeBuildTime;
        return this;
    }

    public SPUpgrade setUpgradeVoltage(long upgradeVoltage) {
        this.voltage = upgradeVoltage;
        return this;
    }

    @Override
    public void setUpgradeProject(ISpaceProject project) {
        this.projectBelongingTo = project;
    }

    @Override
    public void setUpgradeCurrentStage(int stage) {
        this.currentStage = stage;
    }

    @Override
    public boolean meetsRequirements(UUID aTeam) {
        if (this.requirements == null) {
            return true;
        }
        if (this.requirements.getBodyType() != null && !this.requirements.getBodyType().equals((Object)SpaceBodyType.NONE) && !this.requirements.getBodyType().equals((Object)this.projectBelongingTo.getProjectLocation().getType())) {
            return false;
        }
        if (this.requirements.getStarType() != null && !this.requirements.getStarType().equals((Object)this.projectBelongingTo.getProjectLocation().getStarType())) {
            return false;
        }
        if (this.requirements.getProjects() != null) {
            for (ISpaceProject tProject : this.requirements.getProjects()) {
                if (SpaceProjectManager.teamHasProject(aTeam, tProject)) continue;
                return false;
            }
        }
        if (this.requirements.getUpgrades() != null) {
            for (ISpaceProject.ISP_Upgrade upgrade : this.requirements.getUpgrades()) {
                if (this.projectBelongingTo.hasUpgrade(upgrade.getUpgradeName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public SPUpgrade copy() {
        return new SPUpgrade().setUpgradeName(this.name).setUpgradeUnlocalizedName(this.unlocalizedName).setUpgradeBuildTime(this.buildTime).setUpgradeFluidsCost(this.fluidsCost).setUpgradeItemsCost(this.itemsCost).setUpgradeRequirements(this.requirements).setUpgradeTotalStages(this.totalStages).setUpgradeVoltage(this.voltage);
    }

    @Override
    public void goToNextStage() {
        ++this.currentStage;
        if (this.isFinished()) {
            this.projectBelongingTo.setBuiltUpgrade(this);
        }
    }

    @Override
    public boolean isFinished() {
        return this.currentStage == this.totalStages;
    }
}

