/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects;

import com.mojang.authlib.GameProfile;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.common.misc.spaceprojects.SpaceProjectWorldSavedData;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class SpaceProjectManager {
    public static Map<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>> spaceTeamProjects = new HashMap<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>();
    public static Map<UUID, UUID> spaceTeams = new HashMap<UUID, UUID>();
    private static final HashMap<String, ISpaceBody> spaceLocations = new HashMap();
    private static final Map<String, ISpaceProject> spaceProjects = new HashMap<String, ISpaceProject>();

    public static ISpaceProject getTeamProject(UUID member, ISpaceBody location, String projectName) {
        Map<Pair<ISpaceBody, String>, ISpaceProject> map = spaceTeamProjects.get(SpaceProjectManager.getLeader(member));
        if (map == null) {
            return null;
        }
        return map.get(Pair.of((Object)location, (Object)projectName));
    }

    public static boolean addTeamProject(UUID member, ISpaceBody location, String projectName, ISpaceProject project) {
        Map<Pair<ISpaceBody, String>, ISpaceProject> map;
        if (!spaceTeamProjects.containsKey(SpaceProjectManager.getLeader(member)) || spaceTeamProjects.get(SpaceProjectManager.getLeader(member)) == null) {
            spaceTeamProjects.put(SpaceProjectManager.getLeader(member), new HashMap());
        }
        if ((map = spaceTeamProjects.get(SpaceProjectManager.getLeader(member))).containsKey(Pair.of((Object)location, (Object)projectName))) {
            return false;
        }
        project.setProjectLocation(location);
        map.put((Pair<ISpaceBody, String>)Pair.of((Object)location, (Object)projectName), project);
        if (SpaceProjectWorldSavedData.INSTANCE != null) {
            SpaceProjectWorldSavedData.INSTANCE.func_76185_a();
        }
        return true;
    }

    public static boolean teamHasProject(UUID member, ISpaceProject project) {
        Map<Pair<ISpaceBody, String>, ISpaceProject> map = spaceTeamProjects.get(SpaceProjectManager.getLeader(member));
        if (map == null) {
            return false;
        }
        return map.containsValue(project);
    }

    public static void putInTeam(UUID teamMember, UUID teamLeader) {
        if (teamMember.equals(teamLeader)) {
            spaceTeams.put(teamMember, teamLeader);
        } else if (!spaceTeams.get(teamLeader).equals(teamLeader)) {
            SpaceProjectManager.putInTeam(teamMember, spaceTeams.get(teamLeader));
        } else {
            spaceTeams.put(teamMember, teamLeader);
        }
        if (SpaceProjectWorldSavedData.INSTANCE != null) {
            SpaceProjectWorldSavedData.INSTANCE.func_76185_a();
        }
    }

    public static UUID getLeader(UUID teamMember) {
        SpaceProjectManager.checkOrCreateTeam(teamMember);
        return spaceTeams.get(teamMember);
    }

    public static void checkOrCreateTeam(UUID teamMember) {
        if (spaceTeams.containsKey(teamMember)) {
            return;
        }
        spaceTeams.put(teamMember, teamMember);
        if (SpaceProjectWorldSavedData.INSTANCE != null) {
            SpaceProjectWorldSavedData.INSTANCE.func_76185_a();
        }
    }

    public static boolean isInTeam(UUID member) {
        return spaceTeams.containsKey(member);
    }

    public static HashSet<UUID> getTeamMembers(UUID leader) {
        HashSet<UUID> inTeam = new HashSet<UUID>();
        spaceTeams.forEach((key, value) -> {
            if (Objects.equals(leader, value)) {
                inTeam.add((UUID)key);
            }
        });
        return inTeam;
    }

    public static Collection<ISpaceProject> getTeamSpaceProjects(UUID member) {
        Map<Pair<ISpaceBody, String>, ISpaceProject> map = spaceTeamProjects.get(SpaceProjectManager.getLeader(member));
        if (map == null) {
            return null;
        }
        return map.values();
    }

    public static ISpaceProject getTeamProjectOrCopy(UUID member, String projectName, ISpaceBody location) {
        Map<Pair<ISpaceBody, String>, ISpaceProject> map = spaceTeamProjects.get(SpaceProjectManager.getLeader(member));
        if (map == null) {
            return SpaceProjectManager.getProject(projectName);
        }
        return map.getOrDefault(Pair.of((Object)location, (Object)projectName), SpaceProjectManager.getProject(projectName));
    }

    public static void addProject(ISpaceProject project) {
        spaceProjects.put(project.getProjectName(), project);
        RecipeMaps.spaceProjectFakeRecipes.add(new FakeSpaceProjectRecipe(false, project.getTotalItemsCost(), project.getTotalFluidsCost(), project.getProjectBuildTime(), (int)project.getProjectVoltage(), project.getTotalStages(), project.getProjectName()));
    }

    public static ISpaceProject getProject(String projectName) {
        ISpaceProject tProject = spaceProjects.get(projectName);
        return tProject != null ? tProject.copy() : null;
    }

    public static Map<String, ISpaceProject> getProjectsMap() {
        return spaceProjects;
    }

    public static Collection<ISpaceProject> getAllProjects() {
        return spaceProjects.values();
    }

    public static void addLocation(ISpaceBody location) {
        spaceLocations.put(location.getName(), location);
    }

    public static Collection<ISpaceBody> getLocations() {
        return spaceLocations.values();
    }

    public static Collection<String> getLocationNames() {
        return spaceLocations.keySet();
    }

    public static ISpaceBody getLocation(String locationName) {
        return spaceLocations.get(locationName);
    }

    public static UUID getPlayerUUIDFromName(String playerName) {
        return MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(playerName).getId();
    }

    public static String getPlayerNameFromUUID(UUID playerUUID) {
        GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(playerUUID);
        return profile == null ? "ERROR_NULL_PROFILE" : profile.getName();
    }

    public static class FakeSpaceProjectRecipe
    extends GTRecipe {
        public final String projectName;

        public FakeSpaceProjectRecipe(boolean aOptimize, ItemStack[] aInputs, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, String projectName) {
            super(aOptimize, aInputs, null, null, null, aFluidInputs, null, aDuration, aEUt, aSpecialValue);
            this.projectName = projectName;
        }
    }
}

