/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class BehaviourProspecting
extends BehaviourNone {
    private final int mVanillaCosts;
    private final int mEUCosts;
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.prospecting", "Usable for Prospecting");

    public BehaviourProspecting(int aVanillaCosts, int aEUCosts) {
        this.mVanillaCosts = aVanillaCosts;
        this.mEUCosts = aEUCosts;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        ItemData tAssociation = GTOreDictUnificator.getAssociation(new ItemStack(aBlock, 1, (int)aMeta));
        if (tAssociation != null && tAssociation.mPrefix != null && tAssociation.mMaterial != null && tAssociation.mPrefix.toString().startsWith("ore")) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("100", "This is ") + tAssociation.mMaterial.mMaterial.mDefaultLocalName + GTUtility.trans("101", " Ore."));
            GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, (double)hitX, (double)hitY, (double)hitZ);
            return true;
        }
        if ((aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockStones) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockGranites) || aBlock == GregTechAPI.sBlockOresUb1 || aBlock == GregTechAPI.sBlockOresUb2 || aBlock == GregTechAPI.sBlockOresUb3 || aBlock == GregTechAPI.sBlockOres1) && GTModHandler.damageOrDechargeItem(aStack, this.mVanillaCosts, this.mEUCosts, (EntityLivingBase)aPlayer)) {
            Block tBlock;
            GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, (double)hitX, (double)hitY, (double)hitZ);
            int tQuality = aItem instanceof MetaGeneratedTool ? aItem.getHarvestLevel(aStack, "") : 0;
            int tX = aX;
            int tY = aY;
            int tZ = aZ;
            int j = 6 + tQuality;
            for (int i = 0; i < j; ++i) {
                tBlock = aWorld.func_147439_a(tX -= side.offsetX, tY -= side.offsetY, tZ -= side.offsetZ);
                if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                    GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("102", "There is Lava behind this Rock."));
                    break;
                }
                if (tBlock instanceof BlockLiquid || tBlock instanceof IFluidBlock) {
                    GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("103", "There is a Liquid behind this Rock."));
                    break;
                }
                if (tBlock == Blocks.field_150418_aU || !GTUtility.hasBlockHitBox(aWorld, tX, tY, tZ)) {
                    GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("104", "There is an Air Pocket behind this Rock."));
                    break;
                }
                if (tBlock == aBlock) continue;
                if (i >= 4) break;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("105", "Material is changing behind this Rock."));
                break;
            }
            XSTR tRandom = new XSTR(aX ^ aY ^ aZ ^ side.ordinal());
            int j2 = 9 + 2 * tQuality;
            for (int i = 0; i < j2; ++i) {
                tX = aX - 4 - tQuality + ((Random)tRandom).nextInt(j2);
                tBlock = aWorld.func_147439_a(tX, tY = aY - 4 - tQuality + ((Random)tRandom).nextInt(j2), tZ = aZ - 4 - tQuality + ((Random)tRandom).nextInt(j2));
                if (tBlock instanceof BlockOresAbstract) {
                    Materials tMaterial;
                    TileEntity tTileEntity = aWorld.func_147438_o(tX, tY, tZ);
                    if (!(tTileEntity instanceof TileEntityOres) || (tMaterial = GregTechAPI.sGeneratedMaterials[((TileEntityOres)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                    GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("106", "Found traces of ") + tMaterial.mDefaultLocalName + GTUtility.trans("101", " Ore."));
                    return true;
                }
                int tMetaID = aWorld.func_72805_g(tX, tY, tZ);
                tAssociation = GTOreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
                if (tAssociation == null || tAssociation.mPrefix == null || tAssociation.mMaterial == null || !tAssociation.mPrefix.toString().startsWith("ore")) continue;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("106", "Found traces of ") + tAssociation.mMaterial.mMaterial.mDefaultLocalName + GTUtility.trans("101", " Ore."));
                return true;
            }
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("107", "No Ores found."));
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

