/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityItemPipe;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourPlungerItem
extends BehaviourNone {
    private final int mCosts;
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.plunger.item", "Clears Items from Pipes");

    public BehaviourPlungerItem(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        IGregTechTileEntity gtTE;
        IMetaTileEntity tMetaTileEntity;
        if (aWorld.field_72995_K) {
            return false;
        }
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IGregTechTileEntity && (tMetaTileEntity = (gtTE = (IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof IMetaTileEntityItemPipe) {
            for (IMetaTileEntityItemPipe tTileEntity : GTUtility.sortMapByValuesAcending(IMetaTileEntityItemPipe.Util.scanPipes((IMetaTileEntityItemPipe)tMetaTileEntity, new HashMap<IMetaTileEntityItemPipe, Long>(), 0L, false, true)).keySet()) {
                int j = tTileEntity.func_70302_i_();
                for (int i = 0; i < j; ++i) {
                    if (!tTileEntity.isValidSlot(i) || tTileEntity.func_70301_a(i) == null || !aPlayer.field_71075_bZ.field_75098_d && !((MetaGeneratedTool)aItem).doDamage(aStack, this.mCosts)) continue;
                    ItemStack tStack = tTileEntity.func_70298_a(i, 64);
                    if (tStack != null) {
                        EntityItem tEntity = new EntityItem(aWorld, (double)gtTE.getOffsetX(side, 1) + 0.5, (double)gtTE.getOffsetY(side, 1) + 0.5, (double)gtTE.getOffsetZ(side, 1) + 0.5, tStack);
                        tEntity.field_70159_w = 0.0;
                        tEntity.field_70181_x = 0.0;
                        tEntity.field_70179_y = 0.0;
                        aWorld.func_72838_d((Entity)tEntity);
                        GTUtility.sendSoundToPlayers(aWorld, SoundResource.GTCEU_OP_PLUNGER, 1.0f, -1.0f, (double)hitX, (double)hitY, (double)hitZ);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

