/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.covers.CoverContext;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.tileentities.storage.MTEDigitalTankBase;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverFluidStorageMonitor
extends Cover {
    private static final IIconContainer[] icons = new IIconContainer[]{Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR0, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR1, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR2, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR3, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR4, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR5, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR6, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR7, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR8, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR9, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR10, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR11, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR12, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR13, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR14};
    private ForgeDirection fluidLookupSide = ForgeDirection.UNKNOWN;
    private int slot = 0;
    private Fluid fluid = null;
    private int scale = 0;
    private boolean dirty = false;

    public CoverFluidStorageMonitor(CoverContext context) {
        super(context, null);
    }

    public CoverFluidStorageMonitor setSide(ForgeDirection coverSide) {
        this.fluidLookupSide = coverSide;
        return this;
    }

    public CoverFluidStorageMonitor setSlot(int slot) {
        if (this.slot != slot) {
            if (this.slot == -1 || slot == -1) {
                this.dirty = true;
            }
            this.slot = slot;
        }
        return this;
    }

    public CoverFluidStorageMonitor disable() {
        this.setSlot(-1);
        return this;
    }

    public CoverFluidStorageMonitor setFluid(@Nullable Fluid fluid) {
        if (!Util.areFluidsEqual(this.fluid, fluid)) {
            this.fluid = fluid;
            this.dirty = true;
        }
        return this;
    }

    public CoverFluidStorageMonitor setFluid(@Nullable FluidStack fluidStack) {
        Fluid fluid = fluidStack == null ? null : fluidStack.getFluid();
        return this.setFluid(fluid);
    }

    public CoverFluidStorageMonitor setScale(int scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.dirty = true;
        }
        return this;
    }

    public CoverFluidStorageMonitor setNullTank() {
        return this.setFluid((Fluid)null).setScale(0);
    }

    public CoverFluidStorageMonitor issueCoverUpdateIfNeeded(ICoverable tileEntity, ForgeDirection coverSide) {
        if (this.dirty) {
            tileEntity.issueCoverUpdate(coverSide);
            this.dirty = false;
        }
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.fluidLookupSide = ForgeDirection.getOrientation((int)tag.func_74771_c("coverSide"));
        this.slot = tag.func_74762_e("slot");
        this.fluid = Util.getFluid(tag.func_74779_i("fluidName"));
        this.scale = tag.func_74762_e("scale");
        this.dirty = tag.func_74767_n("dirty");
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.fluidLookupSide = ForgeDirection.getOrientation((int)byteData.readByte());
        this.slot = byteData.readInt();
        this.fluid = Util.getFluid(byteData.readInt());
        this.scale = byteData.readInt();
        this.dirty = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("coverSide", (byte)this.fluidLookupSide.ordinal());
        tag.func_74768_a("slot", this.slot);
        tag.func_74778_a("fluidName", Util.getFluidName(this.fluid));
        tag.func_74768_a("scale", this.scale);
        tag.func_74757_a("dirty", this.dirty);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.fluidLookupSide.ordinal());
        byteBuf.writeInt(this.slot);
        byteBuf.writeInt(Util.getFluidID(this.fluid));
        byteBuf.writeInt(this.scale);
        byteBuf.writeBoolean(this.dirty);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        FluidTankInfo tank;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        FluidTankInfo[] tanks = CoverFluidStorageMonitor.getValidFluidTankInfosForDisplay(coverable, this.fluidLookupSide);
        if (tanks == null) {
            this.disable().issueCoverUpdateIfNeeded(coverable, this.coverSide);
            return;
        }
        assert (0 < tanks.length);
        if (this.slot < 0 || tanks.length <= this.slot) {
            this.setSlot(0);
        }
        if ((tank = tanks[this.slot]) == null) {
            this.setNullTank().issueCoverUpdateIfNeeded(coverable, this.coverSide);
            return;
        }
        this.setFluid(tank.fluid).setScale(CoverFluidStorageMonitor.getTankScale(tank)).issueCoverUpdateIfNeeded(coverable, this.coverSide);
    }

    @Override
    public ITexture getOverlayTexture() {
        return this.getSpecialFaceTexture();
    }

    @Override
    public ITexture getSpecialFaceTexture() {
        if (this.slot == -1 || this.fluid == null || this.scale == 0) {
            return TextureFactory.of(Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR0);
        }
        IIconContainer fluidIcon = new IIconContainer(){

            @Override
            public IIcon getIcon() {
                return CoverFluidStorageMonitor.this.fluid.getStillIcon();
            }

            @Override
            public IIcon getOverlayIcon() {
                return null;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return TextureMap.field_110575_b;
            }
        };
        short[] fluidRGBA = this.colorToRGBA(this.fluid.getColor());
        ITextureBuilder fluidTextureBuilder = TextureFactory.builder().addIcon(fluidIcon).setRGBA(fluidRGBA);
        if (this.fluid.getLuminosity() > 0) {
            fluidTextureBuilder.glow();
        }
        return TextureFactory.of(fluidTextureBuilder.build(), TextureFactory.of(icons[this.scale]));
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null || aPlayer == null || aPlayer.field_70170_p == null || aPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack heldItem = aPlayer.func_70694_bm();
        if (aPlayer.func_70093_af() || heldItem == null) {
            return false;
        }
        FluidTankInfo[] tanks = CoverFluidStorageMonitor.getValidFluidTankInfos(coverable, this.fluidLookupSide);
        if (tanks == null) {
            return false;
        }
        if (this.slot < 0 || tanks.length <= this.slot) {
            return false;
        }
        FluidTankInfo tank = tanks[this.slot];
        if (tank == null) {
            return false;
        }
        IFluidHandler tankHandler = (IFluidHandler)coverable;
        ItemStack heldItemSizedOne = GTUtility.copyAmount(1, heldItem);
        if (heldItemSizedOne == null || heldItemSizedOne.field_77994_a <= 0) {
            return false;
        }
        ItemStack result = CoverFluidStorageMonitor.fillToTank(heldItemSizedOne, tankHandler, this.fluidLookupSide);
        if (result != null) {
            CoverFluidStorageMonitor.replaceHeldItemStack(aPlayer, heldItem, result);
            return true;
        }
        result = CoverFluidStorageMonitor.fillToContainer(heldItemSizedOne, tank, tankHandler, this.fluidLookupSide);
        if (result != null) {
            CoverFluidStorageMonitor.replaceHeldItemStack(aPlayer, heldItem, result);
            return true;
        }
        return false;
    }

    protected static ItemStack fillToTank(@Nonnull ItemStack container, @Nonnull IFluidHandler tank, ForgeDirection coverSide) {
        FluidStack fluidToFill = GTUtility.getFluidForFilledItem(container, true);
        if (fluidToFill == null || fluidToFill.getFluid() == null || fluidToFill.amount <= 0) {
            return null;
        }
        if (!tank.canFill(coverSide, fluidToFill.getFluid())) {
            return null;
        }
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            int filled = tank.fill(coverSide, fluidToFill, true);
            if (filled == 0) {
                return null;
            }
            containerItem.drain(container, filled, true);
            return container;
        }
        int filled = tank.fill(coverSide, fluidToFill, false);
        if (filled != fluidToFill.amount) {
            return null;
        }
        tank.fill(coverSide, fluidToFill, true);
        return GTUtility.getContainerForFilledItem(container, false);
    }

    protected static ItemStack fillToContainer(@Nonnull ItemStack container, @Nonnull FluidTankInfo tankInfo, @Nonnull IFluidHandler tank, ForgeDirection coverSide) {
        if (tankInfo.fluid == null || tankInfo.fluid.getFluid() == null || tankInfo.fluid.amount <= 0) {
            return null;
        }
        if (!tank.canDrain(coverSide, tankInfo.fluid.getFluid())) {
            return null;
        }
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            int filled = Math.min(Optional.ofNullable(tank.drain(coverSide, new FluidStack(tankInfo.fluid.getFluid(), containerItem.getCapacity(container)), false)).filter(fs -> GTUtility.areFluidsEqual(fs, tankInfo.fluid)).map(fs -> fs.amount).orElse(0), containerItem.fill(container, new FluidStack(tankInfo.fluid.getFluid(), containerItem.getCapacity(container)), false));
            if (filled == 0) {
                return null;
            }
            containerItem.fill(container, new FluidStack(tankInfo.fluid.getFluid(), filled), true);
            tank.drain(coverSide, new FluidStack(tankInfo.fluid.getFluid(), filled), true);
            return container;
        }
        ItemStack filledContainer = GTUtility.fillFluidContainer(tankInfo.fluid, container, false, false);
        if (filledContainer == null) {
            return null;
        }
        FluidStack filledFluid = GTUtility.getFluidForFilledItem(filledContainer, false);
        if (filledFluid == null || filledFluid.getFluid() == null || filledFluid.amount <= 0) {
            return null;
        }
        if (Optional.ofNullable(tank.drain(coverSide, filledFluid, false)).filter(fs -> GTUtility.areFluidsEqual(fs, filledFluid)).map(fs -> fs.amount).orElse(0) != filledFluid.amount) {
            return null;
        }
        tank.drain(coverSide, filledFluid, true);
        return filledContainer;
    }

    protected static void replaceHeldItemStack(@Nonnull EntityPlayer player, @Nonnull ItemStack heldItem, @Nonnull ItemStack result) {
        --heldItem.field_77994_a;
        GTUtility.addItemToPlayerInventory(player, result);
        player.field_71069_bz.func_75142_b();
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.setSide(ForgeDirection.values()[(this.fluidLookupSide.ordinal() + 1) % ForgeDirection.values().length]).setSlot(0);
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("SIDE", "Side: ") + this.fluidLookupSide.name());
            return;
        }
        FluidTankInfo[] tanks = CoverFluidStorageMonitor.getValidFluidTankInfos((ICoverable)this.coveredTile.get(), this.fluidLookupSide);
        if (tanks == null) {
            this.disable();
            return;
        }
        assert (0 < tanks.length);
        if (this.slot < 0 || tanks.length <= this.slot) {
            this.setSlot(0);
        } else {
            this.setSlot((this.slot + tanks.length + (aPlayer.func_70093_af() ? -1 : 1)) % tanks.length);
        }
        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("053", "Slot: ") + this.slot);
    }

    @Override
    public boolean isDataNeededOnClient() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 10;
    }

    @Nullable
    protected static FluidTankInfo[] getValidFluidTankInfos(@Nullable ICoverable tileEntity, @Nonnull ForgeDirection coverSide) {
        FluidTankInfo[] tanks;
        if (tileEntity instanceof IFluidHandler && (tanks = ((IFluidHandler)tileEntity).getTankInfo(coverSide)) != null && tanks.length > 0) {
            return tanks;
        }
        return null;
    }

    @Nullable
    protected static FluidTankInfo[] getValidFluidTankInfosForDisplay(@Nullable ICoverable tileEntity, @Nonnull ForgeDirection coverSide) {
        IGregTechTileEntity baseMetaTileEntity;
        IMetaTileEntity iMetaTileEntity;
        if (tileEntity instanceof IGregTechTileEntity && (iMetaTileEntity = (baseMetaTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MTEDigitalTankBase) {
            MTEDigitalTankBase digitalTank = (MTEDigitalTankBase)iMetaTileEntity;
            return digitalTank.getRealTankInfo(coverSide);
        }
        return CoverFluidStorageMonitor.getValidFluidTankInfos(tileEntity, coverSide);
    }

    protected static int getTankScale(@Nonnull FluidTankInfo tank) {
        if (tank.fluid == null || tank.capacity <= 0) {
            return 0;
        }
        return (int)Math.ceil((double)tank.fluid.amount / (double)tank.capacity * (double)(icons.length - 1));
    }

    protected short[] colorToRGBA(int color) {
        return new short[]{(short)(color >> 16 & 0xFF), (short)(color >> 8 & 0xFF), (short)(color & 0xFF), 255};
    }

    protected static class Util {
        protected Util() {
        }

        public static int getFluidID(@Nullable Fluid fluid) {
            return fluid == null ? -1 : fluid.getID();
        }

        public static String getFluidName(@Nullable Fluid fluid) {
            return fluid == null ? "" : fluid.getName();
        }

        public static Fluid getFluid(int id) {
            return id == -1 ? null : FluidRegistry.getFluid((int)id);
        }

        public static Fluid getFluid(String name) {
            return name.isEmpty() ? null : FluidRegistry.getFluid((String)name);
        }

        public static boolean areFluidsEqual(@Nullable Fluid a, @Nullable Fluid b) {
            return Util.getFluidID(a) == Util.getFluidID(b);
        }
    }
}

