/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import com.cleanroommc.modularui.network.NetworkUtils;
import gregtech.api.recipe.check.CheckRecipeResult;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class ResultMissingApiaryFlowers
implements CheckRecipeResult {
    protected final Set<String> missingFlowerTypes;

    public ResultMissingApiaryFlowers() {
        this(new HashSet<String>());
    }

    protected ResultMissingApiaryFlowers(Set<String> missingFlowerTypes) {
        this.missingFlowerTypes = missingFlowerTypes;
    }

    @NotNull
    public static CheckRecipeResult newFailure(@NotNull Map<String, String> flowerCheckingMap) {
        return new ResultMissingApiaryFlowers(new HashSet<String>(flowerCheckingMap.values()));
    }

    @Override
    public boolean wasSuccessful() {
        return false;
    }

    @Override
    @NotNull
    public String getID() {
        return "apiary_missing_flowers";
    }

    @Override
    @NotNull
    public String getDisplayString() {
        String flowers = String.join((CharSequence)", ", this.missingFlowerTypes);
        return StatCollector.func_74837_a((String)"GT5U.gui.text.apiary_missing_flowers", (Object[])new Object[]{flowers});
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        NBTTagList flowerTypeList = new NBTTagList();
        for (String flowerType : this.missingFlowerTypes) {
            flowerTypeList.func_74742_a((NBTBase)new NBTTagString(flowerType));
        }
        tag.func_74782_a("missingFlowers", (NBTBase)flowerTypeList);
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        NBTTagList flowerTypeList = tag.func_150295_c("missingFlowers", 8);
        for (int i = 0; i < flowerTypeList.func_74745_c(); ++i) {
            String flowerType = flowerTypeList.func_150307_f(i);
            this.missingFlowerTypes.add(flowerType);
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult newInstance() {
        return new ResultMissingApiaryFlowers();
    }

    @Override
    public void encode(@NotNull PacketBuffer buffer) {
        buffer.writeInt(this.missingFlowerTypes.size());
        for (String missingFlowerType : this.missingFlowerTypes) {
            NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)missingFlowerType);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.missingFlowerTypes.clear();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            this.missingFlowerTypes.add(NetworkUtils.readStringSafe((PacketBuffer)buffer));
        }
    }
}

