/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.objects.XSTR;
import java.util.ArrayDeque;

public final class DiscreteDistribution {
    private final XSTR random = XSTR.XSTR_INSTANCE;
    private final int[] alias;
    private final double[] probability;

    public DiscreteDistribution(double[] weights) {
        if (weights == null) {
            throw new NullPointerException();
        }
        if (weights.length == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        this.probability = new double[weights.length];
        this.alias = new int[weights.length];
        double average = 1.0 / (double)weights.length;
        weights = (double[])weights.clone();
        ArrayDeque<Integer> small = new ArrayDeque<Integer>();
        ArrayDeque<Integer> large = new ArrayDeque<Integer>();
        for (int i = 0; i < weights.length; ++i) {
            if (weights[i] >= average) {
                large.add(i);
                continue;
            }
            small.add(i);
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int less = (Integer)small.removeLast();
            int more = (Integer)large.removeLast();
            this.probability[less] = weights[less] * (double)weights.length;
            this.alias[less] = more;
            int n = more;
            weights[n] = weights[n] + (weights[less] - average);
            if (weights[more] >= average) {
                large.add(more);
                continue;
            }
            small.add(more);
        }
        while (!small.isEmpty()) {
            this.probability[((Integer)small.removeLast()).intValue()] = 1.0;
        }
        while (!large.isEmpty()) {
            this.probability[((Integer)large.removeLast()).intValue()] = 1.0;
        }
    }

    public int next() {
        int column = this.random.nextInt(this.probability.length);
        boolean coinToss = this.random.nextDouble() < this.probability[column];
        return coinToss ? column : this.alias[column];
    }
}

