/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.GregTechAPI;
import gregtech.api.items.GTGenericItem;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class ItemCoolantCell
extends GTGenericItem {
    protected final int heatStorage;

    public ItemCoolantCell(String aUnlocalized, String aEnglish, int aMaxStore) {
        super(aUnlocalized, aEnglish, null);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.heatStorage = aMaxStore;
        this.func_77637_a(GregTechAPI.TAB_GREGTECH);
    }

    protected static int getHeatOfStack(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
            aStack.func_77982_d(tNBT);
        }
        return tNBT.func_74762_e("heat");
    }

    protected void setHeatForStack(ItemStack aStack, int aHeat) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
            aStack.func_77982_d(tNBT);
        }
        tNBT.func_74768_a("heat", aHeat);
        if (this.heatStorage > 0) {
            double heatRatio = (double)aHeat / (double)this.heatStorage;
            int damage = (int)((double)aStack.func_77958_k() * heatRatio);
            if (damage >= aStack.func_77958_k()) {
                damage = aStack.func_77958_k() - 1;
            }
            aStack.func_77964_b(damage);
        }
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        EnumChatFormatting enumChatFormatting;
        super.addAdditionalToolTips(aList, aStack, aPlayer);
        int rHeat = ItemCoolantCell.getHeatOfStack(aStack) * 10 / this.heatStorage;
        switch (rHeat) {
            case 0: {
                enumChatFormatting = EnumChatFormatting.BLUE;
                break;
            }
            case 1: 
            case 2: {
                enumChatFormatting = EnumChatFormatting.GREEN;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                enumChatFormatting = EnumChatFormatting.YELLOW;
                break;
            }
            case 7: 
            case 8: {
                enumChatFormatting = EnumChatFormatting.RED;
                break;
            }
            default: {
                enumChatFormatting = EnumChatFormatting.DARK_RED;
            }
        }
        EnumChatFormatting color = enumChatFormatting;
        aList.add(EnumChatFormatting.WHITE + StatCollector.func_74837_a((String)"gt.item.desc.stored_heat", (Object[])new Object[]{"" + color + ItemCoolantCell.getHeatOfStack(aStack)}));
        if (this.getControlTagOfStack(aStack) == 1) {
            aList.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line1"));
            aList.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line2"));
        }
    }

    public int getControlTagOfStack(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        return nbtData.func_74762_e("tag");
    }

    public void setControlTagOfStack(ItemStack stack, int tag) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        nbtData.func_74768_a("tag", tag);
    }
}

