/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.enums.ItemList;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.WirelessComputationPacket;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;

public class MTEHatchWirelessComputationInput
extends MTEHatchDataInput
implements IAddGregtechLogo,
IAddUIWidgets,
IDataCopyable {
    public long requiredComputation = 10000L;
    public static final String COPIED_DATA_IDENTIFIER = "cloudComputationInput";
    private static String[] tooltips;

    public MTEHatchWirelessComputationInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchWirelessComputationInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessComputationInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!aPlayer.func_71039_bw()) {
            this.openGui(aPlayer);
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.q == null) {
            this.q = WirelessComputationPacket.downloadData(aBaseMetaTileEntity.getOwnerUuid(), this.requiredComputation, MinecraftServer.func_71276_C().func_71259_af());
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_TECTECH_LOGO).setSize(18, 18).setPos(151, 63));
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.requiredComputation = aNBT.func_74763_f("requiredComputation");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("requiredComputation", this.requiredComputation);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        if (!this.pasteCopiedData(aPlayer, dataStick.field_77990_d)) {
            return false;
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.gui.text.data_stick.loaded", new Object[0]));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity baseMetaTileEntity, EntityPlayer player) {
        if (!baseMetaTileEntity.isServerSide()) {
            return;
        }
        ItemStack dataStick = player.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return;
        }
        dataStick.field_77990_d = this.getCopiedData(player);
        dataStick.func_151001_c("Cloud Computation Input");
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.gui.text.data_stick.saved", new Object[0]));
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return COPIED_DATA_IDENTIFIER;
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", COPIED_DATA_IDENTIFIER);
        tag.func_74772_a("computation", this.requiredComputation);
        return tag;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        if (nbt == null || !COPIED_DATA_IDENTIFIER.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        this.requiredComputation = nbt.func_74763_f("computation");
        return true;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("requiredComputation", this.requiredComputation);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.machines.computation_hatch.computation") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(accessor.getNBTData().func_74763_f("requiredComputation")));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"tt.wirelessInputData.config.text", (Object[])new Object[0]).setPos(20, 12).setSize(140, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.requiredComputation = val.intValue();
        }).setGetterLong(() -> this.requiredComputation).setNumbers(1, Integer.MAX_VALUE).setOnScrollNumbers(1, 4, 64).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(54, 36).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
    }

    @Override
    public String[] getDescription() {
        if (tooltips == null) {
            tooltips = new String[]{"Wireless Computation Data Input for Multiblocks"};
        }
        return tooltips;
    }
}

