/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTESpargeTower
extends GTPPMultiBlockBase<MTESpargeTower>
implements ISurvivalConstructable {
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    private static final IStructureDefinition<MTESpargeTower> STRUCTURE_DEFINITION;
    protected final List<List<MTEHatchOutput>> mOutputHatchesByLayer = new ArrayList<List<MTEHatchOutput>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;

    public MTESpargeTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESpargeTower(String aName) {
        super(aName);
    }

    public static int getCasingIndex() {
        return 68;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESpargeTower(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Gas Sparge Tower").addInfo("Runs gases through depleted molten salts to extract precious fluids").addInfo("Works the same way as the Distillation Tower, but with a fixed height of 8").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").beginStructureBlock(3, 8, 3, true).addController("Front bottom").addOtherStructurePart("Sparge Tower Exterior Casing", "45 (minimum)").addEnergyHatch("Any casing", 1, 2).addMaintenanceHatch("Any casing", 1, 2, 3).addInputHatch("2x Input Hatches (Any bottom layer casing)", 1).addOutputHatch("6x Output Hatches (At least one per layer except bottom layer)", 2, 3).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCASpargeTowerActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCASpargeTowerActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCASpargeTower;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCASpargeTowerGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return MTESpargeTower.getCasingIndex();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.spargeTowerRecipes;
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    private static FluidStack[] randomizeByproducts(FluidStack[] outputFluids, int maximum, FluidStack spargeGas) {
        int byproductTotal = 0;
        for (int i = 2; i < outputFluids.length; ++i) {
            int gasAmount = MathUtils.randInt(1, Math.min(maximum, spargeGas.amount - byproductTotal - 1));
            outputFluids[i] = new FluidStack(outputFluids[i], gasAmount);
            byproductTotal += gasAmount;
        }
        outputFluids[1] = new FluidStack(spargeGas, spargeGas.amount - byproductTotal);
        return outputFluids;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(this.modifyRecipe(recipe));
            }

            private GTRecipe modifyRecipe(GTRecipe recipe) {
                GTRecipe newRecipe = recipe.copy();
                newRecipe.mFluidOutputs = MTESpargeTower.randomizeByproducts(recipe.mFluidOutputs, recipe.getMetadataOrDefault(GTRecipeConstants.SPARGE_MAX_BYPRODUCT, 0), recipe.mFluidInputs[0]);
                return newRecipe;
            }
        };
    }

    protected void onTopLayerFound(boolean aIsCasing) {
        this.mTopLayerFound = true;
        if (aIsCasing) {
            this.onCasingFound();
        }
    }

    protected int getCurrentLayerOutputHatchCount() {
        return this.mOutputHatchesByLayer.size() < this.mHeight || this.mHeight <= 0 ? 0 : this.mOutputHatchesByLayer.get(this.mHeight - 1).size();
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchOutput tHatch;
        IMetaTileEntity iMetaTileEntity;
        if (aTileEntity != null && !aTileEntity.isDead() && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchOutput) {
            tHatch = (MTEHatchOutput)iMetaTileEntity;
        } else {
            Logger.INFO("Bad Output Hatch");
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        tHatch.updateTexture(aBaseCasingIndex);
        boolean addedHatch = this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch);
        Logger.INFO("Added Hatch: " + addedHatch);
        return addedHatch;
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return this.getFluidOutputSlotsByLayer(toOutput, this.mOutputHatchesByLayer);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public IStructureDefinition<MTESpargeTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            Logger.INFO("Bad Base. Height: " + this.mHeight);
            return false;
        }
        while (this.mHeight < 8 && this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0) && !this.mTopLayerFound) {
            if (this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                Logger.INFO("Height: " + this.mHeight + " - Missing output on " + (this.mHeight - 1));
                return false;
            }
            ++this.mHeight;
        }
        Logger.INFO("Height: " + this.mHeight);
        Logger.INFO("Casings: " + this.mCasing);
        Logger.INFO("Required: " + (7 * this.mHeight - 5));
        Logger.INFO("Found Top: " + this.mTopLayerFound);
        return this.mCasing >= 45 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    protected void addFluidOutputs(FluidStack[] outputFluids) {
        for (int i = 0; i < outputFluids.length && i < this.mOutputHatchesByLayer.size(); ++i) {
            FluidStack tStack;
            FluidStack fluidStack = tStack = outputFluids[i] != null ? outputFluids[i].copy() : null;
            if (tStack == null || MTESpargeTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, true)) continue;
            MTESpargeTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, false);
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = 8;
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.mHeight = 0;
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 1, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalHeight = 8;
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.mHeight = i;
            built = this.survivalBuildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, 1, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        this.mHeight = tTotalHeight - 1;
        return this.survivalBuildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, 1, tTotalHeight - 1, 0, elementBudget, env, false, true);
    }

    @Override
    public String getMachineType() {
        return "Gas Sparger";
    }

    @Override
    public boolean onPlungerRightClick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        int aLayerIndex = 0;
        GTUtility.sendChatToPlayer(aPlayer, "Trying to clear " + this.mOutputHatchesByLayer.size() + " layers of output hatches.");
        for (List<MTEHatchOutput> layer : this.mOutputHatchesByLayer) {
            int aHatchIndex = 0;
            for (MTEHatchOutput hatch : layer) {
                if (hatch.mFluid != null) {
                    GTUtility.sendChatToPlayer(aPlayer, "Clearing " + hatch.mFluid.amount + "L of " + hatch.mFluid.getLocalizedName() + " from hatch " + aHatchIndex + " on layer " + aLayerIndex + ".");
                    hatch.mFluid = null;
                }
                ++aHatchIndex;
            }
            ++aLayerIndex;
        }
        return aLayerIndex > 0;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
    }

    static {
        IHatchElement<MTESpargeTower> layeredOutputHatch = HatchElement.OutputHatch.withCount(MTESpargeTower::getCurrentLayerOutputHatchCount).withAdder(MTESpargeTower::addLayerOutputHatch);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape(STRUCTURE_PIECE_LAYER, StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape(STRUCTURE_PIECE_LAYER_HINT, StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape(STRUCTURE_PIECE_TOP_HINT, StructureUtility.transpose((String[][])new String[][]{{"lll", "lll", "lll"}})).addElement('b', GTStructureUtility.buildHatchAdder(MTESpargeTower.class).atLeast(HatchElement.Energy, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.Maintenance).disallowOnly(ForgeDirection.UP).casingIndex(MTESpargeTower.getCasingIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(MTESpargeTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4)))).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESpargeTower.class).atLeast(layeredOutputHatch).disallowOnly(ForgeDirection.UP, ForgeDirection.DOWN).casingIndex(MTESpargeTower.getCasingIndex()).dot(2).build(), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addEnergyInputToMachineList, MTESpargeTower.getCasingIndex(), 2), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMaintenanceToMachineList, MTESpargeTower.getCasingIndex(), 2), StructureUtility.onElementPass(MTESpargeTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4))})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addOutputToMachineList, MTESpargeTower.getCasingIndex(), 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMaintenanceToMachineList, MTESpargeTower.getCasingIndex(), 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(true), (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4)), StructureUtility.isAir()})).build();
    }
}

