/*
 * Decompiled with CFR 0.152.
 */
package gregtech.crossmod.navigator;

import com.gtnewhorizons.navigator.api.journeymap.waypoints.JMWaypointManager;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalInteractableRenderer;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import com.gtnewhorizons.navigator.api.xaero.waypoints.XaeroWaypointManager;
import gregtech.GTMod;
import gregtech.common.data.GTPowerfailTracker;
import gregtech.crossmod.navigator.PowerfailButtonManager;
import gregtech.crossmod.navigator.PowerfailLocationWrapper;
import gregtech.crossmod.navigator.PowerfailRenderStep;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerfailLayerManager
extends InteractableLayerManager {
    public static final PowerfailLayerManager INSTANCE = new PowerfailLayerManager();
    private final Long2ObjectLinkedOpenHashMap<PowerfailLocationWrapper> wrappers = new Long2ObjectLinkedOpenHashMap();

    private PowerfailLayerManager() {
        super((ButtonManager)new PowerfailButtonManager());
        this.setHasSearchField(true);
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(InteractableLayerManager manager, SupportedMods mod) {
        return new UniversalInteractableRenderer(manager).withRenderStep(location -> new PowerfailRenderStep((PowerfailLocationWrapper)location));
    }

    @Nullable
    protected WaypointManager addWaypointManager(InteractableLayerManager manager, SupportedMods mod) {
        JMWaypointManager jMWaypointManager;
        switch (mod) {
            case JourneyMap: {
                jMWaypointManager = new JMWaypointManager(manager);
                break;
            }
            case XaeroWorldMap: {
                jMWaypointManager = new XaeroWaypointManager(manager, "!");
                break;
            }
            default: {
                jMWaypointManager = null;
            }
        }
        return jMWaypointManager;
    }

    public void onUpdatePost(int chunkMinX, int chunkMaxX, int chunkMinZ, int chunkMaxZ) {
        super.onUpdatePost(chunkMinX, chunkMaxX, chunkMinZ, chunkMaxZ);
        ObjectCollection pfs = GTMod.clientProxy().powerfailRenderer.powerfails.values();
        for (GTPowerfailTracker.Powerfail p : pfs) {
            long coord = p.getCoord();
            PowerfailLocationWrapper w = (PowerfailLocationWrapper)this.wrappers.get(coord);
            if (w == null) {
                w = new PowerfailLocationWrapper(p);
                this.wrappers.put(coord, (Object)w);
            }
            this.updateElement(w);
            this.getVisibleLocations().add(w);
        }
        LinkedHashSet locs = new LinkedHashSet(this.wrappers.values());
        this.layerRenderer.values().forEach(layer -> layer.refreshVisibleElements(locs));
    }

    public void onSearch(@NotNull String searchString) {
        super.onSearch(searchString);
        if (searchString.isEmpty()) {
            for (PowerfailLocationWrapper wrapper : this.wrappers.values()) {
                wrapper.highlighted = true;
            }
        } else {
            String[] tokens = searchString.toLowerCase().split("\\s+");
            block1: for (PowerfailLocationWrapper wrapper : this.wrappers.values()) {
                wrapper.highlighted = true;
                for (String token : tokens) {
                    if (wrapper.mteName.contains(token)) continue;
                    wrapper.highlighted = false;
                    continue block1;
                }
            }
        }
    }

    public void removePowerfail(long coord) {
        if (this.getCurrentDimCache().getOrDefault(coord, null) != null) {
            this.removeLocation(coord);
        }
        if (this.wrappers.containsKey(coord)) {
            this.wrappers.remove(coord);
        }
    }
}

