/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverFluidfilter;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerSlotWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.CoverUIFactory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterUIFactory
extends CoverUIFactory<CoverFluidfilter> {
    private static final int startX = 10;
    private static final int startY = 25;
    private static final int spaceX = 18;
    private static final int spaceY = 18;

    public FluidFilterUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected CoverFluidfilter adaptCover(Cover cover) {
        if (cover instanceof CoverFluidfilter) {
            CoverFluidfilter adapterCover = (CoverFluidfilter)cover;
            return adapterCover;
        }
        return null;
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<CoverFluidfilter>(this::getCover, (id, coverData) -> !this.getClickable((int)id, coverData.getFilterMode()), (id, coverData) -> coverData.setFilterMode(this.getNewFilterMode((int)id, coverData.getFilterMode())), this.getUIBuildContext()).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GTUtility.trans("232", "Filter Input")).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GTUtility.trans("233", "Filter Output")).setPos(18, 0)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLOCK_INPUT).addTooltip(GTUtility.trans("234", "Block Output")).setPos(0, 36)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_ALLOW_INPUT).addTooltip(GTUtility.trans("235", "Allow Output")).setPos(18, 36)).addToggleButton(4, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(GTUtility.trans("236", "Whitelist Fluid")).setPos(0, 18)).addToggleButton(5, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLACKLIST).addTooltip(GTUtility.trans("237", "Blacklist Fluid")).setPos(18, 18)).addFollower(new CoverDataFollowerSlotWidget<CoverFluidfilter>((IItemHandlerModifiable)new ItemStackHandler(), 0, true){

            protected void putClickedStack(ItemStack stack, int mouseButton) {
                if (stack != null && GTUtility.getFluidFromContainerOrFluidDisplay(stack) == null) {
                    return;
                }
                super.putClickedStack(GTUtility.getFluidDisplayStack(GTUtility.getFluidFromContainerOrFluidDisplay(stack), false), mouseButton);
            }
        }, this::getFluidDisplayItem, (coverData, stack) -> {
            if (stack == null) {
                coverData.setFluidId(-1);
            } else {
                FluidStack fluid = GTUtility.getFluidFromDisplayStack(stack);
                if (fluid != null && fluid.getFluid() != null) {
                    coverData.setFluidId(fluid.getFluid().getID());
                }
            }
            return coverData;
        }, widget -> widget.setBackground(new IDrawable[]{ModularUITextures.FLUID_SLOT}).setPos(0, 56)).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("238", "Filter Direction")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 28))).widget(new TextWidget(GTUtility.trans("239", "Filter Type")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 46))).widget(new TextWidget(GTUtility.trans("240", "Block Flow")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 64))).widget(TextWidget.dynamicString(() -> {
            ItemStack fluidDisplay;
            CoverFluidfilter cover = (CoverFluidfilter)this.getCover();
            if (cover != null && (fluidDisplay = this.getFluidDisplayItem(cover)) != null) {
                return fluidDisplay.func_82833_r();
            }
            return GTUtility.trans("315", "Filter Empty");
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TITLE.get()).intValue()).setPos(31, 83));
    }

    private int getNewFilterMode(int id, int filterMode) {
        int n;
        switch (id) {
            case 0: {
                n = filterMode & 3;
                break;
            }
            case 1: {
                n = filterMode | 4;
                break;
            }
            case 2: {
                n = filterMode & 5;
                break;
            }
            case 3: {
                n = filterMode | 2;
                break;
            }
            case 4: {
                n = filterMode & 6;
                break;
            }
            case 5: {
                n = filterMode | 1;
                break;
            }
            default: {
                n = filterMode;
            }
        }
        return n;
    }

    private boolean getClickable(int id, int filterMode) {
        boolean bl;
        switch (id) {
            case 0: 
            case 1: {
                if ((filterMode >> 2 & 1) != (id & 1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                if ((filterMode >> 1 & 1) != (id & 1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: 
            case 5: {
                if ((filterMode & 1) != (id & 1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private ItemStack getFluidDisplayItem(CoverFluidfilter coverData) {
        if (coverData == null) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((int)coverData.getFluidId());
        return GTUtility.getFluidDisplayStack(fluid);
    }
}

