/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketDecodeAtProcess;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.covers.Cover;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class GTPacketSendCoverData
extends GTPacket {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected ForgeDirection side;
    protected int coverID;
    protected Cover cover;

    public GTPacketSendCoverData() {
    }

    public GTPacketSendCoverData(Cover cover, ICoverable tile, ForgeDirection side) {
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.coverID = cover.getCoverID();
        this.side = side;
        this.cover = cover;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.SEND_COVER_DATA.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeInt(this.coverID);
        aOut.writeByte(this.side.ordinal());
        this.cover.writeToByteBuf(aOut);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        return new GTPacketDecodeAtProcess(aData, GTPacketSendCoverData::decodeAndProcess);
    }

    public static void decodeAndProcess(ByteArrayDataInput data, IBlockAccess world) {
        CoverableTileEntity coverable;
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(data.readInt(), (int)data.readShort(), data.readInt());
        if (tile instanceof CoverableTileEntity && !(coverable = (CoverableTileEntity)tile).isDead()) {
            coverable.updateAttachedCover(data);
        }
    }

    @Override
    public void process(IBlockAccess aWorld) {
    }
}

